/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

final class AssertJObjectRules {
    private AssertJObjectRules() {
    }

    static final class AssertThatHasToString<T> {
        AssertThatHasToString() {
        }

        AbstractStringAssert<?> before(T object, String str) {
            return Assertions.assertThat((String)object.toString()).isEqualTo(str);
        }

        ObjectAssert<T> after(T object, String str) {
            return (ObjectAssert)Assertions.assertThat(object).hasToString(str);
        }
    }

    static final class AssertThatIsIsNotEqualTo<S, T> {
        AssertThatIsIsNotEqualTo() {
        }

        AbstractBooleanAssert<?> before(S object1, T object2) {
            return Assertions.assertThat((boolean)object1.equals(object2)).isFalse();
        }

        ObjectAssert<S> after(S object1, T object2) {
            return (ObjectAssert)Assertions.assertThat(object1).isNotEqualTo(object2);
        }
    }

    static final class AssertThatIsIsEqualTo<S, T> {
        AssertThatIsIsEqualTo() {
        }

        AbstractBooleanAssert<?> before(S object1, T object2) {
            return Assertions.assertThat((boolean)object1.equals(object2)).isTrue();
        }

        ObjectAssert<S> after(S object1, T object2) {
            return (ObjectAssert)Assertions.assertThat(object1).isEqualTo(object2);
        }
    }

    static final class AssertThatIsNotInstanceOf<S, T> {
        AssertThatIsNotInstanceOf() {
        }

        AbstractBooleanAssert<?> before(S object) {
            return Assertions.assertThat((boolean)Refaster.isInstance(object)).isFalse();
        }

        ObjectAssert<S> after(S object) {
            return (ObjectAssert)Assertions.assertThat(object).isNotInstanceOf(Refaster.clazz());
        }
    }

    static final class AssertThatIsInstanceOf<S, T> {
        AssertThatIsInstanceOf() {
        }

        AbstractBooleanAssert<?> before(S object) {
            return Assertions.assertThat((boolean)Refaster.isInstance(object)).isTrue();
        }

        ObjectAssert<S> after(S object) {
            return (ObjectAssert)Assertions.assertThat(object).isInstanceOf(Refaster.clazz());
        }
    }
}

