/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;

final class AssertJShortRules {
    private AssertJShortRules() {
    }

    static final class AbstractShortAssertIsOne {
        AbstractShortAssertIsOne() {
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isOne();
        }

        AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isEqualTo((short)1);
        }
    }

    static final class AbstractShortAssertIsNotZero {
        AbstractShortAssertIsNotZero() {
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isNotZero();
        }

        AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isNotEqualTo((short)0);
        }
    }

    static final class AbstractShortAssertIsZero {
        AbstractShortAssertIsZero() {
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isZero();
        }

        AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isEqualTo((short)0);
        }
    }

    static final class AbstractShortAssertIsNotEqualTo {
        AbstractShortAssertIsNotEqualTo() {
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert, short n) {
            return (AbstractShortAssert)Refaster.anyOf((Object[])new AbstractShortAssert[]{shortAssert.isNotCloseTo(n, Offset.offset((Number)0)), shortAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert, short n) {
            return shortAssert.isNotEqualTo(n);
        }
    }

    static final class AbstractShortAssertIsEqualTo {
        AbstractShortAssertIsEqualTo() {
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert, short n) {
            return (AbstractShortAssert)Refaster.anyOf((Object[])new AbstractShortAssert[]{shortAssert.isCloseTo(n, Offset.offset((Number)0)), shortAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert, short n) {
            return shortAssert.isEqualTo(n);
        }
    }
}

