/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

final class ImmutableListRules {
    private ImmutableListRules() {
    }

    static final class ImmutableListOf5<T> {
        ImmutableListOf5() {
        }

        List<T> before(T e1, T e2, T e3, T e4, T e5) {
            return List.of(e1, e2, e3, e4, e5);
        }

        ImmutableList<T> after(T e1, T e2, T e3, T e4, T e5) {
            return ImmutableList.of(e1, e2, e3, e4, e5);
        }
    }

    static final class ImmutableListOf4<T> {
        ImmutableListOf4() {
        }

        List<T> before(T e1, T e2, T e3, T e4) {
            return List.of(e1, e2, e3, e4);
        }

        ImmutableList<T> after(T e1, T e2, T e3, T e4) {
            return ImmutableList.of(e1, e2, e3, e4);
        }
    }

    static final class ImmutableListOf3<T> {
        ImmutableListOf3() {
        }

        List<T> before(T e1, T e2, T e3) {
            return List.of(e1, e2, e3);
        }

        ImmutableList<T> after(T e1, T e2, T e3) {
            return ImmutableList.of(e1, e2, e3);
        }
    }

    static final class ImmutableListOf2<T> {
        ImmutableListOf2() {
        }

        List<T> before(T e1, T e2) {
            return List.of(e1, e2);
        }

        ImmutableList<T> after(T e1, T e2) {
            return ImmutableList.of(e1, e2);
        }
    }

    static final class ImmutableListOf1<T> {
        ImmutableListOf1() {
        }

        List<T> before(T e1) {
            return (List)Refaster.anyOf((Object[])new List[]{ImmutableList.builder().add(e1).build(), Collections.singletonList(e1), List.of(e1)});
        }

        ImmutableList<T> after(T e1) {
            return ImmutableList.of(e1);
        }
    }

    static final class ImmutableListOf<T> {
        ImmutableListOf() {
        }

        List<T> before() {
            return (List)Refaster.anyOf((Object[])new List[]{ImmutableList.builder().build(), (List)Stream.empty().collect(ImmutableList.toImmutableList()), Collections.emptyList(), List.of()});
        }

        ImmutableList<T> after() {
            return ImmutableList.of();
        }
    }

    static final class StreamToDistinctImmutableList<T> {
        StreamToDistinctImmutableList() {
        }

        ImmutableList<T> before(Stream<T> stream) {
            return (ImmutableList)stream.distinct().collect(ImmutableList.toImmutableList());
        }

        ImmutableList<T> after(Stream<T> stream) {
            return ((ImmutableSet)stream.collect(ImmutableSet.toImmutableSet())).asList();
        }
    }

    static final class ImmutableListSortedCopyOfWithCustomComparator<T> {
        ImmutableListSortedCopyOfWithCustomComparator() {
        }

        ImmutableList<T> before(Iterable<T> iterable, Comparator<T> cmp) {
            return (ImmutableList)Streams.stream(iterable).sorted(cmp).collect(ImmutableList.toImmutableList());
        }

        ImmutableList<T> before(Collection<T> iterable, Comparator<T> cmp) {
            return (ImmutableList)iterable.stream().sorted(cmp).collect(ImmutableList.toImmutableList());
        }

        ImmutableList<T> after(Collection<T> iterable, Comparator<? super T> cmp) {
            return ImmutableList.sortedCopyOf(cmp, iterable);
        }
    }

    static final class ImmutableListSortedCopyOf<T extends Comparable<? super T>> {
        ImmutableListSortedCopyOf() {
        }

        ImmutableList<T> before(Iterable<T> iterable) {
            return (ImmutableList)Refaster.anyOf((Object[])new ImmutableList[]{ImmutableList.sortedCopyOf(Comparator.naturalOrder(), iterable), (ImmutableList)Streams.stream(iterable).sorted().collect(ImmutableList.toImmutableList())});
        }

        ImmutableList<T> before(Collection<T> iterable) {
            return (ImmutableList)iterable.stream().sorted().collect(ImmutableList.toImmutableList());
        }

        ImmutableList<T> after(Collection<T> iterable) {
            return ImmutableList.sortedCopyOf(iterable);
        }
    }

    static final class StreamToImmutableList<T> {
        StreamToImmutableList() {
        }

        ImmutableList<T> before(Stream<T> stream) {
            return ImmutableList.copyOf(stream.iterator());
        }

        ImmutableList<T> after(Stream<T> stream) {
            return (ImmutableList)stream.collect(ImmutableList.toImmutableList());
        }
    }

    static final class IterableToImmutableList<T> {
        IterableToImmutableList() {
        }

        ImmutableList<T> before(T[] iterable) {
            return (ImmutableList)Refaster.anyOf((Object[])new ImmutableList[]{ImmutableList.builder().add((Object[])iterable).build(), (ImmutableList)Arrays.stream(iterable).collect(ImmutableList.toImmutableList())});
        }

        ImmutableList<T> before(Iterator<T> iterable) {
            return (ImmutableList)Refaster.anyOf((Object[])new ImmutableList[]{ImmutableList.builder().addAll(iterable).build(), (ImmutableList)Streams.stream(iterable).collect(ImmutableList.toImmutableList())});
        }

        ImmutableList<T> before(Iterable<T> iterable) {
            return (ImmutableList)Refaster.anyOf((Object[])new ImmutableList[]{ImmutableList.builder().addAll(iterable).build(), (ImmutableList)Streams.stream(iterable).collect(ImmutableList.toImmutableList())});
        }

        ImmutableList<T> before(Collection<T> iterable) {
            return (ImmutableList)iterable.stream().collect(ImmutableList.toImmutableList());
        }

        ImmutableList<T> after(Iterable<T> iterable) {
            return ImmutableList.copyOf(iterable);
        }
    }

    static final class ImmutableListBuilder<T> {
        ImmutableListBuilder() {
        }

        ImmutableList.Builder<T> before() {
            return new ImmutableList.Builder();
        }

        ImmutableList.Builder<T> after() {
            return ImmutableList.builder();
        }
    }
}

