/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.api.http;

import com.sun.net.httpserver.Headers;
import cz.cesnet.cloud.occi.Collection;
import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.api.Authentication;
import cz.cesnet.cloud.occi.api.Client;
import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.api.http.HTTPConnection;
import cz.cesnet.cloud.occi.api.http.HTTPHelper;
import cz.cesnet.cloud.occi.api.http.auth.HTTPAuthentication;
import cz.cesnet.cloud.occi.api.http.auth.NoAuthentication;
import cz.cesnet.cloud.occi.core.ActionInstance;
import cz.cesnet.cloud.occi.core.Entity;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.exception.AmbiguousIdentifierException;
import cz.cesnet.cloud.occi.exception.ParsingException;
import cz.cesnet.cloud.occi.exception.RenderingException;
import cz.cesnet.cloud.occi.parser.CollectionType;
import cz.cesnet.cloud.occi.parser.TextParser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClient
extends Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPClient.class);
    private static final String ACTION_URL_PARAMETER = "?action=";
    private final HTTPConnection connection = new HTTPConnection();
    private HttpHost target;
    private String responseMediaType;
    private String responseBody;
    private String mediaType;
    private Headers responseHeaders;
    private final TextParser parser = new TextParser();

    public HTTPClient(URI endpoint, Authentication authentication, String mediaType, boolean autoconnect) throws CommunicationException {
        System.setProperty("jsse.enableSNIExtension", "false");
        if (endpoint == null) {
            throw new NullPointerException("endpoint cannot be null");
        }
        if (authentication == null) {
            authentication = new NoAuthentication();
        }
        this.setEndpoint(endpoint);
        this.target = new HttpHost(endpoint.getHost(), endpoint.getPort(), endpoint.getScheme());
        this.setAuthentication(authentication);
        this.setMediaType(mediaType);
        if (autoconnect) {
            this.connect();
        }
    }

    public HTTPClient(URI endpoint, Authentication authentication) throws CommunicationException {
        this(endpoint, authentication, "text/plain", true);
    }

    public HTTPClient(URI endpoint) throws CommunicationException {
        this(endpoint, null, "text/plain", false);
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
        this.connection.setMediaType(mediaType);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public void connect() throws CommunicationException {
        Authentication auth = this.getAuthentication();
        if (!(auth instanceof HTTPAuthentication)) {
            throw new CommunicationException("authentication method '" + auth + "' is not a valid HTTP authentication method");
        }
        HTTPAuthentication httpAuth = (HTTPAuthentication)auth;
        httpAuth.setTarget(this.target);
        httpAuth.setConnection(this.connection);
        httpAuth.authenticate();
        this.setConnected(true);
        this.obtainModel();
    }

    private void checkConnection() throws CommunicationException {
        if (!this.isConnected()) {
            this.connect();
        }
    }

    private Headers convertHeaders(Header[] apacheHeaders) {
        Headers javaHeaders = new Headers();
        for (Header header : apacheHeaders) {
            javaHeaders.add(header.getName().toLowerCase(), header.getValue());
        }
        return javaHeaders;
    }

    private void runAndParseRequest(HttpRequest request, int status) throws CommunicationException {
        try (CloseableHttpResponse response = HTTPHelper.runRequest(request, this.target, this.connection.getClient(), this.connection.getContext(), status);){
            this.responseMediaType = response.getFirstHeader("Content-Type").getValue();
            if (this.responseMediaType.contains(";")) {
                this.responseMediaType = this.responseMediaType.substring(0, this.responseMediaType.indexOf(";"));
            }
            this.responseHeaders = this.convertHeaders(response.getAllHeaders());
            this.responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException ex) {
            throw new CommunicationException(ex);
        }
    }

    private void runAndParseRequest(HttpRequest request) throws CommunicationException {
        this.runAndParseRequest(request, 200);
    }

    private void obtainModel() throws CommunicationException {
        try {
            LOGGER.debug("Obtaining model...");
            this.checkConnection();
            HttpGet httpGet = HTTPHelper.prepareGet("/-/", this.connection.getHeaders());
            this.runAndParseRequest((HttpRequest)httpGet);
            this.setModel(this.parser.parseModel(this.responseMediaType, this.responseBody, this.responseHeaders));
            LOGGER.debug("Model: {}", (Object)this.getModel());
        }
        catch (ParsingException ex) {
            throw new CommunicationException(ex);
        }
    }

    @Override
    public List<URI> list() throws CommunicationException {
        return this.list("");
    }

    @Override
    public List<URI> list(String resourceType) throws CommunicationException {
        HttpGet httpGet;
        if (resourceType.isEmpty()) {
            httpGet = HTTPHelper.prepareGet("/", this.connection.getHeaders());
        } else {
            Kind kind;
            try {
                this.checkConnection();
                kind = this.getModel().findKind(resourceType);
            }
            catch (AmbiguousIdentifierException ex) {
                throw new CommunicationException(ex);
            }
            if (kind == null) {
                throw new CommunicationException("unknown resource type '" + resourceType + "'");
            }
            httpGet = HTTPHelper.prepareGet(kind.getLocation(), this.connection.getHeaders());
        }
        return this.runListGet(httpGet);
    }

    @Override
    public List<URI> list(URI resourceIdentifier) throws CommunicationException {
        this.checkConnection();
        Kind kind = this.getModel().findKind(resourceIdentifier);
        if (kind == null) {
            throw new CommunicationException("unknown resource identifier '" + resourceIdentifier + "'");
        }
        HttpGet httpGet = HTTPHelper.prepareGet(kind.getLocation(), this.connection.getHeaders());
        return this.runListGet(httpGet);
    }

    private List<URI> runListGet(HttpGet httpGet) throws CommunicationException {
        try {
            this.checkConnection();
            this.runAndParseRequest((HttpRequest)httpGet);
            List locations = this.parser.parseLocations(this.responseMediaType, this.responseBody, this.responseHeaders);
            LOGGER.debug("Locations: {}", (Object)locations);
            return locations;
        }
        catch (ParsingException ex) {
            throw new CommunicationException(ex);
        }
    }

    @Override
    public List<Entity> describe() throws CommunicationException {
        List<URI> locations = this.list();
        Collection collection = new Collection();
        for (URI location : locations) {
            collection.merge(this.describeLocation(location));
        }
        return this.generateEntityListFromCollection(collection);
    }

    @Override
    public List<Entity> describe(String resourceType) throws CommunicationException {
        this.checkConnection();
        Model model = this.getModel();
        try {
            Kind kind = model.findKind(resourceType);
            if (kind == null) {
                throw new CommunicationException("unknown resource type '" + resourceType + "'");
            }
            CollectionType type = model.findKindType(kind);
            if (type == null) {
                throw new CommunicationException("unknown resource type '" + resourceType + "'");
            }
            return this.describe(this.list(resourceType), type);
        }
        catch (AmbiguousIdentifierException ex) {
            throw new CommunicationException(ex);
        }
    }

    @Override
    public List<Entity> describe(URI resourceIdentifier) throws CommunicationException {
        this.checkConnection();
        Model model = this.getModel();
        Kind kind = model.findKind(resourceIdentifier);
        if (kind != null) {
            CollectionType type = model.findKindType(kind);
            if (type == null) {
                throw new CommunicationException("unknown resource identifier '" + resourceIdentifier + "'");
            }
            return this.describe(this.list(resourceIdentifier), type);
        }
        Collection collection = this.describeLocation(resourceIdentifier);
        return this.generateEntityListFromCollection(collection);
    }

    private Collection describeLocation(URI location) throws CommunicationException {
        location = this.getFullUri(location);
        String path = location.getPath();
        String[] segments = TextParser.divideUriByLastSegment((String)path);
        CollectionType type = this.getModel().findKindType(segments[1]);
        if (type == null) {
            throw new CommunicationException("unknown resource identifier '" + location + "'");
        }
        HttpGet httpGet = HTTPHelper.prepareGet(location, this.connection.getHeaders());
        return this.runDescribeGet(httpGet, type);
    }

    private List<Entity> describe(List<URI> locations, CollectionType type) throws CommunicationException {
        Collection collection = new Collection();
        for (URI location : locations) {
            HttpGet httpGet = HTTPHelper.prepareGet(location, this.connection.getHeaders());
            collection.merge(this.runDescribeGet(httpGet, type));
        }
        return this.generateEntityListFromCollection(collection);
    }

    private List<Entity> generateEntityListFromCollection(Collection collection) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        list.addAll(collection.getLinks());
        list.addAll(collection.getResources());
        return list;
    }

    private Collection runDescribeGet(HttpGet httpGet, CollectionType type) throws CommunicationException {
        try {
            this.checkConnection();
            this.runAndParseRequest((HttpRequest)httpGet);
            Collection collection = this.parser.parseCollection(this.responseMediaType, this.responseBody, this.responseHeaders, type);
            LOGGER.debug("Collection: {}", (Object)collection);
            return collection;
        }
        catch (ParsingException ex) {
            throw new CommunicationException(ex);
        }
    }

    @Override
    public URI create(Entity entity) throws CommunicationException {
        Kind kind = entity.getKind();
        if (kind == null) {
            throw new CommunicationException("entity with empty kind");
        }
        HttpPost httpPost = HTTPHelper.preparePost(kind.getLocation(), this.connection.getHeaders());
        try {
            List locations;
            switch (this.mediaType) {
                case "text/occi": {
                    Headers headers = entity.toHeaders();
                    this.addHeaders((HttpMessage)httpPost, headers);
                    break;
                }
                case "text/plain": {
                    StringEntity httpEntity = new StringEntity(entity.toText());
                    httpPost.setEntity((HttpEntity)httpEntity);
                    break;
                }
                default: {
                    throw new CommunicationException("unsupported media type '" + this.mediaType + "'");
                }
            }
            this.checkConnection();
            this.runAndParseRequest((HttpRequest)httpPost, 201);
            if (!this.responseMediaType.equals("text/occi") && this.responseBody.trim().equals("OK") && this.responseHeaders.containsKey("Location")) {
                this.responseMediaType = "text/occi";
            }
            if ((locations = this.parser.parseLocations(this.responseMediaType, this.responseBody, this.responseHeaders)) == null || locations.isEmpty()) {
                throw new CommunicationException("no location returned");
            }
            return (URI)locations.get(0);
        }
        catch (ParsingException | RenderingException | UnsupportedEncodingException ex) {
            throw new CommunicationException(ex);
        }
    }

    @Override
    public boolean delete(String resourceType) throws CommunicationException {
        Kind kind;
        try {
            this.checkConnection();
            kind = this.getModel().findKind(resourceType);
        }
        catch (AmbiguousIdentifierException ex) {
            throw new CommunicationException(ex);
        }
        if (kind == null) {
            throw new CommunicationException("unknown resource type '" + resourceType + "'");
        }
        HttpDelete httpDelete = HTTPHelper.prepareDelete(kind.getLocation(), this.connection.getHeaders());
        this.checkConnection();
        return HTTPHelper.runRequestForStatus((HttpRequest)httpDelete, this.target, this.connection.getClient(), this.connection.getContext());
    }

    @Override
    public boolean delete(URI resourceIdentifier) throws CommunicationException {
        HttpDelete httpDelete;
        this.checkConnection();
        Kind kind = this.getModel().findKind(resourceIdentifier);
        if (kind != null) {
            httpDelete = HTTPHelper.prepareDelete(kind.getLocation(), this.connection.getHeaders());
        } else {
            resourceIdentifier = this.getFullUri(resourceIdentifier);
            httpDelete = HTTPHelper.prepareDelete(resourceIdentifier, this.connection.getHeaders());
        }
        this.checkConnection();
        return HTTPHelper.runRequestForStatus((HttpRequest)httpDelete, this.target, this.connection.getClient(), this.connection.getContext());
    }

    @Override
    public boolean trigger(String resourceType, ActionInstance action) throws CommunicationException {
        Kind kind;
        try {
            this.checkConnection();
            kind = this.getModel().findKind(resourceType);
        }
        catch (AmbiguousIdentifierException ex) {
            throw new CommunicationException(ex);
        }
        if (kind == null) {
            throw new CommunicationException("unknown resource type '" + resourceType + "'");
        }
        try {
            String url = kind.getLocation().toString() + ACTION_URL_PARAMETER + action.getAction().getTerm();
            HttpPost httpPost = HTTPHelper.preparePost(url, this.connection.getHeaders());
            switch (this.mediaType) {
                case "text/occi": {
                    Headers headers = action.toHeaders();
                    this.addHeaders((HttpMessage)httpPost, headers);
                    break;
                }
                case "text/plain": {
                    StringEntity httpEntity = new StringEntity(action.toText());
                    httpPost.setEntity((HttpEntity)httpEntity);
                    break;
                }
                default: {
                    throw new CommunicationException("unsupported media type '" + this.mediaType + "'");
                }
            }
            this.checkConnection();
            return HTTPHelper.runRequestForStatus((HttpRequest)httpPost, this.target, this.connection.getClient(), this.connection.getContext());
        }
        catch (UnsupportedEncodingException ex) {
            throw new CommunicationException(ex);
        }
    }

    @Override
    public boolean trigger(URI resourceIdentifier, ActionInstance action) throws CommunicationException {
        String url;
        this.checkConnection();
        Kind kind = this.getModel().findKind(resourceIdentifier);
        if (kind != null) {
            url = kind.getLocation().toString() + ACTION_URL_PARAMETER + action.getAction().getTerm();
        } else {
            resourceIdentifier = this.getFullUri(resourceIdentifier);
            url = resourceIdentifier.toString() + ACTION_URL_PARAMETER + action.getAction().getTerm();
        }
        HttpPost httpPost = HTTPHelper.preparePost(url, this.connection.getHeaders());
        try {
            switch (this.mediaType) {
                case "text/occi": {
                    Headers headers = action.toHeaders();
                    this.addHeaders((HttpMessage)httpPost, headers);
                    break;
                }
                case "text/plain": {
                    StringEntity httpEntity = new StringEntity(action.toText());
                    httpPost.setEntity((HttpEntity)httpEntity);
                    break;
                }
                default: {
                    throw new CommunicationException("unsupported media type '" + this.mediaType + "'");
                }
            }
            this.checkConnection();
            return HTTPHelper.runRequestForStatus((HttpRequest)httpPost, this.target, this.connection.getClient(), this.connection.getContext());
        }
        catch (UnsupportedEncodingException ex) {
            throw new CommunicationException(ex);
        }
    }

    private URI getFullUri(URI uri) throws CommunicationException {
        if (uri.getHost() == null) {
            try {
                uri = new URI(this.getEndpoint().toString() + uri.toString()).normalize();
            }
            catch (URISyntaxException ex) {
                throw new CommunicationException(ex);
            }
        }
        return uri;
    }

    private void addHeaders(HttpMessage message, Headers headers) {
        for (String headerName : headers.keySet()) {
            Iterator i$ = headers.get(headerName).iterator();
            while (i$.hasNext()) {
                String value = (String)i$.next();
                message.addHeader(headerName, value);
            }
        }
    }

    @Override
    public void refresh() throws CommunicationException {
        this.obtainModel();
    }
}

