/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.api.http.auth;

import cz.cesnet.cloud.occi.api.Authentication;
import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.api.http.auth.HTTPAuthentication;
import cz.cesnet.cloud.occi.api.http.auth.KeystoneAuthentication;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthentication
extends HTTPAuthentication {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthentication.class);
    public static final String IDENTIFIER = "OCCIBasicAuthentication";
    private String username;
    private String password;
    private String authScheme;

    public BasicAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
        this.authScheme = "Basic";
    }

    protected void setAuthScheme(String authScheme) {
        this.authScheme = authScheme;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Authentication getFallback() {
        return new KeystoneAuthentication(this);
    }

    @Override
    public void authenticate() throws CommunicationException {
        LOGGER.debug("Creating credentials provider with username: '{}' and password: '{}'", (Object)this.username, (Object)this.password);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(this.getTarget().getHostName(), this.getTarget().getPort(), null, this.authScheme), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        this.setCredentialsProvider((CredentialsProvider)credsProvider);
        super.authenticate();
    }
}

