/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.api.http.auth;

import cz.cesnet.cloud.occi.api.Authentication;
import cz.cesnet.cloud.occi.api.exception.AuthenticationException;
import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.api.http.HTTPConnection;
import cz.cesnet.cloud.occi.api.http.HTTPHelper;
import cz.cesnet.cloud.occi.api.http.auth.KeystoneAuthentication;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTPAuthentication
implements Authentication {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPAuthentication.class);
    private HttpHost target;
    private HTTPConnection connection;
    private CredentialsProvider credentialsProvider;
    private String CAPath;
    private String CAFile;

    public HttpHost getTarget() {
        return this.target;
    }

    public void setTarget(HttpHost target) {
        this.target = target;
    }

    public HTTPConnection getConnection() {
        return this.connection;
    }

    public void setConnection(HTTPConnection connection) {
        this.connection = connection;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public String getCAPath() {
        return this.CAPath;
    }

    public void setCAPath(String CAPath) {
        this.CAPath = CAPath;
    }

    public String getCAFile() {
        return this.CAFile;
    }

    public void setCAFile(String CAFile) {
        this.CAFile = CAFile;
    }

    @Override
    public abstract String getIdentifier();

    @Override
    public abstract Authentication getFallback();

    protected SSLContext createSSLContext() throws AuthenticationException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStore keyStore = this.loadCAs();
        try {
            SSLContext sslContext = keyStore == null ? SSLContexts.createSystemDefault() : SSLContexts.custom().loadTrustMaterial(keyStore).build();
            return sslContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex);
        }
    }

    @Override
    public void authenticate() throws CommunicationException {
        block19: {
            SSLContext sslContext = this.createSSLContext();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            LOGGER.debug("Running authentication...");
            try {
                RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
                HttpClientBuilder builder = HttpClients.custom().setDefaultCredentialsProvider(this.credentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(defaultRequestConfig);
                if (LOGGER.isDebugEnabled()) {
                    builder.disableContentCompression();
                }
                CloseableHttpClient client = builder.build();
                this.connection.setClient(client);
                HttpHead httpHead = HTTPHelper.prepareHead("/-/", this.connection.getHeaders());
                try (CloseableHttpResponse response = this.connection.getClient().execute(this.target, (HttpRequest)httpHead, this.connection.getContext());){
                    if (response.getStatusLine().getStatusCode() == 200) break block19;
                    Authentication fallback = this.getFallback();
                    if (response.getStatusLine().getStatusCode() == 401 && fallback != null) {
                        if (fallback instanceof KeystoneAuthentication) {
                            LOGGER.debug("Running Keystone fallback...");
                            KeystoneAuthentication ka = (KeystoneAuthentication)fallback;
                            ka.setOriginalResponse(response);
                            ka.authenticate();
                            break block19;
                        }
                        throw new AuthenticationException("unknown fallback method");
                    }
                    if (response.getEntity() == null) {
                        LOGGER.error("Response: {}\nHeaders: {}\nBody:\n", (Object)response.getStatusLine().toString(), (Object)response.getAllHeaders());
                    } else {
                        LOGGER.error("Response: {}\nHeaders: {}\nBody: {}", new Object[]{response.getStatusLine().toString(), response.getAllHeaders(), EntityUtils.toString((HttpEntity)response.getEntity())});
                    }
                    throw new AuthenticationException(response.getStatusLine().toString());
                }
            }
            catch (IOException ex) {
                throw new CommunicationException(ex);
            }
        }
    }

    protected KeyStore loadCAs() throws AuthenticationException {
        KeyStore keyStore = null;
        if (this.CAFile != null && !this.CAFile.isEmpty()) {
            keyStore = this.loadCAsFromFile();
        } else if (this.CAPath != null && !this.CAPath.isEmpty()) {
            keyStore = this.loadCAsFromPath();
        }
        return keyStore;
    }

    private KeyStore loadCAsFromFile() throws AuthenticationException {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream instream = new FileInputStream(new File(this.CAFile));
            trustStore.load(instream, null);
            return trustStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new AuthenticationException(ex);
        }
    }

    private KeyStore loadCAsFromPath() throws AuthenticationException {
        try {
            File CADir = new File(this.CAPath);
            if (!CADir.isDirectory()) {
                throw new AuthenticationException("'" + this.CAPath + "' is not a directory.");
            }
            FilenameFilter fileNameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    int lastIndex;
                    String str;
                    return name.lastIndexOf(46) > 0 && (str = name.substring(lastIndex = name.lastIndexOf(46))).equals(".pem");
                }
            };
            File[] certs = CADir.listFiles(fileNameFilter);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ArrayList<X509Certificate> rootCertificates = new ArrayList<X509Certificate>();
            for (File cert : certs) {
                PEMReader reader = new PEMReader((Reader)new InputStreamReader(new FileInputStream(cert)));
                rootCertificates.add((X509Certificate)reader.readObject());
            }
            for (Certificate certificate : rootCertificates) {
                X509Certificate x509Cert = (X509Certificate)certificate;
                ks.setCertificateEntry(x509Cert.getSubjectX500Principal().getName(), x509Cert);
                LOGGER.debug("adding certificate: " + x509Cert.getSubjectX500Principal().getName());
            }
            return ks;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new AuthenticationException(ex);
        }
    }
}

