/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.freemarker.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class TemplateSetBuildItem
extends MultiBuildItem {
    private final Optional<String> basePath;
    private final List<String> excludeGlobs;
    private final List<String> includeGlobs;

    private TemplateSetBuildItem(Optional<String> basePath, List<String> includeGlobs, List<String> excludeGlobs) {
        this.basePath = basePath;
        this.includeGlobs = includeGlobs;
        this.excludeGlobs = excludeGlobs;
    }

    public Optional<String> getBasePath() {
        return this.basePath;
    }

    public List<String> getExcludeGlobs() {
        return this.excludeGlobs;
    }

    public List<String> getIncludeGlobs() {
        return this.includeGlobs;
    }

    public String resolve(String relativePath) {
        return this.basePath.map(bPath -> bPath + "/" + relativePath).orElse(relativePath);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<String> basePath = Optional.empty();
        private List<String> excludeGlobs = new ArrayList<String>();
        private List<String> includeGlobs = new ArrayList<String>();

        public TemplateSetBuildItem build() {
            List<String> incl = this.includeGlobs;
            this.includeGlobs = null;
            List<String> excl = this.excludeGlobs;
            this.excludeGlobs = null;
            return new TemplateSetBuildItem(this.basePath, Collections.unmodifiableList(incl), Collections.unmodifiableList(excl));
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath == null || basePath.isEmpty() ? Optional.empty() : Optional.of(basePath);
            return this;
        }

        public Builder excludeGlob(String glob) {
            this.excludeGlobs.add(glob);
            return this;
        }

        public Builder excludeGlobs(Collection<String> globs) {
            this.excludeGlobs.addAll(globs);
            return this;
        }

        public Builder excludeGlobs(String ... globs) {
            Stream.of(globs).forEach(this.excludeGlobs::add);
            return this;
        }

        public Builder includeGlob(String glob) {
            this.includeGlobs.add(glob);
            return this;
        }

        public Builder includeGlobs(Collection<String> globs) {
            this.includeGlobs.addAll(globs);
            return this;
        }

        public Builder includeGlobs(String ... patterns) {
            Stream.of(patterns).forEach(this.includeGlobs::add);
            return this;
        }
    }
}

