/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassOutput;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class GeneratedClassGizmoAdaptor
implements ClassOutput {
    private final BuildProducer<GeneratedClassBuildItem> generatedClasses;
    private final Predicate<String> applicationClassPredicate;
    private final Map<String, StringWriter> sources;

    public GeneratedClassGizmoAdaptor(BuildProducer<GeneratedClassBuildItem> generatedClasses, final boolean applicationClass) {
        this(generatedClasses, new Predicate<String>(){

            @Override
            public boolean test(String t) {
                return applicationClass;
            }
        });
    }

    public GeneratedClassGizmoAdaptor(BuildProducer<GeneratedClassBuildItem> generatedClasses, Predicate<String> applicationClassPredicate) {
        this.generatedClasses = generatedClasses;
        this.applicationClassPredicate = applicationClassPredicate;
        this.sources = BootstrapDebug.DEBUG_SOURCES_DIR != null ? new ConcurrentHashMap() : null;
    }

    public GeneratedClassGizmoAdaptor(BuildProducer<GeneratedClassBuildItem> generatedClasses, final Function<String, String> generatedToBaseNameFunction) {
        this.generatedClasses = generatedClasses;
        this.applicationClassPredicate = new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return GeneratedClassGizmoAdaptor.isApplicationClass((String)generatedToBaseNameFunction.apply(s));
            }
        };
        this.sources = BootstrapDebug.DEBUG_SOURCES_DIR != null ? new ConcurrentHashMap() : null;
    }

    public void write(String className, byte[] bytes) {
        StringWriter sw;
        String source = null;
        if (this.sources != null && (sw = this.sources.get(className)) != null) {
            source = sw.toString();
        }
        this.generatedClasses.produce(new GeneratedClassBuildItem(this.applicationClassPredicate.test(className), className, bytes, source));
    }

    public Writer getSourceWriter(String className) {
        if (this.sources != null) {
            StringWriter writer = new StringWriter();
            this.sources.put(className, writer);
            return writer;
        }
        return super.getSourceWriter(className);
    }

    public static boolean isApplicationClass(String className) {
        QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
        List res = cl.getElementsWithResource(className.replace(".", "/") + ".class", true);
        return !res.isEmpty();
    }
}

