/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb;

import com.mongodb.client.model.Collation;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

public class DistinctOptions {
    private Bson filter;
    private long maxTime;
    private TimeUnit maxTimeUnit;
    private Collation collation;

    public DistinctOptions filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    public DistinctOptions maxTime(long maxTime, TimeUnit timeUnit) {
        this.maxTime = maxTime;
        this.maxTimeUnit = timeUnit;
        return this;
    }

    public DistinctOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public <T> DistinctPublisher<T> apply(DistinctPublisher<T> stream) {
        DistinctPublisher publisher = stream;
        if (this.collation != null) {
            publisher = publisher.collation(this.collation);
        }
        if (this.maxTime > 0L) {
            publisher = publisher.maxTime(this.maxTime, this.maxTimeUnit);
        }
        if (this.filter != null) {
            publisher = publisher.filter(this.filter);
        }
        return publisher;
    }
}

