/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.scheduler.common.runtime.util.SchedulerUtils;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractJobDefinition
implements Scheduler.JobDefinition {
    protected final String identity;
    protected String cron = "";
    protected String every = "";
    protected String delayed = "";
    protected String overdueGracePeriod = "";
    protected Scheduled.ConcurrentExecution concurrentExecution = Scheduled.ConcurrentExecution.PROCEED;
    protected Scheduled.SkipPredicate skipPredicate = null;
    protected Class<? extends Scheduled.SkipPredicate> skipPredicateClass;
    protected Consumer<ScheduledExecution> task;
    protected Class<? extends Consumer<ScheduledExecution>> taskClass;
    protected Function<ScheduledExecution, Uni<Void>> asyncTask;
    protected Class<? extends Function<ScheduledExecution, Uni<Void>>> asyncTaskClass;
    protected boolean scheduled = false;
    protected String timeZone = "<<default timezone>>";
    protected boolean runOnVirtualThread;

    public AbstractJobDefinition(String identity) {
        this.identity = identity;
    }

    public Scheduler.JobDefinition setCron(String cron) {
        this.checkScheduled();
        this.cron = cron;
        return this;
    }

    public Scheduler.JobDefinition setInterval(String every) {
        this.checkScheduled();
        this.every = every;
        return this;
    }

    public Scheduler.JobDefinition setDelayed(String period) {
        this.checkScheduled();
        this.delayed = period;
        return this;
    }

    public Scheduler.JobDefinition setConcurrentExecution(Scheduled.ConcurrentExecution concurrentExecution) {
        this.checkScheduled();
        this.concurrentExecution = concurrentExecution;
        return this;
    }

    public Scheduler.JobDefinition setSkipPredicate(Scheduled.SkipPredicate skipPredicate) {
        this.checkScheduled();
        this.skipPredicate = skipPredicate;
        return this;
    }

    public Scheduler.JobDefinition setSkipPredicate(Class<? extends Scheduled.SkipPredicate> skipPredicateClass) {
        this.skipPredicateClass = skipPredicateClass;
        return this.setSkipPredicate(SchedulerUtils.instantiateBeanOrClass(skipPredicateClass));
    }

    public Scheduler.JobDefinition setOverdueGracePeriod(String period) {
        this.checkScheduled();
        this.overdueGracePeriod = period;
        return this;
    }

    public Scheduler.JobDefinition setTimeZone(String timeZone) {
        this.checkScheduled();
        this.timeZone = timeZone;
        return this;
    }

    public Scheduler.JobDefinition setTask(Consumer<ScheduledExecution> task, boolean runOnVirtualThread) {
        this.checkScheduled();
        if (this.asyncTask != null) {
            throw new IllegalStateException("Async task was already set");
        }
        this.task = task;
        this.runOnVirtualThread = runOnVirtualThread;
        return this;
    }

    public Scheduler.JobDefinition setTask(Class<? extends Consumer<ScheduledExecution>> taskClass, boolean runOnVirtualThread) {
        this.taskClass = taskClass;
        return this.setTask(SchedulerUtils.instantiateBeanOrClass(taskClass), runOnVirtualThread);
    }

    public Scheduler.JobDefinition setAsyncTask(Function<ScheduledExecution, Uni<Void>> asyncTask) {
        this.checkScheduled();
        if (this.task != null) {
            throw new IllegalStateException("Sync task was already set");
        }
        this.asyncTask = asyncTask;
        return this;
    }

    public Scheduler.JobDefinition setAsyncTask(Class<? extends Function<ScheduledExecution, Uni<Void>>> asyncTaskClass) {
        this.asyncTaskClass = asyncTaskClass;
        return this.setAsyncTask(SchedulerUtils.instantiateBeanOrClass(asyncTaskClass));
    }

    protected void checkScheduled() {
        if (this.scheduled) {
            throw new IllegalStateException("Cannot modify a job that was already scheduled");
        }
    }
}

