/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.smallrye.mutiny.Uni;
import java.security.Permission;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;

@RequestScoped
public class SecurityIdentityProxy
implements SecurityIdentity {
    @Inject
    SecurityIdentityAssociation association;

    public Principal getPrincipal() {
        return this.association.getIdentity().getPrincipal();
    }

    public boolean isAnonymous() {
        return this.association.getIdentity().isAnonymous();
    }

    public Set<String> getRoles() {
        return this.association.getIdentity().getRoles();
    }

    public boolean hasRole(String role) {
        return this.association.getIdentity().hasRole(role);
    }

    public <T extends Credential> T getCredential(Class<T> credentialType) {
        return (T)this.association.getIdentity().getCredential(credentialType);
    }

    public Set<Credential> getCredentials() {
        return this.association.getIdentity().getCredentials();
    }

    public <T> T getAttribute(String name) {
        return (T)this.association.getIdentity().getAttribute(name);
    }

    public Map<String, Object> getAttributes() {
        return this.association.getIdentity().getAttributes();
    }

    public Uni<Boolean> checkPermission(Permission permission) {
        return this.association.getIdentity().checkPermission(permission);
    }

    public boolean checkPermissionBlocking(Permission permission) {
        return this.association.getIdentity().checkPermissionBlocking(permission);
    }
}

