/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.filter;

import io.quarkus.smallrye.openapi.common.deployment.SmallRyeOpenApiConfig;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.logging.Logger;

public class SecurityConfigFilter
implements OASFilter {
    private static final Logger log = Logger.getLogger(SecurityConfigFilter.class);
    private final SmallRyeOpenApiConfig config;

    public SecurityConfigFilter(SmallRyeOpenApiConfig config) {
        this.config = config;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        Map<String, SecurityScheme> securitySchemes;
        if (this.config.securityScheme.isPresent()) {
            if (openAPI.getComponents() == null) {
                openAPI.setComponents(OASFactory.createComponents());
            }
            securitySchemes = new HashMap();
            if (openAPI.getComponents().getSecuritySchemes() != null && !openAPI.getComponents().getSecuritySchemes().isEmpty()) {
                securitySchemes.putAll(openAPI.getComponents().getSecuritySchemes());
            }
            SmallRyeOpenApiConfig.SecurityScheme securitySchemeOption = (SmallRyeOpenApiConfig.SecurityScheme)this.config.securityScheme.get();
            SecurityScheme securityScheme = OASFactory.createSecurityScheme();
            securityScheme.setDescription(this.config.securitySchemeDescription);
            switch (securitySchemeOption) {
                case basic: {
                    securityScheme.setType(SecurityScheme.Type.HTTP);
                    securityScheme.setScheme(this.config.basicSecuritySchemeValue);
                    break;
                }
                case jwt: {
                    securityScheme.setType(SecurityScheme.Type.HTTP);
                    securityScheme.setScheme(this.config.jwtSecuritySchemeValue);
                    securityScheme.setBearerFormat(this.config.jwtBearerFormat);
                    break;
                }
                case oidc: {
                    securityScheme.setType(SecurityScheme.Type.OPENIDCONNECT);
                    securityScheme.setOpenIdConnectUrl((String)this.config.oidcOpenIdConnectUrl.orElse(null));
                    break;
                }
                case oauth2Implicit: {
                    securityScheme.setType(SecurityScheme.Type.OAUTH2);
                    OAuthFlows oAuthFlows = OASFactory.createOAuthFlows();
                    OAuthFlow oAuthFlow = OASFactory.createOAuthFlow();
                    if (this.config.oauth2ImplicitAuthorizationUrl.isPresent()) {
                        oAuthFlow.authorizationUrl((String)this.config.oauth2ImplicitAuthorizationUrl.get());
                    }
                    if (this.config.oauth2ImplicitRefreshUrl.isPresent()) {
                        oAuthFlow.refreshUrl((String)this.config.oauth2ImplicitRefreshUrl.get());
                    }
                    if (this.config.oauth2ImplicitTokenUrl.isPresent()) {
                        oAuthFlow.tokenUrl((String)this.config.oauth2ImplicitTokenUrl.get());
                    }
                    oAuthFlows.setImplicit(oAuthFlow);
                    securityScheme.setType(SecurityScheme.Type.OAUTH2);
                    securityScheme.setFlows(oAuthFlows);
                }
            }
            securitySchemes.put(this.config.securitySchemeName, securityScheme);
            openAPI.getComponents().setSecuritySchemes(securitySchemes);
        }
        if (openAPI.getComponents() != null && openAPI.getComponents().getSecuritySchemes() != null && (securitySchemes = openAPI.getComponents().getSecuritySchemes()).size() > 1) {
            log.warn((Object)("Detected multiple Security Schemes, only one scheme is supported at the moment " + securitySchemes.keySet().toString()));
        }
    }
}

