/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime.devconsole;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.smallrye.reactivemessaging.runtime.SmallRyeReactiveMessagingRecorder;
import io.quarkus.smallrye.reactivemessaging.runtime.devconsole.Connectors;
import io.quarkus.smallrye.reactivemessaging.runtime.devconsole.DevConsoleRecorder;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.providers.extension.ChannelConfiguration;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class DevReactiveMessagingInfos {
    private final LazyValue<List<DevChannelInfo>> channels = new LazyValue((Supplier)new Supplier<List<DevChannelInfo>>(){

        @Override
        public List<DevChannelInfo> get() {
            ArcContainer container = Arc.container();
            SmallRyeReactiveMessagingRecorder.SmallRyeReactiveMessagingContext context = (SmallRyeReactiveMessagingRecorder.SmallRyeReactiveMessagingContext)container.instance(SmallRyeReactiveMessagingRecorder.SmallRyeReactiveMessagingContext.class, new Annotation[0]).get();
            HashMap<String, Component> publishers = new HashMap<String, Component>();
            HashMap<String, List> consumers = new HashMap<String, List>();
            Function<String, List> fun = e -> new ArrayList();
            Connectors connectors = (Connectors)container.instance(Connectors.class, new Annotation[0]).get();
            publishers.putAll(connectors.outgoingConnectors);
            for (Map.Entry<String, Component> entry : connectors.incomingConnectors.entrySet()) {
                consumers.computeIfAbsent(entry.getKey(), fun).add(entry.getValue());
            }
            for (EmitterConfiguration emitterConfiguration : context.getEmitterConfigurations()) {
                publishers.put(emitterConfiguration.name(), new Component(ComponentType.EMITTER, (String)(emitterConfiguration.broadcast() ? "<span class=\"annotation\">&#64;Broadcast</span> " : DevReactiveMessagingInfos.asCode(DevConsoleRecorder.EMITTERS.get(emitterConfiguration.name())))));
            }
            for (ChannelConfiguration channelConfiguration : context.getChannelConfigurations()) {
                consumers.computeIfAbsent(channelConfiguration.channelName, fun).add(new Component(ComponentType.CHANNEL, DevReactiveMessagingInfos.asCode(DevConsoleRecorder.CHANNELS.get(channelConfiguration.channelName))));
            }
            for (MediatorConfiguration mediatorConfiguration : context.getMediatorConfigurations()) {
                boolean isProcessor;
                boolean bl = isProcessor = !mediatorConfiguration.getIncoming().isEmpty() && mediatorConfiguration.getOutgoing() != null;
                if (isProcessor) {
                    publishers.put(mediatorConfiguration.getOutgoing(), new Component(ComponentType.PROCESSOR, DevReactiveMessagingInfos.asMethod(mediatorConfiguration.methodAsString())));
                    for (String incoming : mediatorConfiguration.getIncoming()) {
                        consumers.computeIfAbsent(incoming, fun).add(new Component(ComponentType.PROCESSOR, DevReactiveMessagingInfos.asMethod(mediatorConfiguration.methodAsString())));
                    }
                    continue;
                }
                if (mediatorConfiguration.getOutgoing() != null) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(DevReactiveMessagingInfos.asMethod(mediatorConfiguration.methodAsString()));
                    if (mediatorConfiguration.getBroadcast()) {
                        builder.append("[broadcast: true]");
                    }
                    publishers.put(mediatorConfiguration.getOutgoing(), new Component(ComponentType.PUBLISHER, builder.toString()));
                    continue;
                }
                if (mediatorConfiguration.getIncoming().isEmpty()) continue;
                for (String incoming : mediatorConfiguration.getIncoming()) {
                    consumers.computeIfAbsent(incoming, fun).add(new Component(ComponentType.SUBSCRIBER, DevReactiveMessagingInfos.asMethod(mediatorConfiguration.methodAsString())));
                }
            }
            HashSet channels = new HashSet();
            channels.addAll(publishers.keySet());
            channels.addAll(consumers.keySet());
            ArrayList<DevChannelInfo> arrayList = new ArrayList<DevChannelInfo>();
            for (String channel : channels) {
                arrayList.add(new DevChannelInfo(channel, (Component)publishers.get(channel), (List)consumers.get(channel)));
            }
            Collections.sort(arrayList);
            return arrayList;
        }
    });

    static String asMethod(String value) {
        return DevReactiveMessagingInfos.asCode(value + "()");
    }

    static String asCode(String value) {
        return "<code>" + value + "</code>";
    }

    public List<DevChannelInfo> getChannels() {
        return (List)this.channels.get();
    }

    public static enum ComponentType {
        CONNECTOR,
        PROCESSOR,
        PUBLISHER,
        EMITTER,
        CHANNEL,
        SUBSCRIBER;

    }

    public static class Component {
        public final ComponentType type;
        public final String description;

        public Component(ComponentType type, String description) {
            this.type = type;
            this.description = description;
        }

        boolean isConnector() {
            return this.type == ComponentType.CONNECTOR;
        }
    }

    public static class DevChannelInfo
    implements Comparable<DevChannelInfo> {
        private final String name;
        private final Component publisher;
        private final List<Component> consumers;

        public DevChannelInfo(String name, Component publisher, List<Component> consumers) {
            this.name = name;
            this.publisher = publisher;
            this.consumers = consumers != null ? consumers : Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public Component getPublisher() {
            return this.publisher;
        }

        public List<Component> getConsumers() {
            return this.consumers;
        }

        @Override
        public int compareTo(DevChannelInfo other) {
            long otherConsumersConnectors;
            long consumerConnetors;
            if (this.publisher != other.publisher) {
                if (other.publisher == null) {
                    return -1;
                }
                if (this.publisher == null) {
                    return 1;
                }
                if (this.publisher.type != other.publisher.type) {
                    return this.publisher.type == ComponentType.CONNECTOR ? -1 : 1;
                }
            }
            if ((consumerConnetors = this.consumers.stream().filter(Component::isConnector).count()) != (otherConsumersConnectors = other.consumers.stream().filter(Component::isConnector).count())) {
                return Long.compare(otherConsumersConnectors, consumerConnetors);
            }
            if (this.publisher != other.publisher && this.publisher.type == ComponentType.CONNECTOR && other.publisher.type != ComponentType.CONNECTOR) {
                return 1;
            }
            return this.name.compareTo(other.name);
        }
    }
}

