/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime.devmode;

import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.smallrye.reactivemessaging.runtime.devmode.DevModeSupportConnectorFactoryInterceptor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class ReactiveMessagingHotReplacementSetup
implements HotReplacementSetup {
    private static final Logger LOGGER = Logger.getLogger((String)ReactiveMessagingHotReplacementSetup.class.getName());
    private static final long TWO_SECONDS = 2000L;
    private HotReplacementContext context;
    private volatile long nextUpdate;
    private final Executor executor = Executors.newSingleThreadExecutor();

    public void setupHotDeployment(HotReplacementContext context) {
        this.context = context;
        DevModeSupportConnectorFactoryInterceptor.register(new OnMessage());
    }

    private class OnMessage
    implements Supplier<CompletableFuture<Boolean>> {
        private OnMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletableFuture<Boolean> get() {
            if (ReactiveMessagingHotReplacementSetup.this.nextUpdate < System.currentTimeMillis()) {
                OnMessage onMessage = this;
                synchronized (onMessage) {
                    if (ReactiveMessagingHotReplacementSetup.this.nextUpdate < System.currentTimeMillis()) {
                        final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
                        ReactiveMessagingHotReplacementSetup.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    boolean restarted = ReactiveMessagingHotReplacementSetup.this.context.doScan(true);
                                    if (ReactiveMessagingHotReplacementSetup.this.context.getDeploymentProblem() != null) {
                                        LOGGER.error((Object)"Failed to redeploy application on changes", ReactiveMessagingHotReplacementSetup.this.context.getDeploymentProblem());
                                    }
                                    result.complete(restarted);
                                }
                                catch (RuntimeException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                                finally {
                                    result.complete(false);
                                }
                            }
                        });
                        ReactiveMessagingHotReplacementSetup.this.nextUpdate = System.currentTimeMillis() + 2000L;
                        return result;
                    }
                }
            }
            return CompletableFuture.completedFuture(false);
        }
    }
}

