/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManagerComparator;
import io.quarkus.test.common.TestClassIndexer;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;

public class TestResourceManager
implements Closeable {
    private final List<TestResourceEntry> sequentialTestResourceEntries;
    private final List<TestResourceEntry> parallelTestResourceEntries = new ArrayList<TestResourceEntry>();
    private final List<TestResourceEntry> allTestResourceEntries;
    private Map<String, String> oldSystemProps;
    private boolean started = false;

    public TestResourceManager(Class<?> testClass) {
        this(testClass, Collections.emptyList(), false);
    }

    public TestResourceManager(Class<?> testClass, List<TestResourceClassEntry> additionalTestResources, boolean disableGlobalTestResources) {
        this.sequentialTestResourceEntries = new ArrayList<TestResourceEntry>();
        Set<TestResourceClassEntry> uniqueEntries = disableGlobalTestResources ? new HashSet<TestResourceClassEntry>(additionalTestResources) : this.getUniqueTestResourceClassEntries(testClass, additionalTestResources);
        Set<TestResourceClassEntry> remainingUniqueEntries = this.initParallelTestResources(uniqueEntries);
        this.initSequentialTestResources(remainingUniqueEntries);
        this.allTestResourceEntries = new ArrayList<TestResourceEntry>(this.sequentialTestResourceEntries);
        this.allTestResourceEntries.addAll(this.parallelTestResourceEntries);
    }

    public void init() {
        for (TestResourceEntry entry : this.allTestResourceEntries) {
            try {
                entry.getTestResource().init(entry.getArgs());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable initialize test resource " + entry.getTestResource(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> start() {
        this.started = true;
        ConcurrentHashMap<String, String> ret = new ConcurrentHashMap<String, String>();
        ExecutorService executor = this.newExecutor(this.parallelTestResourceEntries.size() + 1);
        try {
            ArrayList<Future> startFutures = new ArrayList<Future>();
            for (TestResourceEntry entry : this.parallelTestResourceEntries) {
                Future<?> startFuture = executor.submit(() -> {
                    try {
                        Map<String, String> start = entry.getTestResource().start();
                        if (start != null) {
                            ret.putAll(start);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to start Quarkus test resource " + entry.getTestResource(), e);
                    }
                });
                startFutures.add(startFuture);
            }
            Future<?> sequentialStartFuture = executor.submit(() -> {
                for (TestResourceEntry entry : this.sequentialTestResourceEntries) {
                    try {
                        Map<String, String> start = entry.getTestResource().start();
                        if (start == null) continue;
                        ret.putAll(start);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to start Quarkus test resource " + entry.getTestResource(), e);
                    }
                }
            });
            startFutures.add(sequentialStartFuture);
            this.waitForAllFutures(startFutures);
            this.oldSystemProps = new HashMap<String, String>();
            for (Map.Entry i : ret.entrySet()) {
                this.oldSystemProps.put((String)i.getKey(), System.getProperty((String)i.getKey()));
                if (i.getValue() == null) {
                    System.clearProperty((String)i.getKey());
                    continue;
                }
                System.setProperty((String)i.getKey(), (String)i.getValue());
            }
        }
        finally {
            executor.shutdown();
        }
        return ret;
    }

    private void waitForAllFutures(List<Future> startFutures) {
        for (Future future : startFutures) {
            try {
                future.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                throw new RuntimeException("Error waiting for test resource future to finish.", e);
            }
        }
    }

    private ExecutorService newExecutor(int poolSize) {
        return Executors.newFixedThreadPool(poolSize);
    }

    public void inject(Object testInstance) {
        for (TestResourceEntry entry : this.allTestResourceEntries) {
            entry.getTestResource().inject(testInstance);
        }
    }

    @Override
    public void close() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.oldSystemProps != null) {
            for (Map.Entry entry : this.oldSystemProps.entrySet()) {
                if (entry.getValue() == null) {
                    System.clearProperty((String)entry.getKey());
                    continue;
                }
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.oldSystemProps = null;
        for (TestResourceEntry testResourceEntry : this.allTestResourceEntries) {
            try {
                testResourceEntry.getTestResource().stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to stop Quarkus test resource " + testResourceEntry.getTestResource(), e);
            }
        }
        try {
            ConfigProviderResolver cpr = ConfigProviderResolver.instance();
            cpr.releaseConfig(cpr.getConfig());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Set<TestResourceClassEntry> initParallelTestResources(Set<TestResourceClassEntry> uniqueEntries) {
        HashSet<TestResourceClassEntry> remainingUniqueEntries = new HashSet<TestResourceClassEntry>(uniqueEntries);
        for (TestResourceClassEntry entry : uniqueEntries) {
            if (!entry.isParallel()) continue;
            TestResourceEntry testResourceEntry = this.buildTestResourceEntry(entry);
            this.parallelTestResourceEntries.add(testResourceEntry);
            remainingUniqueEntries.remove(entry);
        }
        this.parallelTestResourceEntries.sort(new Comparator<TestResourceEntry>(){
            private final QuarkusTestResourceLifecycleManagerComparator lifecycleManagerComparator = new QuarkusTestResourceLifecycleManagerComparator();

            @Override
            public int compare(TestResourceEntry o1, TestResourceEntry o2) {
                return this.lifecycleManagerComparator.compare(o1.getTestResource(), o2.getTestResource());
            }
        });
        return remainingUniqueEntries;
    }

    private Set<TestResourceClassEntry> initSequentialTestResources(Set<TestResourceClassEntry> uniqueEntries) {
        TestResourceEntry testResourceEntry;
        HashSet<TestResourceClassEntry> remainingUniqueEntries = new HashSet<TestResourceClassEntry>(uniqueEntries);
        for (TestResourceClassEntry entry : uniqueEntries) {
            if (entry.isParallel()) continue;
            testResourceEntry = this.buildTestResourceEntry(entry);
            this.sequentialTestResourceEntries.add(testResourceEntry);
            remainingUniqueEntries.remove(entry);
        }
        for (QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager : ServiceLoader.load(QuarkusTestResourceLifecycleManager.class, Thread.currentThread().getContextClassLoader())) {
            testResourceEntry = new TestResourceEntry(quarkusTestResourceLifecycleManager);
            this.sequentialTestResourceEntries.add(testResourceEntry);
        }
        this.sequentialTestResourceEntries.sort(new Comparator<TestResourceEntry>(){
            private final QuarkusTestResourceLifecycleManagerComparator lifecycleManagerComparator = new QuarkusTestResourceLifecycleManagerComparator();

            @Override
            public int compare(TestResourceEntry o1, TestResourceEntry o2) {
                return this.lifecycleManagerComparator.compare(o1.getTestResource(), o2.getTestResource());
            }
        });
        return remainingUniqueEntries;
    }

    private TestResourceEntry buildTestResourceEntry(TestResourceClassEntry entry) {
        Class testResourceClass = entry.clazz;
        try {
            return new TestResourceEntry((QuarkusTestResourceLifecycleManager)testResourceClass.getConstructor(new Class[0]).newInstance(new Object[0]), entry.args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate the test resource " + testResourceClass.getName(), e);
        }
    }

    private Set<TestResourceClassEntry> getUniqueTestResourceClassEntries(Class<?> testClass, List<TestResourceClassEntry> additionalTestResources) {
        Index index = TestClassIndexer.readIndex(testClass);
        HashSet<TestResourceClassEntry> uniqueEntries = new HashSet<TestResourceClassEntry>();
        for (AnnotationInstance annotation : this.findQuarkusTestResourceInstances((IndexView)index)) {
            try {
                Map<String, String> args;
                Class<? extends QuarkusTestResourceLifecycleManager> testResourceClass = this.loadTestResourceClassFromTCCL(annotation.value().asString());
                AnnotationValue argsAnnotationValue = annotation.value("initArgs");
                if (argsAnnotationValue == null) {
                    args = Collections.emptyMap();
                } else {
                    AnnotationInstance[] resourceArgsInstances;
                    args = new HashMap();
                    for (AnnotationInstance resourceArgsInstance : resourceArgsInstances = argsAnnotationValue.asNestedArray()) {
                        args.put(resourceArgsInstance.value("name").asString(), resourceArgsInstance.value().asString());
                    }
                }
                boolean isParallel = false;
                AnnotationValue parallelAnnotationValue = annotation.value("parallel");
                if (parallelAnnotationValue != null) {
                    isParallel = parallelAnnotationValue.asBoolean();
                }
                uniqueEntries.add(new TestResourceClassEntry(testResourceClass, args, isParallel));
            }
            catch (IllegalArgumentException | SecurityException e) {
                throw new RuntimeException("Unable to instantiate the test resource " + annotation.value().asString(), e);
            }
        }
        uniqueEntries.addAll(additionalTestResources);
        return uniqueEntries;
    }

    private Class<? extends QuarkusTestResourceLifecycleManager> loadTestResourceClassFromTCCL(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<AnnotationInstance> findQuarkusTestResourceInstances(IndexView index) {
        HashSet<AnnotationInstance> testResourceAnnotations = new HashSet<AnnotationInstance>(index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.class.getName())));
        for (AnnotationInstance annotation : index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.List.class.getName()))) {
            Collections.addAll(testResourceAnnotations, annotation.value().asNestedArray());
        }
        return testResourceAnnotations;
    }

    private static class TestResourceEntry {
        private final QuarkusTestResourceLifecycleManager testResource;
        private final Map<String, String> args;

        public TestResourceEntry(QuarkusTestResourceLifecycleManager testResource) {
            this(testResource, Collections.emptyMap());
        }

        public TestResourceEntry(QuarkusTestResourceLifecycleManager testResource, Map<String, String> args) {
            this.testResource = testResource;
            this.args = args;
        }

        public QuarkusTestResourceLifecycleManager getTestResource() {
            return this.testResource;
        }

        public Map<String, String> getArgs() {
            return this.args;
        }
    }

    public static class TestResourceClassEntry {
        private Class<? extends QuarkusTestResourceLifecycleManager> clazz;
        private Map<String, String> args;
        private boolean parallel;

        public TestResourceClassEntry(Class<? extends QuarkusTestResourceLifecycleManager> clazz, Map<String, String> args, boolean parallel) {
            this.clazz = clazz;
            this.args = args;
            this.parallel = parallel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestResourceClassEntry that = (TestResourceClassEntry)o;
            return this.clazz.equals(that.clazz) && this.args.equals(that.args) && this.parallel == that.parallel;
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.args, this.parallel);
        }

        public boolean isParallel() {
            return this.parallel;
        }
    }
}

