/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.bootstrap.logging.LateBoundMDCProvider;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ContextHandlerBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.IOThreadDetectorBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.ThreadFactoryBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.netty.deployment.EventLoopSupplierBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.core.deployment.EventLoopCountBuildItem;
import io.quarkus.vertx.core.deployment.VertxOptionsConsumerBuildItem;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.core.runtime.VertxLocalsHelper;
import io.quarkus.vertx.core.runtime.VertxLogDelegateFactory;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.logmanager.LogManager;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class VertxCoreProcessor {
    private static final Logger log = Logger.getLogger(VertxCoreProcessor.class);
    private static final Set<String> BLOCKED_THREAD_LOGGER_NAMES = Set.of("io.vertx.core.impl.BlockedThreadChecker", "io.vertx.core.impl.btc.BlockedThreadChecker");

    VertxCoreProcessor() {
    }

    @BuildStep
    NativeImageConfigBuildItem build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> nativeImageResources) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{VertxLogDelegateFactory.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{LateBoundMDCProvider.class.getName()}));
        nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.jboss.logmanager.MDCProvider"}));
        return NativeImageConfigBuildItem.builder().addRuntimeInitializedClass("io.vertx.core.buffer.impl.VertxByteBufAllocator").addRuntimeInitializedClass("io.vertx.core.buffer.impl.PartialPooledByteBufAllocator").addRuntimeInitializedClass("io.vertx.core.http.impl.VertxHttp2ClientUpgradeCodec").addRuntimeInitializedClass("io.vertx.core.eventbus.impl.clustered.ClusteredEventBus").addNativeImageSystemProperty("vertx.disableDnsResolver", "true").addNativeImageSystemProperty("vertx.logger-delegate-factory-class-name", VertxLogDelegateFactory.class.getName()).build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    EventLoopCountBuildItem eventLoopCount(VertxCoreRecorder recorder, VertxConfiguration vertxConfiguration) {
        return new EventLoopCountBuildItem(recorder.calculateEventLoopThreads(vertxConfiguration));
    }

    @BuildStep
    LogCleanupFilterBuildItem cleanupVertxWarnings() {
        return new LogCleanupFilterBuildItem("io.vertx.core.impl.ContextImpl", new String[]{"You have disabled TCCL checks"});
    }

    @BuildStep
    BytecodeTransformerBuildItem overrideContextToAddSafeGuards() {
        return new BytecodeTransformerBuildItem("io.vertx.core.impl.AbstractContext", (className, classVisitor) -> new ClassVisitor(589824, (ClassVisitor)classVisitor){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                MethodVisitor visitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                if (name.equals("get") || name.equals("put") || name.equals("remove")) {
                    return new MethodVisitor(589824, visitor){

                        public void visitCode() {
                            super.visitCode();
                            this.visitMethodInsn(184, VertxLocalsHelper.class.getName().replace(".", "/"), "throwOnRootContextAccess", "()V", false);
                        }
                    };
                }
                if (name.equals("getLocal")) {
                    return new MethodVisitor(589824, visitor){

                        public void visitCode() {
                            super.visitCode();
                            this.visitVarInsn(25, 0);
                            this.visitVarInsn(25, 1);
                            this.visitMethodInsn(184, VertxLocalsHelper.class.getName().replace(".", "/"), "getLocal", "(Lio/vertx/core/impl/ContextInternal;Ljava/lang/Object;)Ljava/lang/Object;", false);
                            this.visitInsn(176);
                        }
                    };
                }
                if (name.equals("putLocal")) {
                    return new MethodVisitor(589824, visitor){

                        public void visitCode() {
                            super.visitCode();
                            this.visitVarInsn(25, 0);
                            this.visitVarInsn(25, 1);
                            this.visitVarInsn(25, 2);
                            this.visitMethodInsn(184, VertxLocalsHelper.class.getName().replace(".", "/"), "putLocal", "(Lio/vertx/core/impl/ContextInternal;Ljava/lang/Object;Ljava/lang/Object;)V", false);
                            this.visitInsn(177);
                        }
                    };
                }
                if (name.equals("removeLocal")) {
                    return new MethodVisitor(589824, visitor){

                        public void visitCode() {
                            super.visitCode();
                            this.visitVarInsn(25, 0);
                            this.visitVarInsn(25, 1);
                            this.visitMethodInsn(184, VertxLocalsHelper.class.getName().replace(".", "/"), "removeLocal", "(Lio/vertx/core/impl/ContextInternal;Ljava/lang/Object;)Z", false);
                            this.visitInsn(Type.getType(Boolean.TYPE).getOpcode(172));
                        }
                    };
                }
                return visitor;
            }
        });
    }

    @BuildStep
    LogCategoryBuildItem preventLoggerContention() {
        return new LogCategoryBuildItem("io.vertx.core.impl.ContextImpl", (Level)org.jboss.logmanager.Level.ERROR);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    IOThreadDetectorBuildItem ioThreadDetector(VertxCoreRecorder recorder) {
        return new IOThreadDetectorBuildItem(recorder.detector());
    }

    @BuildStep
    @Produce(value=ServiceStartBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    CoreVertxBuildItem build(VertxCoreRecorder recorder, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdown, VertxConfiguration config, List<VertxOptionsConsumerBuildItem> vertxOptionsConsumers, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<EventLoopSupplierBuildItem> eventLoops, ExecutorBuildItem executorBuildItem) {
        Collections.sort(vertxOptionsConsumers);
        ArrayList<Consumer<VertxOptions>> consumers = new ArrayList<Consumer<VertxOptions>>(vertxOptionsConsumers.size());
        for (VertxOptionsConsumerBuildItem x : vertxOptionsConsumers) {
            consumers.add(x.getConsumer());
        }
        Supplier vertx = recorder.configureVertx(config, launchMode.getLaunchMode(), (ShutdownContext)shutdown, consumers, executorBuildItem.getExecutorProxy());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Vertx.class).types(new Class[]{Vertx.class})).scope(Singleton.class)).unremovable()).setRuntimeInit().supplier(vertx).done());
        eventLoops.produce((BuildItem)new EventLoopSupplierBuildItem(recorder.mainSupplier(), recorder.bossSupplier()));
        if (launchMode.getLaunchMode().isDevOrTest()) {
            this.handleBlockingWarningsInDevOrTestMode();
        }
        return new CoreVertxBuildItem(vertx);
    }

    @BuildStep
    LogCleanupFilterBuildItem filterNettyHostsFileParsingWarn() {
        return new LogCleanupFilterBuildItem("io.netty.resolver.HostsFileParser", new String[]{"Failed to load and parse hosts file"});
    }

    @BuildStep
    void registerVerticleClasses(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (ClassInfo ci : indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)AbstractVerticle.class.getName()))) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ci.toString()}));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ThreadFactoryBuildItem createVertxThreadFactory(VertxCoreRecorder recorder, LaunchModeBuildItem launchMode) {
        return new ThreadFactoryBuildItem(recorder.createThreadFactory(launchMode.getLaunchMode()));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ContextHandlerBuildItem createVertxContextHandlers(VertxCoreRecorder recorder) {
        return new ContextHandlerBuildItem(recorder.executionContextHandler());
    }

    private void handleBlockingWarningsInDevOrTestMode() {
        try {
            final Filter debuggerFilter = this.createDebuggerFilter();
            LogManager logManager = (LogManager)LogManager.getLogManager();
            Filter filter = new Filter(){
                volatile StackTraceElement last;

                @Override
                public boolean isLoggable(LogRecord record) {
                    if (debuggerFilter != null && !debuggerFilter.isLoggable(record)) {
                        return false;
                    }
                    if (record.getThrown() == null) {
                        return true;
                    }
                    StackTraceElement element = record.getThrown().getStackTrace()[0];
                    if (this.last != null && element.equals(this.last)) {
                        return false;
                    }
                    this.last = element;
                    return true;
                }
            };
            for (String classname : BLOCKED_THREAD_LOGGER_NAMES) {
                logManager.getLogger(classname).setFilter(filter);
            }
        }
        catch (Throwable t) {
            log.debug((Object)"Failed to filter blocked thread checker", t);
        }
    }

    private Filter createDebuggerFilter() {
        try {
            Filter filter;
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            if (runtime == null) {
                return null;
            }
            int debugPort = -1;
            InetAddress bindAddress = null;
            boolean alwaysFilter = false;
            List<String> args = runtime.getInputArguments();
            for (String arg : args) {
                if (!arg.startsWith("-Xrunjdwp") && !arg.startsWith("-agentlib:jdwp")) continue;
                boolean client = true;
                if (!arg.contains("transport=dt_socket")) {
                    return null;
                }
                Pattern server = Pattern.compile("server=(.)");
                Matcher m = server.matcher(arg);
                if (m.find() && m.group(1).equals("y")) {
                    client = false;
                }
                if (client) {
                    alwaysFilter = true;
                    break;
                }
                Pattern port = Pattern.compile("address=(.*?):(\\d+)");
                m = port.matcher(arg);
                if (!m.find()) continue;
                debugPort = Integer.parseInt(m.group(2));
                String host = m.group(1);
                if (host.equals("*")) {
                    host.equals("localhost");
                }
                bindAddress = InetAddress.getByName(host);
            }
            if (debugPort == -1 && !alwaysFilter) {
                return null;
            }
            LogManager logManager = (LogManager)LogManager.getLogManager();
            if (alwaysFilter) {
                filter = s -> false;
            } else {
                final int port = debugPort;
                final InetAddress bind = bindAddress;
                filter = new Filter(){

                    @Override
                    public boolean isLoggable(LogRecord record) {
                        try {
                            ServerSocket s = new ServerSocket(port, 1, bind);
                            s.close();
                        }
                        catch (IOException e) {
                            return true;
                        }
                        return false;
                    }
                };
            }
            return filter;
        }
        catch (Throwable t) {
            log.debug((Object)"Failed to filter blocked thread checker", t);
            return null;
        }
    }
}

