/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.spring.boot;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.MasterSlaveDataSourceFactory;
import io.shardingsphere.core.api.ShardingDataSourceFactory;
import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.util.DataSourceUtil;
import io.shardingsphere.jdbc.spring.boot.masterslave.SpringBootMasterSlaveRuleConfigurationProperties;
import io.shardingsphere.jdbc.spring.boot.sharding.SpringBootShardingRuleConfigurationProperties;
import io.shardingsphere.jdbc.spring.boot.util.PropertyUtil;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={SpringBootShardingRuleConfigurationProperties.class, SpringBootMasterSlaveRuleConfigurationProperties.class})
public class SpringBootConfiguration
implements EnvironmentAware {
    @Autowired
    private SpringBootShardingRuleConfigurationProperties shardingProperties;
    @Autowired
    private SpringBootMasterSlaveRuleConfigurationProperties masterSlaveProperties;
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();

    @Bean
    public DataSource dataSource() throws SQLException {
        return null == this.masterSlaveProperties.getMasterDataSourceName() ? ShardingDataSourceFactory.createDataSource(this.dataSourceMap, (ShardingRuleConfiguration)this.shardingProperties.getShardingRuleConfiguration(), (Map)this.shardingProperties.getConfigMap(), (Properties)this.shardingProperties.getProps()) : MasterSlaveDataSourceFactory.createDataSource(this.dataSourceMap, (MasterSlaveRuleConfiguration)this.masterSlaveProperties.getMasterSlaveRuleConfiguration(), (Map)this.masterSlaveProperties.getConfigMap());
    }

    public void setEnvironment(Environment environment) {
        this.setDataSourceMap(environment);
    }

    private void setDataSourceMap(Environment environment) {
        String prefix = "sharding.jdbc.datasource.";
        String dataSources = environment.getProperty(prefix + "names");
        for (String each : dataSources.split(",")) {
            try {
                Map dataSourceProps = PropertyUtil.handle(environment, prefix + each, Map.class);
                Preconditions.checkState((!dataSourceProps.isEmpty() ? 1 : 0) != 0, (Object)"Wrong datasource properties!");
                DataSource dataSource = DataSourceUtil.getDataSource((String)dataSourceProps.get("type").toString(), (Map)dataSourceProps);
                this.dataSourceMap.put(each, dataSource);
            }
            catch (ReflectiveOperationException ex) {
                throw new ShardingException("Can't find datasource type!", (Exception)ex);
            }
        }
    }
}

