/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOnItemTransformToUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.Function;
import java.util.function.Predicate;

public class UniOnFailureFlatMap<I>
extends UniOperator<I, I> {
    private final Function<? super Throwable, Uni<? extends I>> mapper;
    private final Predicate<? super Throwable> predicate;

    public UniOnFailureFlatMap(Uni<I> upstream, Predicate<? super Throwable> predicate, Function<? super Throwable, Uni<? extends I>> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    protected void subscribing(final UniSubscriber<? super I> subscriber) {
        final UniOnItemTransformToUni.FlatMapSubscription flatMapSubscription = new UniOnItemTransformToUni.FlatMapSubscription();
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<I, I>(subscriber){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                flatMapSubscription.setInitialUpstream(subscription);
                subscriber.onSubscribe(flatMapSubscription);
            }

            @Override
            public void onFailure(Throwable failure) {
                boolean test;
                try {
                    test = UniOnFailureFlatMap.this.predicate.test(failure);
                }
                catch (RuntimeException e) {
                    subscriber.onFailure(new CompositeException(failure, e));
                    return;
                }
                if (test) {
                    UniOnItemTransformToUni.invokeAndSubstitute(UniOnFailureFlatMap.this.mapper, failure, subscriber, flatMapSubscription);
                } else {
                    subscriber.onFailure(failure);
                }
            }
        });
    }
}

