/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniAndGroupIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.tuples.Functions;
import io.smallrye.mutiny.tuples.Tuple5;
import io.smallrye.mutiny.tuples.Tuples;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class UniAndGroup5<T1, T2, T3, T4, T5>
extends UniAndGroupIterable<T1> {
    public UniAndGroup5(Uni<? extends T1> source, Uni<? extends T2> o1, Uni<? extends T3> o2, Uni<? extends T4> o3, Uni<? extends T5> o4) {
        super(source, Arrays.asList(o1, o2, o3, o4));
    }

    public UniAndGroup5<T1, T2, T3, T4, T5> collectFailures() {
        super.collectFailures();
        return this;
    }

    public Uni<Tuple5<T1, T2, T3, T4, T5>> asTuple() {
        return this.combine(Tuple5::of);
    }

    public <O> Uni<O> combinedWith(Functions.Function5<T1, T2, T3, T4, T5, O> combinator) {
        Functions.Function5<T1, T2, T3, T4, T5, O> actual = Infrastructure.decorate(ParameterValidation.nonNull(combinator, "combinator"));
        return this.combine(actual);
    }

    private <O> Uni<O> combine(Functions.Function5<T1, T2, T3, T4, T5, O> combinator) {
        Function<List, Object> function = list -> {
            Tuples.ensureArity(list, 5);
            Object item1 = list.get(0);
            Object item2 = list.get(1);
            Object item3 = list.get(2);
            Object item4 = list.get(3);
            Object item5 = list.get(4);
            return combinator.apply(item1, item2, item3, item4, item5);
        };
        return super.combinedWith(function);
    }
}

