/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class PerlClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String MODULE_NAME = "moduleName";
    public static final String MODULE_VERSION = "moduleVersion";
    protected String moduleName = "WWW::SwaggerClient";
    protected String modulePathPart = this.moduleName.replaceAll("::", Matcher.quoteReplacement(File.separator));
    protected String moduleVersion = "1.0.0";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected static int emptyFunctionNameCounter = 0;

    public PerlClientCodegen() {
        this.importMapping.clear();
        this.modelPackage = File.separatorChar + "Object";
        this.outputFolder = "generated-code" + File.separatorChar + "perl";
        this.modelTemplateFiles.put("object.mustache", ".pm");
        this.apiTemplateFiles.put("api.mustache", ".pm");
        this.modelTestTemplateFiles.put("object_test.mustache", ".t");
        this.apiTestTemplateFiles.put("api_test.mustache", ".t");
        this.modelDocTemplateFiles.put("object_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "perl";
        this.embeddedTemplateDir = "perl";
        this.setReservedWordsLowerCase(Arrays.asList("else", "lock", "qw", "__END__", "elsif", "lt", "qx", "__FILE__", "eq", "m", "s", "__LINE__", "exp", "ne", "sub", "__PACKAGE__", "for", "no", "tr", "and", "foreach", "or", "unless", "cmp", "ge", "package", "until", "continue", "gt", "q", "while", "CORE", "if", "qq", "xor", "do", "le", "qr", "y", "return"));
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("double");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("boolean");
        this.languageSpecificPrimitives.add("DateTime");
        this.languageSpecificPrimitives.add("ARRAY");
        this.languageSpecificPrimitives.add("HASH");
        this.languageSpecificPrimitives.add("object");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("float", "double");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("array", "ARRAY");
        this.typeMapping.put("map", "HASH");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption(MODULE_NAME, "Perl module name (convention: CamelCase or Long::Module).").defaultValue("SwaggerClient"));
        this.cliOptions.add(new CliOption(MODULE_VERSION, "Perl module version.").defaultValue("1.0.0"));
        this.cliOptions.add(CliOption.newBoolean("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("ensureUniqueParams", "Whether to ensure parameter names are unique in an operation (rename parameters that are not).").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(MODULE_VERSION)) {
            this.setModuleVersion((String)this.additionalProperties.get(MODULE_VERSION));
        } else {
            this.additionalProperties.put(MODULE_VERSION, this.moduleVersion);
        }
        if (this.additionalProperties.containsKey(MODULE_NAME)) {
            this.setModuleName((String)this.additionalProperties.get(MODULE_NAME));
            this.setModulePathPart(this.moduleName.replaceAll("::", Matcher.quoteReplacement(File.separator)));
        } else {
            this.additionalProperties.put(MODULE_NAME, this.moduleName);
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", ("lib/" + this.modulePathPart).replace('/', File.separatorChar), "ApiClient.pm"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", ("lib/" + this.modulePathPart).replace('/', File.separatorChar), "Configuration.pm"));
        this.supportingFiles.add(new SupportingFile("ApiFactory.mustache", ("lib/" + this.modulePathPart).replace('/', File.separatorChar), "ApiFactory.pm"));
        this.supportingFiles.add(new SupportingFile("Role.mustache", ("lib/" + this.modulePathPart).replace('/', File.separatorChar), "Role.pm"));
        this.supportingFiles.add(new SupportingFile("AutoDoc.mustache", ("lib/" + this.modulePathPart + "/Role").replace('/', File.separatorChar), "AutoDoc.pm"));
        this.supportingFiles.add(new SupportingFile("autodoc.script.mustache", "bin", "autodoc"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "perl";
    }

    @Override
    public String getHelp() {
        return "Generates a Perl client library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/lib/" + this.modulePathPart + this.apiPackage()).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/lib/" + this.modulePathPart + this.modelPackage()).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return (this.outputFolder + "/t").replace('/', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return (this.outputFolder + "/t").replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty dp = (StringProperty)p;
            if (dp.getDefault() != null) {
                return "'" + dp.getDefault().toString() + "'";
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty dp = (BooleanProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
        } else if (!(p instanceof DateProperty) && !(p instanceof DateTimeProperty)) {
            LongProperty dp;
            if (p instanceof DoubleProperty) {
                DoubleProperty dp2 = (DoubleProperty)p;
                if (dp2.getDefault() != null) {
                    return dp2.getDefault().toString();
                }
            } else if (p instanceof FloatProperty) {
                FloatProperty dp3 = (FloatProperty)p;
                if (dp3.getDefault() != null) {
                    return dp3.getDefault().toString();
                }
            } else if (p instanceof IntegerProperty) {
                IntegerProperty dp4 = (IntegerProperty)p;
                if (dp4.getDefault() != null) {
                    return dp4.getDefault().toString();
                }
            } else if (p instanceof LongProperty && (dp = (LongProperty)p).getDefault() != null) {
                return dp.getDefault().toString();
            }
        }
        return null;
    }

    @Override
    public String toVarName(String name) {
        if ((name = PerlClientCodegen.underscore(name)).matches("^\\d.*")) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + PerlClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + PerlClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        return PerlClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "Test";
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelFilename(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "Test";
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiFilename(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return PerlClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return PerlClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            operationId = PerlClientCodegen.underscore("empty_function_name_" + emptyFunctionNameCounter++);
            LOGGER.warn("Empty method name (operationId) found. Renamed to " + operationId);
            return operationId;
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + PerlClientCodegen.underscore("call_" + operationId));
            return PerlClientCodegen.underscore("call_" + operationId);
        }
        return PerlClientCodegen.underscore(this.sanitizeName(operationId));
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setModulePathPart(String modulePathPart) {
        this.modulePathPart = modulePathPart;
    }

    public void setModuleVersion(String moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (Boolean.TRUE.equals(p.isString) || Boolean.TRUE.equals(p.isBinary) || Boolean.TRUE.equals(p.isByteArray) || Boolean.TRUE.equals(p.isFile)) {
            p.example = "'" + p.example + "'";
        } else if (Boolean.TRUE.equals(p.isBoolean)) {
            p.example = Boolean.parseBoolean(p.example) ? new String("1") : new String("0");
        } else if (Boolean.TRUE.equals(p.isDateTime) || Boolean.TRUE.equals(p.isDate)) {
            p.example = "DateTime->from_epoch(epoch => str2time('" + p.example + "'))";
        }
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("=begin", "=_begin").replace("=end", "=_end").replace("=cut", "=_cut").replace("=pod", "=_pod");
    }
}

