/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractJavaCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;

public class SpringCodegen
extends AbstractJavaCodegen {
    public static final String DEFAULT_LIBRARY = "spring-boot";
    public static final String TITLE = "title";
    public static final String CONFIG_PACKAGE = "configPackage";
    public static final String BASE_PACKAGE = "basePackage";
    public static final String INTERFACE_ONLY = "interfaceOnly";
    public static final String SINGLE_CONTENT_TYPES = "singleContentTypes";
    public static final String JAVA_8 = "java8";
    public static final String ASYNC = "async";
    public static final String SPRING_MVC_LIBRARY = "spring-mvc";
    public static final String SPRING_CLOUD_LIBRARY = "spring-cloud";
    protected String title = "swagger-petstore";
    protected String configPackage = "io.swagger.configuration";
    protected String basePackage = "io.swagger";
    protected boolean interfaceOnly = false;
    protected boolean singleContentTypes = false;
    protected boolean java8 = false;
    protected boolean async = false;

    public SpringCodegen() {
        this.outputFolder = "generated-code/javaSpring";
        this.apiTestTemplateFiles.clear();
        this.templateDir = "JavaSpring";
        this.embeddedTemplateDir = "JavaSpring";
        this.apiPackage = "io.swagger.api";
        this.modelPackage = "io.swagger.model";
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-spring";
        this.additionalProperties.put(CONFIG_PACKAGE, this.configPackage);
        this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
        this.cliOptions.add(new CliOption(TITLE, "server title name or client service name"));
        this.cliOptions.add(new CliOption(CONFIG_PACKAGE, "configuration package for generated code"));
        this.cliOptions.add(new CliOption(BASE_PACKAGE, "base package for generated code"));
        this.cliOptions.add(CliOption.newBoolean(INTERFACE_ONLY, "Whether to generate only API interface stubs without the server files."));
        this.cliOptions.add(CliOption.newBoolean(SINGLE_CONTENT_TYPES, "Whether to select only one produces/consumes content-type by operation."));
        this.cliOptions.add(CliOption.newBoolean(JAVA_8, "use java8 default interface"));
        this.cliOptions.add(CliOption.newBoolean(ASYNC, "use async Callable controllers"));
        this.supportedLibraries.put(DEFAULT_LIBRARY, "Spring-boot Server application using the SpringFox integration.");
        this.supportedLibraries.put(SPRING_MVC_LIBRARY, "Spring-MVC Server application using the SpringFox integration.");
        this.supportedLibraries.put(SPRING_CLOUD_LIBRARY, "Spring-Cloud-Feign client with Spring-Boot auto-configured settings.");
        this.setLibrary(DEFAULT_LIBRARY);
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setDefault(DEFAULT_LIBRARY);
        library.setEnum(this.supportedLibraries);
        library.setDefault(DEFAULT_LIBRARY);
        this.cliOptions.add(library);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "spring";
    }

    @Override
    public String getHelp() {
        return "Generates a Java SpringBoot Server application using the SpringFox integration.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        if (this.additionalProperties.containsKey(TITLE)) {
            this.setTitle((String)this.additionalProperties.get(TITLE));
        }
        if (this.additionalProperties.containsKey(CONFIG_PACKAGE)) {
            this.setConfigPackage((String)this.additionalProperties.get(CONFIG_PACKAGE));
        }
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
        }
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.setInterfaceOnly(Boolean.valueOf(this.additionalProperties.get(INTERFACE_ONLY).toString()));
        }
        if (this.additionalProperties.containsKey(SINGLE_CONTENT_TYPES)) {
            this.setSingleContentTypes(Boolean.valueOf(this.additionalProperties.get(SINGLE_CONTENT_TYPES).toString()));
        }
        if (this.additionalProperties.containsKey(JAVA_8)) {
            this.setJava8(Boolean.valueOf(this.additionalProperties.get(JAVA_8).toString()));
        }
        if (this.additionalProperties.containsKey(ASYNC)) {
            this.setAsync(Boolean.valueOf(this.additionalProperties.get(ASYNC).toString()));
        }
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (!this.interfaceOnly) {
            if (this.library.equals(DEFAULT_LIBRARY)) {
                this.supportingFiles.add(new SupportingFile("homeController.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "HomeController.java"));
                this.supportingFiles.add(new SupportingFile("swagger2SpringBoot.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "Swagger2SpringBoot.java"));
                this.supportingFiles.add(new SupportingFile("application.mustache", "src.main.resources".replace(".", File.separator), "application.properties"));
            }
            if (this.library.equals(SPRING_MVC_LIBRARY)) {
                this.supportingFiles.add(new SupportingFile("webApplication.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "WebApplication.java"));
                this.supportingFiles.add(new SupportingFile("webMvcConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "WebMvcConfiguration.java"));
                this.supportingFiles.add(new SupportingFile("swaggerUiConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "SwaggerUiConfiguration.java"));
                this.supportingFiles.add(new SupportingFile("application.properties", "src.main.resources".replace(".", File.separator), "swagger.properties"));
            }
            if (this.library.equals(SPRING_CLOUD_LIBRARY)) {
                this.supportingFiles.add(new SupportingFile("apiKeyRequestInterceptor.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ApiKeyRequestInterceptor.java"));
                this.supportingFiles.add(new SupportingFile("clientConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ClientConfiguration.java"));
                this.apiTemplateFiles.put("apiClient.mustache", "Client.java");
                if (!this.additionalProperties.containsKey(SINGLE_CONTENT_TYPES)) {
                    this.additionalProperties.put(SINGLE_CONTENT_TYPES, "true");
                    this.setSingleContentTypes(true);
                }
            } else {
                this.apiTemplateFiles.put("apiController.mustache", "Controller.java");
                this.supportingFiles.add(new SupportingFile("apiException.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiException.java"));
                this.supportingFiles.add(new SupportingFile("apiResponseMessage.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiResponseMessage.java"));
                this.supportingFiles.add(new SupportingFile("notFoundException.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "NotFoundException.java"));
                this.supportingFiles.add(new SupportingFile("apiOriginFilter.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiOriginFilter.java"));
                this.supportingFiles.add(new SupportingFile("swaggerDocumentationConfig.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "SwaggerDocumentationConfig.java"));
            }
        }
        if (this.java8) {
            this.additionalProperties.put("javaVersion", "1.8");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "OffsetDateTime");
            this.importMapping.put("LocalDate", "java.time.LocalDate");
            this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        String[] parts;
        super.preprocessSwagger(swagger);
        if ("/".equals(swagger.getBasePath())) {
            swagger.setBasePath("");
        }
        if (!this.additionalProperties.containsKey(TITLE)) {
            String title = swagger.getInfo().getTitle();
            if (title != null) {
                if ((title = title.trim().replace(" ", "-")).toUpperCase().endsWith("API")) {
                    title = title.substring(0, title.length() - 3);
                }
                this.title = SpringCodegen.camelize(this.sanitizeName(title), true);
            }
            this.additionalProperties.put(TITLE, this.title);
        }
        String host = swagger.getHost();
        String port = "8080";
        if (host != null && (parts = host.split(":")).length > 1) {
            port = parts[1];
        }
        this.additionalProperties.put("serverPort", port);
        if (swagger != null && swagger.getPaths() != null) {
            for (String pathname : swagger.getPaths().keySet()) {
                Path path = swagger.getPath(pathname);
                if (path.getOperations() == null) continue;
                for (Operation operation : path.getOperations()) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        value.put("hasMore", "true");
                        tags.add(value);
                    }
                    if (tags.size() > 0) {
                        ((Map)tags.get(tags.size() - 1)).remove("hasMore");
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Arrays.asList(tag));
                    }
                    operation.setVendorExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int end;
                String rt;
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    for (CodegenResponse resp : responses) {
                        if (!"0".equals(resp.code)) continue;
                        resp.code = "200";
                    }
                }
                if (operation.returnType == null) {
                    operation.returnType = "Void";
                    continue;
                }
                if (operation.returnType.startsWith("List")) {
                    rt = operation.returnType;
                    int end2 = rt.lastIndexOf(">");
                    if (end2 <= 0) continue;
                    operation.returnType = rt.substring("List<".length(), end2).trim();
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    rt = operation.returnType;
                    int end3 = rt.lastIndexOf(">");
                    if (end3 <= 0) continue;
                    operation.returnType = rt.substring("Map<".length(), end3).split(",")[1].trim();
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (rt = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = rt.substring("Set<".length(), end).trim();
                operation.returnContainer = "Set";
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        List authMethods;
        if (this.library.equals(SPRING_CLOUD_LIBRARY) && (authMethods = (List)objs.get("authMethods")) != null) {
            for (CodegenSecurity authMethod : authMethods) {
                authMethod.name = SpringCodegen.camelize(this.sanitizeName(authMethod.name), true);
            }
        }
        return objs;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return SpringCodegen.camelize(name) + "Api";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public void setBasePackage(String configPackage) {
        this.basePackage = configPackage;
    }

    public void setInterfaceOnly(boolean interfaceOnly) {
        this.interfaceOnly = interfaceOnly;
    }

    public void setSingleContentTypes(boolean singleContentTypes) {
        this.singleContentTypes = singleContentTypes;
    }

    public void setJava8(boolean java8) {
        this.java8 = java8;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            model.imports.add("JsonProperty");
            if (BooleanUtils.toBoolean((Boolean)model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }
}

