/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.models.media;

import io.swagger.oas.models.examples.Example;
import io.swagger.oas.models.media.Encoding;
import io.swagger.oas.models.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MediaType {
    private Schema schema = null;
    private Map<String, Example> examples = null;
    private String example = null;
    private Map<String, Encoding> encoding = null;
    private Map<String, Object> extensions = null;

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public MediaType schema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public void setExamples(Map<String, Example> examples) {
        this.examples = examples;
    }

    public MediaType examples(Map<String, Example> examples) {
        this.examples = examples;
        return this;
    }

    public MediaType addExamples(String key, Example examplesItem) {
        if (this.examples == null) {
            this.examples = new HashMap<String, Example>();
        }
        this.examples.put(key, examplesItem);
        return this;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public MediaType example(String example) {
        this.example = example;
        return this;
    }

    public Map<String, Encoding> getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Map<String, Encoding> encoding) {
        this.encoding = encoding;
    }

    public MediaType encoding(Map<String, Encoding> encoding) {
        this.encoding = encoding;
        return this;
    }

    public MediaType addEncoding(String key, Encoding encodingItem) {
        if (this.encoding == null) {
            this.encoding = new HashMap<String, Encoding>();
        }
        this.encoding.put(key, encodingItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return Objects.equals(this.schema, mediaType.schema) && Objects.equals(this.examples, mediaType.examples) && Objects.equals(this.example, mediaType.example) && Objects.equals(this.encoding, mediaType.encoding) && Objects.equals(this.extensions, mediaType.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.examples, this.example, this.encoding, this.extensions);
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void addExtension(String name, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(name, value);
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaType {\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    examples: ").append(this.toIndentedString(this.examples)).append("\n");
        sb.append("    example: ").append(this.toIndentedString(this.example)).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.encoding)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

