/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.util.RefUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalRefProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRefProcessor.class);
    private final ResolverCache cache;
    private final Swagger swagger;

    public ExternalRefProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.swagger = swagger;
    }

    public String processRefToExternalDefinition(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Model existingModel;
        Model model = this.cache.loadRef($ref, refFormat, Model.class);
        HashMap definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            definitions = new HashMap();
        }
        if ((existingModel = (Model)definitions.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingModel + " already exists");
            if (existingModel instanceof RefModel) {
                existingModel = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingModel == null) {
            Map subProps;
            this.swagger.addDefinition(newRef, model);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (model instanceof RefModel) {
                RefModel refModel = (RefModel)model;
                if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat())) {
                    refModel.set$ref(this.processRefToExternalDefinition(refModel.get$ref(), refModel.getRefFormat()));
                } else {
                    this.processRefToExternalDefinition(file + refModel.get$ref(), RefFormat.RELATIVE);
                }
            }
            if ((subProps = model.getProperties()) != null) {
                for (Map.Entry prop : subProps.entrySet()) {
                    if (prop.getValue() instanceof RefProperty) {
                        this.processRefProperty((RefProperty)prop.getValue(), file);
                        continue;
                    }
                    if (prop.getValue() instanceof ArrayProperty) {
                        ArrayProperty arrayProp = (ArrayProperty)prop.getValue();
                        if (!(arrayProp.getItems() instanceof RefProperty)) continue;
                        this.processRefProperty((RefProperty)arrayProp.getItems(), file);
                        continue;
                    }
                    if (!(prop.getValue() instanceof MapProperty)) continue;
                    MapProperty mapProp = (MapProperty)prop.getValue();
                    if (mapProp.getAdditionalProperties() instanceof RefProperty) {
                        this.processRefProperty((RefProperty)mapProp.getAdditionalProperties(), file);
                        continue;
                    }
                    if (!(mapProp.getAdditionalProperties() instanceof ArrayProperty) || !(((ArrayProperty)mapProp.getAdditionalProperties()).getItems() instanceof RefProperty)) continue;
                    this.processRefProperty((RefProperty)((ArrayProperty)mapProp.getAdditionalProperties()).getItems(), file);
                }
            }
            if (model instanceof ArrayModel && ((ArrayModel)model).getItems() instanceof RefProperty) {
                this.processRefProperty((RefProperty)((ArrayModel)model).getItems(), file);
            }
        }
        return newRef;
    }

    private void processRefProperty(RefProperty subRef, String externalFile) {
        if (RefUtils.isAnExternalRefFormat(subRef.getRefFormat())) {
            String $ref = this.constructRef(subRef, externalFile);
            subRef.set$ref($ref);
            if ($ref.startsWith(".")) {
                this.processRefToExternalDefinition($ref, RefFormat.RELATIVE);
            } else {
                this.processRefToExternalDefinition($ref, RefFormat.URL);
            }
        } else {
            this.processRefToExternalDefinition(externalFile + subRef.get$ref(), RefFormat.RELATIVE);
        }
    }

    protected String constructRef(RefProperty refProperty, String rootLocation) {
        String ref = refProperty.get$ref();
        return ExternalRefProcessor.join(rootLocation, ref);
    }

    public static String join(String source, String fragment) {
        try {
            boolean isRelative = false;
            if (source.startsWith("/") || source.startsWith(".")) {
                isRelative = true;
            }
            URI uri = new URI(source);
            if (!source.endsWith("/") && fragment.startsWith("./") && "".equals(uri.getPath())) {
                uri = new URI(source + "/");
            } else if ("".equals(uri.getPath()) && !fragment.startsWith("/")) {
                uri = new URI(source + "/");
            }
            URI f = new URI(fragment);
            URI resolved = uri.resolve(f);
            URI normalized = resolved.normalize();
            if (Character.isAlphabetic(normalized.toString().charAt(0)) && isRelative) {
                return "./" + normalized.toString();
            }
            return normalized.toString();
        }
        catch (Exception e) {
            return source;
        }
    }
}

