/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components;

import java.io.File;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.StringVector;
import org.tecgraf.jtdk.core.swig.TdkSetup;

public class TdkDbfAttributesCombo
extends JComboBox {
    protected String _shapefile;
    private static Logger _logger = Logger.getLogger(TdkDbfAttributesCombo.class);

    public TdkDbfAttributesCombo(String string) {
        this.setShapefile(string);
    }

    public TdkDbfAttributesCombo() {
        this((String)null);
    }

    public void setShapefile(String string) {
        _logger.debug((Object)("Setting shapefile " + string));
        this._shapefile = string;
        this.fillAttributesList();
    }

    public void fillAttributesList() {
        this.removeAllItems();
        if (this._shapefile != null && this._shapefile.length() > 0) {
            File file = new File(this._shapefile);
            if (!file.exists()) {
                _logger.debug((Object)"Shapefile not found");
                return;
            }
            int n = this._shapefile.lastIndexOf(".");
            if (n == -1) {
                return;
            }
            String string = this._shapefile.substring(0, n);
            File file2 = new File(string = string + ".dbf");
            if (!file2.exists()) {
                _logger.debug((Object)"DBF file not found");
                return;
            }
            StringVector stringVector = TdkSetup.getPersistenceService().readDBFAttributesNames(string);
            if (stringVector != null) {
                int n2 = 0;
                while ((long)n2 < stringVector.size()) {
                    this.addItem(stringVector.get(n2));
                    ++n2;
                }
            }
        }
    }

    public String getSelectedAttribute() {
        if (this.getItemCount() == 0) {
            _logger.debug((Object)"No selected attribute");
            return null;
        }
        String string = (String)this.getSelectedItem();
        _logger.debug((Object)("Selected attribute: " + string));
        return string;
    }
}

