/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components;

import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkActionWorkflowService;
import org.tecgraf.jtdk.core.TdkCreateThemeParams;
import org.tecgraf.jtdk.core.TdkImportShapeParams;
import org.tecgraf.jtdk.core.TdkNativeFeedback;
import org.tecgraf.jtdk.core.exceptions.TdkDatabaseException;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.exceptions.TdkNullPointerException;
import org.tecgraf.jtdk.core.swig.TdkAbstractPersistenceService;
import org.tecgraf.jtdk.core.swig.TdkConDescriptor;
import org.tecgraf.jtdk.core.swig.TdkLayerGID;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TdkThemeGroup;
import org.tecgraf.jtdk.core.swig.TdkThemeGroupGID;
import org.tecgraf.jtdk.core.swig.TeDatumFactory;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.core.swig.TeProjectionFactory;
import org.tecgraf.jtdk.core.swig.TeProjectionParams;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkCreateThemeDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkEditProjectionDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkFileChooserFilter;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkImportSHPDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkMessagePopUpDialog;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;

public class TdkDefaultActionWorkflowService
implements TdkActionWorkflowService {
    private static Logger _logger = Logger.getLogger(TdkDefaultActionWorkflowService.class);

    public TdkConDescriptor connectToAccessDatabase() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        TdkFileChooserFilter tdkFileChooserFilter = new TdkFileChooserFilter("mdb");
        tdkFileChooserFilter.setDescription("Access Database Files");
        jFileChooser.addChoosableFileFilter(tdkFileChooserFilter);
        int n = jFileChooser.showDialog(null, "Open");
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            String string = file.getAbsolutePath();
            TdkConDescriptor tdkConDescriptor = TdkConDescriptor.createConDescriptor((String)("Ado;" + string));
            return tdkConDescriptor;
        }
        return null;
    }

    public TeProjection editProjection(TeProjection teProjection) {
        if (teProjection == null) {
            return this.askForProjection();
        }
        TeProjectionParams teProjectionParams = teProjection.getParams();
        TdkEditProjectionDialog tdkEditProjectionDialog = new TdkEditProjectionDialog(new JFrame());
        TeProjection teProjection2 = tdkEditProjectionDialog.editProjection(teProjection);
        if (teProjection2 == null) {
            return teProjection;
        }
        return teProjection2;
    }

    public TeProjection askForProjection() {
        TeProjectionParams teProjectionParams = new TeProjectionParams();
        teProjectionParams.setName("LatLong");
        teProjectionParams.setDatum(TeDatumFactory.make((String)"SAD69"));
        return this.editProjection(TeProjectionFactory.make((TeProjectionParams)teProjectionParams));
    }

    public TdkLayerGID importShapeFile(TdkConDescriptor tdkConDescriptor) {
        _logger.info((Object)"Import Shape workflow started");
        TdkImportSHPDialog tdkImportSHPDialog = new TdkImportSHPDialog((Frame)new JFrame(), tdkConDescriptor);
        tdkImportSHPDialog.showDialog();
        TdkImportShapeParams tdkImportShapeParams = tdkImportSHPDialog.getResultParams();
        if (tdkImportShapeParams == null) {
            _logger.info((Object)"User cancelled, no shape imported");
            return null;
        }
        TdkLayerGID tdkLayerGID = null;
        TdkNativeFeedback tdkNativeFeedback = null;
        try {
            TdkAbstractPersistenceService tdkAbstractPersistenceService = TdkSetup.getPersistenceService();
            tdkLayerGID = tdkAbstractPersistenceService.importShape(tdkImportShapeParams.getLayerName(), tdkConDescriptor.getDbKey(), tdkImportShapeParams.getShapefileLocation(), tdkImportShapeParams.getProjection(), tdkNativeFeedback, tdkImportShapeParams.getLinkingAttribute(), true);
            _logger.info((Object)("Shape " + tdkImportShapeParams.getShapefileLocation() + " imported succesfully"));
        }
        catch (Exception exception) {
            _logger.debug((Object)"Exception in import shape workflow", (Throwable)exception);
            _logger.error((Object)"Exception in import shape workflow", (Throwable)exception);
        }
        return tdkLayerGID;
    }

    public TdkTheme createTheme(Frame frame, String string) throws TdkDatabaseException, TdkNullPointerException, TdkException {
        TdkTheme tdkTheme = null;
        TdkCreateThemeDialog tdkCreateThemeDialog = new TdkCreateThemeDialog(frame, string);
        TdkDialogUtil.centralize(tdkCreateThemeDialog, frame);
        tdkCreateThemeDialog.setVisible(true);
        TdkCreateThemeParams tdkCreateThemeParams = tdkCreateThemeDialog.getResult();
        if (tdkCreateThemeParams != null) {
            tdkTheme = TdkSetup.getPersistenceService().createThemeInDB(tdkCreateThemeParams.getName(), tdkCreateThemeParams.getLayerGID(), tdkCreateThemeParams.getViewGID(), string);
            return tdkTheme;
        }
        return null;
    }

    public boolean removeTheme(Frame frame, TdkThemeGID tdkThemeGID) throws TdkDatabaseException, TdkException {
        _logger.info((Object)"Remove theme workflow started");
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
        if (tdkTheme == null) {
            return false;
        }
        String string = tdkTheme.getName();
        String string2 = TdkMessagePopUpDialog.showOkCancelDialog(TdkComponentsI18n.getString("DLG_REMOVE_THEME_MESSAGE") + " " + string + "?", frame, TdkComponentsI18n.getString("DLG_REMOVE_THEME_TITLE"));
        boolean bl = false;
        if (string2.equals("ok_command")) {
            TdkSetup.getPersistenceService().removeTheme(tdkThemeGID);
            tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
            if (tdkTheme == null) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean removeThemeGroup(Frame frame, TdkThemeGroupGID tdkThemeGroupGID) throws TdkDatabaseException, TdkException {
        _logger.info((Object)"Remove theme group workflow started");
        TdkThemeGroup tdkThemeGroup = TdkSetup.getPersistenceService().getThemeGroup(tdkThemeGroupGID);
        String string = tdkThemeGroup.getName();
        String string2 = TdkMessagePopUpDialog.showOkCancelDialog(TdkComponentsI18n.getString("DLG_REMOVE_THEME_GROUP_MESSAGE") + " " + string + "?", frame, TdkComponentsI18n.getString("DLG_REMOVE_THEME_GROUP_TITLE"));
        boolean bl = false;
        if (string2.equals("ok_command")) {
            TdkSetup.getPersistenceService().removeThemeGroup(tdkThemeGroupGID);
            tdkThemeGroup = TdkSetup.getPersistenceService().getThemeGroup(tdkThemeGroupGID);
            if (tdkThemeGroup == null) {
                bl = true;
            }
        }
        return bl;
    }
}

