/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkThemeGeographicObjectGIDSet;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TdkViewGeographicObjectGIDSet;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContextListener;

public class TdkObjectSelectionContext {
    protected TdkViewGID _viewGID = null;
    protected TdkViewGeographicObjectGIDSet _selectedObjects = null;
    protected Vector<TdkObjectSelectionContextListener> _listeners = new Vector();
    private static Logger _logger = Logger.getLogger(TdkObjectSelectionContext.class);

    public TdkObjectSelectionContext() {
    }

    public TdkObjectSelectionContext(TdkViewGID tdkViewGID) {
        this();
        this.setViewGID(tdkViewGID);
    }

    public void setViewGID(TdkViewGID tdkViewGID) {
        if (tdkViewGID != null) {
            this._viewGID = tdkViewGID;
            this._selectedObjects = new TdkViewGeographicObjectGIDSet(this._viewGID);
            _logger.debug((Object)("new view gid set: " + this._viewGID.toString()));
        } else {
            _logger.debug((Object)"null view gid set");
            this._viewGID = null;
            this._selectedObjects = null;
            this._listeners.clear();
        }
    }

    public TdkViewGID getViewGID() {
        return this._viewGID;
    }

    public void setSelectedObjects(TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (this._selectedObjects.size() == 0 && (tdkViewGeographicObjectGIDSet == null || tdkViewGeographicObjectGIDSet.size() == 0)) {
            return;
        }
        if (this._viewGID != null && tdkViewGeographicObjectGIDSet.getViewId() == this._viewGID.getId() && tdkViewGeographicObjectGIDSet.getViewDBKey().equals(this._viewGID.getDBKey())) {
            this.fireSelectedObjectsChanged(true, this, this._selectedObjects);
            this._selectedObjects = tdkViewGeographicObjectGIDSet;
            _logger.info((Object)"new object set selected");
            this.fireSelectedObjectsChanged(false, this, this._selectedObjects);
        }
    }

    public void addSelectedObjects(TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (tdkViewGeographicObjectGIDSet != null && tdkViewGeographicObjectGIDSet.size() != 0 && this._viewGID != null && tdkViewGeographicObjectGIDSet.getViewId() == this._viewGID.getId() && tdkViewGeographicObjectGIDSet.getViewDBKey().equals(this._viewGID.getDBKey())) {
            this.fireSelectedObjectsChanged(true, this, this._selectedObjects);
            if (this._selectedObjects == null) {
                this._selectedObjects = tdkViewGeographicObjectGIDSet;
            } else {
                this._selectedObjects.add(tdkViewGeographicObjectGIDSet);
            }
            _logger.info((Object)(tdkViewGeographicObjectGIDSet.size() + " objects added to selection"));
            this.fireSelectedObjectsChanged(false, this, this._selectedObjects);
        }
    }

    public void removeSelectedObjects(TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (tdkViewGeographicObjectGIDSet != null && tdkViewGeographicObjectGIDSet.size() != 0 && this._viewGID != null && tdkViewGeographicObjectGIDSet.getViewId() == this._viewGID.getId() && tdkViewGeographicObjectGIDSet.getViewDBKey().equals(this._viewGID.getDBKey())) {
            this.fireSelectedObjectsChanged(true, this, this._selectedObjects);
            if (this._selectedObjects != null && tdkViewGeographicObjectGIDSet != null) {
                this._selectedObjects.remove(tdkViewGeographicObjectGIDSet);
                _logger.info((Object)(tdkViewGeographicObjectGIDSet.size() + " objects removed from selection"));
            }
            this.fireSelectedObjectsChanged(false, this, this._selectedObjects);
        }
    }

    public void removeSelectedObjects(TdkThemeGeographicObjectGIDSet tdkThemeGeographicObjectGIDSet) {
        if (tdkThemeGeographicObjectGIDSet != null && tdkThemeGeographicObjectGIDSet.size() != 0 && this._viewGID != null && tdkThemeGeographicObjectGIDSet.getThemeDBKey().equals(this._viewGID.getDBKey())) {
            this.fireSelectedObjectsChanged(true, this, this._selectedObjects);
            if (this._selectedObjects != null && tdkThemeGeographicObjectGIDSet != null) {
                this._selectedObjects.remove(tdkThemeGeographicObjectGIDSet);
                _logger.info((Object)(tdkThemeGeographicObjectGIDSet.size() + " objects removed from selection"));
            }
            this.fireSelectedObjectsChanged(false, this, this._selectedObjects);
        }
    }

    public void clearSelectedObjects() {
        if (this._viewGID != null) {
            if (this._selectedObjects.size() != 0) {
                this.fireSelectedObjectsChanged(true, this, this._selectedObjects);
                this._selectedObjects.clear();
                this.fireSelectedObjectsChanged(false, this, this._selectedObjects);
            }
            _logger.info((Object)"object selection cleared");
        }
    }

    public TdkViewGeographicObjectGIDSet getSelectedObjects() {
        return this._selectedObjects;
    }

    public void addObjectSelectionListener(TdkObjectSelectionContextListener tdkObjectSelectionContextListener) {
        this._listeners.add(tdkObjectSelectionContextListener);
        _logger.debug((Object)("added object as selection listener: " + tdkObjectSelectionContextListener));
    }

    public void removeObjectSelectionListener(TdkObjectSelectionContextListener tdkObjectSelectionContextListener) {
        this._listeners.remove(tdkObjectSelectionContextListener);
        _logger.debug((Object)("removed selection listener: " + tdkObjectSelectionContextListener));
    }

    protected void fireSelectedObjectsChanged(boolean bl, Object object, TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).selectedObjectsChanged(bl, object, tdkViewGeographicObjectGIDSet);
        }
    }
}

