/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.util.Rotation;
import org.tecgraf.jtdk.core.data.TdkColorModel;
import org.tecgraf.jtdk.core.data.TdkTable;
import org.tecgraf.jtdk.desktop.components.chart.TdkChartPanelListener;
import org.tecgraf.jtdk.desktop.components.chart.TdkChartRotator;
import org.tecgraf.jtdk.desktop.components.chart.TdkChartUtils;

public class TdkChartPanel
extends ChartPanel {
    private static final long serialVersionUID = -892043022895803241L;
    private static Logger _logger = Logger.getLogger(TdkChartPanel.class);
    public static final int CHART_TYPE_PIECHART = 0;
    public static final int CHART_TYPE_PIECHART3D = 1;
    public static final int CHART_TYPE_XY = 2;
    private TdkColorModel _colorModel;
    private int _type;
    private TdkChartRotator _rotator;
    protected Point zoomPoint;
    private Color _fullSelectionColor = Color.RED;
    private Color _partialSelectionColor = Color.ORANGE;
    private HashMap<Comparable, SelectionInfo> _selectedSections;
    private Collection<TdkChartPanelListener> _chartPanelListeners;
    public static final int TOOL_SELECTION = 1;
    public static final int TOOL_ZOOMBOX = 2;
    private int _activeTool;

    public TdkChartPanel(JFreeChart jFreeChart, int n, int n2, int n3, TdkColorModel tdkColorModel) {
        super(jFreeChart);
        this._type = n3;
        this.setPreferredSize(new Dimension(n, n2));
        this._colorModel = tdkColorModel;
        this._selectedSections = new HashMap();
        this._chartPanelListeners = new ArrayList<TdkChartPanelListener>();
        if (this._type == 1 || this._type == 0) {
            this._rotator = new TdkChartRotator((PiePlot3D)this.getChart().getPlot(), Rotation.CLOCKWISE);
        }
    }

    public void addChartPanelListener(TdkChartPanelListener tdkChartPanelListener) {
        this._chartPanelListeners.add(tdkChartPanelListener);
    }

    public void removeChartPanelListener(TdkChartPanelListener tdkChartPanelListener) {
        this._chartPanelListeners.remove(tdkChartPanelListener);
    }

    public Point getZoomPoint() {
        return this.zoomPoint;
    }

    public void updateData(TdkTable tdkTable, String string, String string2) {
        Dimension dimension = this.getPreferredSize();
        TdkChartPanel tdkChartPanel = null;
        switch (this._type) {
            case 0: {
                tdkChartPanel = TdkChartUtils.makePieChart(dimension.width, dimension.height, tdkTable, string, string2, this._colorModel, false);
                break;
            }
            case 1: {
                tdkChartPanel = TdkChartUtils.makePieChart(dimension.width, dimension.height, tdkTable, string, string2, this._colorModel, true);
            }
        }
        if (tdkChartPanel != null) {
            super.setChart(tdkChartPanel.getChart());
            this._selectedSections.clear();
        }
        if (this._rotator != null) {
            this._rotator = new TdkChartRotator((PiePlot3D)this.getChart().getPlot(), Rotation.CLOCKWISE);
        }
        _logger.debug((Object)"data updated");
    }

    public void startStopRotation() {
        if (this._rotator != null) {
            if (this._rotator.isRunning()) {
                this._rotator.stop();
            } else {
                this._rotator.start();
            }
        }
    }

    public void startRotation() {
        if (this._rotator != null) {
            this._rotator.start();
        }
    }

    public void stopRotation() {
        if (this._rotator != null) {
            this._rotator.stop();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        switch (this._activeTool) {
            case 1: {
                this.select(mouseEvent);
                break;
            }
            case 2: {
                this.zoomin(mouseEvent);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        switch (this._activeTool) {
            case 1: {
                break;
            }
            case 2: {
                super.mouseClicked(mouseEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        switch (this._activeTool) {
            case 1: {
                break;
            }
            case 2: {
                super.mousePressed(mouseEvent);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        switch (this._activeTool) {
            case 1: {
                break;
            }
            case 2: {
                super.mouseDragged(mouseEvent);
            }
        }
    }

    public void select(MouseEvent mouseEvent) {
        ChartEntity chartEntity = this.getEntityByPosition(mouseEvent.getX(), mouseEvent.getY());
        if (chartEntity != null && !(chartEntity instanceof LegendItemEntity)) {
            if (this._type == 1 || this._type == 0) {
                Comparable comparable = ((PieSectionEntity)chartEntity).getSectionKey();
                PiePlot piePlot = (PiePlot)this.getChart().getPlot();
                Color color = (Color)piePlot.getSectionPaint(comparable);
                SelectionInfo selectionInfo = this._selectedSections.get(comparable);
                if (selectionInfo != null) {
                    Paint paint = selectionInfo._originalColor;
                    if ((mouseEvent.getModifiersEx() & 0x80) == 0) {
                        int n = this._selectedSections.size();
                        Set<Map.Entry<Comparable, SelectionInfo>> set = this._selectedSections.entrySet();
                        for (Map.Entry<Comparable, SelectionInfo> entry : set) {
                            piePlot.setSectionPaint(entry.getKey(), entry.getValue()._originalColor);
                        }
                        this._selectedSections.clear();
                        if (n > 1) {
                            this._selectedSections.put(comparable, new SelectionInfo(paint, true));
                            piePlot.setSectionPaint(comparable, (Paint)this._fullSelectionColor);
                        }
                    } else if (selectionInfo._fullSelection) {
                        piePlot.setSectionPaint(comparable, paint);
                        this._selectedSections.remove(comparable);
                    } else {
                        piePlot.setSectionPaint(comparable, (Paint)this._fullSelectionColor);
                        this._selectedSections.put(comparable, new SelectionInfo(paint, true));
                    }
                } else {
                    if ((mouseEvent.getModifiersEx() & 0x80) == 0) {
                        Set<Map.Entry<Comparable, SelectionInfo>> set = this._selectedSections.entrySet();
                        for (Map.Entry<Comparable, SelectionInfo> entry : set) {
                            piePlot.setSectionPaint(entry.getKey(), entry.getValue()._originalColor);
                        }
                        this._selectedSections.clear();
                    }
                    this._selectedSections.put(comparable, new SelectionInfo(color, true));
                    piePlot.setSectionPaint(comparable, (Paint)this._fullSelectionColor);
                }
            }
            _logger.debug((Object)"selection changed");
            this.fireSelectionEvent();
        }
    }

    public void zoomin(MouseEvent mouseEvent) {
        if (this._type == 2) {
            super.mouseReleased(mouseEvent);
        }
    }

    private void fireSelectionEvent() {
        for (TdkChartPanelListener tdkChartPanelListener : this._chartPanelListeners) {
            tdkChartPanelListener.selectionChanged();
        }
    }

    private ChartEntity getEntityByPosition(int n, int n2) {
        EntityCollection entityCollection;
        ChartEntity chartEntity = null;
        ChartRenderingInfo chartRenderingInfo = super.getChartRenderingInfo();
        if (chartRenderingInfo != null && (entityCollection = chartRenderingInfo.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            chartEntity = entityCollection.getEntity((double)((int)((double)(n - insets.left) / super.getScaleX())), (double)((int)((double)(n2 - insets.top) / super.getScaleY())));
        }
        return chartEntity;
    }

    public Set<Comparable> getCurrentSelection() {
        return this._selectedSections.keySet();
    }

    public void setSelection(HashMap<Comparable, Boolean> hashMap) {
        PiePlot piePlot = (PiePlot)this.getChart().getPlot();
        Set<Map.Entry<Comparable, SelectionInfo>> set = this._selectedSections.entrySet();
        for (Map.Entry<Comparable, SelectionInfo> entry : set) {
            piePlot.setSectionPaint(entry.getKey(), entry.getValue()._originalColor);
        }
        this._selectedSections.clear();
        for (Map.Entry<Comparable, Object> entry : hashMap.entrySet()) {
            Comparable comparable = entry.getKey();
            SelectionInfo selectionInfo = new SelectionInfo(piePlot.getSectionPaint(comparable), (Boolean)entry.getValue());
            this._selectedSections.put(comparable, selectionInfo);
            if (((Boolean)entry.getValue()).booleanValue()) {
                piePlot.setSectionPaint(comparable, (Paint)this._fullSelectionColor);
                continue;
            }
            piePlot.setSectionPaint(comparable, (Paint)this._partialSelectionColor);
        }
    }

    public void setActiveTool(int n) {
        this._activeTool = n;
    }

    private class SelectionInfo {
        Paint _originalColor;
        boolean _fullSelection;

        public SelectionInfo(Paint paint, boolean bl) {
            this._originalColor = paint;
            this._fullSelection = bl;
        }
    }
}

