/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.chart;

import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.data.TdkTable;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TdkThemeGeographicObjectGIDSet;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TdkViewGeographicObjectGIDSet;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContext;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContextListener;
import org.tecgraf.jtdk.desktop.components.chart.TdkChartDataMapping;
import org.tecgraf.jtdk.desktop.components.chart.TdkChartPanel;
import org.tecgraf.jtdk.desktop.components.chart.TdkChartPanelListener;

public class TdkChartPanelController
implements TdkChartPanelListener,
TdkObjectSelectionContextListener {
    private static Logger _logger = Logger.getLogger(TdkChartPanelController.class);
    private TdkChartPanel _panel;
    private TdkChartDataMapping _mapping = null;
    private TdkObjectSelectionContext _selectionContext = null;
    private boolean _isMyEvent = false;

    public TdkChartPanelController(TdkChartPanel tdkChartPanel) {
        this._panel = tdkChartPanel;
        if (this._panel != null) {
            this._panel.addChartPanelListener(this);
        }
    }

    public void setSelectionContext(TdkObjectSelectionContext tdkObjectSelectionContext) {
        this._selectionContext = tdkObjectSelectionContext;
    }

    public void setData(TdkThemeGID tdkThemeGID, TdkTable tdkTable, String string, String string2) {
        this._mapping = new TdkChartDataMapping(tdkThemeGID, tdkTable, string, string2);
    }

    public void dataUpdated(TdkThemeGID tdkThemeGID, TdkTable tdkTable, String string, String string2, String string3) {
        this._mapping = new TdkChartDataMapping(tdkThemeGID, tdkTable, string, string3);
        this._panel.updateData(tdkTable, string2, string3);
    }

    @Override
    public void selectionChanged() {
        _logger.debug((Object)"selection changed from chart");
        Set<Comparable> set = this._panel.getCurrentSelection();
        TdkThemeGeographicObjectGIDSet tdkThemeGeographicObjectGIDSet = this._mapping.getObjectGIDsFromSelection(set);
        TdkViewGID tdkViewGID = this._selectionContext.getViewGID();
        if (tdkViewGID == null) {
            return;
        }
        TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet = new TdkViewGeographicObjectGIDSet(tdkViewGID.getId(), tdkViewGID.getDBKey());
        tdkViewGeographicObjectGIDSet.add(tdkThemeGeographicObjectGIDSet);
        this._isMyEvent = true;
        this._selectionContext.setSelectedObjects(tdkViewGeographicObjectGIDSet);
        this._isMyEvent = false;
    }

    @Override
    public void selectedObjectsChanged(boolean bl, Object object, TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (this._isMyEvent) {
            return;
        }
        int n = this._mapping.getThemeGID().getId();
        HashMap<Comparable, Boolean> hashMap = this._mapping.getEntitiesFromGIDSelection(tdkViewGeographicObjectGIDSet.getTdkThemeGeographicObjectGIDSet(n));
        this._panel.setSelection(hashMap);
        _logger.debug((Object)"listened to selection context change event");
    }
}

