/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.chart;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import org.tecgraf.jtdk.desktop.components.chart.TdkChartPanel;
import org.tecgraf.jtdk.desktop.components.chart.TdkChartToolbarController;
import org.tecgraf.jtdk.desktop.components.chart.tool.TdkChartFitTool;
import org.tecgraf.jtdk.desktop.components.chart.tool.TdkChartPrintTool;
import org.tecgraf.jtdk.desktop.components.chart.tool.TdkChartSaveTool;
import org.tecgraf.jtdk.desktop.components.chart.tool.TdkChartSelectionTool;
import org.tecgraf.jtdk.desktop.components.chart.tool.TdkChartTool;
import org.tecgraf.jtdk.desktop.components.chart.tool.TdkChartZoomBoxTool;
import org.tecgraf.jtdk.desktop.components.chart.tool.TdkChartZoomInTool;
import org.tecgraf.jtdk.desktop.components.chart.tool.TdkChartZoomOutTool;
import org.tecgraf.jtdk.desktop.components.util.TdkToolBar;

public class TdkChartToolbar
extends TdkToolBar {
    private static final long serialVersionUID = 406140279384428843L;
    private TdkChartPanel _chart;
    public static final String BTN_ROTATE = "rotate";
    private JButton _rotateButton;
    private List<AbstractButton> _buttonList = new ArrayList<AbstractButton>();
    private List<TdkChartTool> _toolList = new ArrayList<TdkChartTool>();
    private TdkChartToolbarController _controller;

    public TdkChartToolbar(TdkChartPanel tdkChartPanel) {
        this._chart = tdkChartPanel;
        this._controller = new TdkChartToolbarController(this);
        this.initDefaultTools();
    }

    private void initDefaultTools() {
        this.add(new TdkChartSelectionTool(this._chart), true);
        this.add(new TdkChartZoomBoxTool(this._chart), true);
        this.add(new TdkChartZoomInTool(this._chart), true);
        this.add(new TdkChartZoomOutTool(this._chart), true);
        this.add(new TdkChartFitTool(this._chart), true);
        this.addVerticalSeparator();
        this._rotateButton = this.createJButton();
        this._rotateButton.setName(BTN_ROTATE);
        this._rotateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/refresh.gif")));
        this._rotateButton.setBorder(BorderFactory.createBevelBorder(0));
        this._rotateButton.setActionCommand(BTN_ROTATE);
        this._rotateButton.setToolTipText("Start / Stop Rotation");
        this._rotateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TdkChartToolbar.this._chart.startStopRotation();
            }
        });
        this.addComponent(this._rotateButton);
        this.addVerticalSeparator();
        this.add(new TdkChartPrintTool(this._chart), true);
        this.add(new TdkChartSaveTool(this._chart), true);
        this.initComponents();
        ((JToggleButton)this._buttonList.get(0)).setSelected(true);
        this._chart.setActiveTool(1);
    }

    public AbstractButton add(TdkChartTool tdkChartTool) {
        return this.add(tdkChartTool, false);
    }

    public AbstractButton add(TdkChartTool tdkChartTool, boolean bl) {
        AbstractButton abstractButton = null;
        abstractButton = tdkChartTool.isToggleTool() ? this.createToggleButton() : this.createJButton();
        if (abstractButton != null) {
            abstractButton.setName(tdkChartTool.getName());
            abstractButton.setIcon(tdkChartTool.getIcon());
            abstractButton.setBorder(tdkChartTool.getBorder());
            abstractButton.setToolTipText(tdkChartTool.getToolTipText());
            this._buttonList.add(abstractButton);
            this._toolList.add(tdkChartTool);
            if (bl) {
                this.addComponent(abstractButton);
            } else {
                this.add(abstractButton);
            }
            abstractButton.addActionListener(tdkChartTool);
            abstractButton.addActionListener(this._controller);
        }
        return abstractButton;
    }

    protected JToggleButton createToggleButton() {
        return new JToggleButton();
    }

    protected JButton createJButton() {
        return new JButton();
    }

    public List<AbstractButton> getButtonList() {
        return this._buttonList;
    }
}

