/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.chart;

import java.awt.Color;
import java.awt.Paint;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.tecgraf.jtdk.core.data.TdkColorModel;
import org.tecgraf.jtdk.core.data.TdkTable;
import org.tecgraf.jtdk.core.data.TdkTableDataTypes;
import org.tecgraf.jtdk.desktop.components.chart.TdkChartOptions;
import org.tecgraf.jtdk.desktop.components.chart.TdkChartPanel;

public class TdkChartUtils {
    public static TdkChartPanel makePieChart(int n, int n2, TdkTable tdkTable, String string, String string2, TdkColorModel tdkColorModel, boolean bl) {
        TdkChartOptions tdkChartOptions = new TdkChartOptions();
        tdkChartOptions.setIs3D(bl);
        return TdkChartUtils.makePieChart(n, n2, tdkTable, string, string2, tdkColorModel, tdkChartOptions);
    }

    public static TdkChartPanel makePieChart(int n, int n2, TdkTable tdkTable, String string, String string2, TdkColorModel tdkColorModel, TdkChartOptions tdkChartOptions) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        if (!TdkChartUtils.fillDefaultPieDataset(defaultPieDataset, tdkTable, string, string2)) {
            return null;
        }
        JFreeChart jFreeChart = TdkChartUtils.createPieChart(defaultPieDataset, tdkColorModel, tdkChartOptions);
        return new TdkChartPanel(jFreeChart, n, n2, 1, tdkColorModel);
    }

    private static boolean fillDefaultPieDataset(DefaultPieDataset defaultPieDataset, TdkTable tdkTable, String string, String string2) {
        if (defaultPieDataset == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (tdkTable == null) {
            return false;
        }
        int n = tdkTable.columnType(tdkTable.columnIndex(string));
        if (n != 1 && n != 2) {
            return false;
        }
        int n2 = tdkTable.numRows();
        int n3 = tdkTable.columnIndex(string);
        for (int i = 0; i < n2; ++i) {
            double d;
            try {
                d = n == 1 ? TdkTableDataTypes.integerValue((Object)tdkTable.getElement(i, n3)).doubleValue() : TdkTableDataTypes.realValue((Object)tdkTable.getElement(i, n3)).doubleValue();
            }
            catch (Exception exception) {
                continue;
            }
            Comparable<Integer> comparable = null;
            if (string2 == null) {
                comparable = new Integer(i);
            } else {
                try {
                    comparable = (Comparable)tdkTable.getElement(i, string2);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (comparable == null) continue;
            double d2 = 0.0;
            try {
                d2 = defaultPieDataset.getValue((Comparable)comparable).doubleValue();
            }
            catch (Exception exception) {
                d2 = 0.0;
            }
            defaultPieDataset.setValue((Comparable)comparable, d2 + d);
        }
        return true;
    }

    private static JFreeChart createPieChart(DefaultPieDataset defaultPieDataset, TdkColorModel tdkColorModel, TdkChartOptions tdkChartOptions) {
        JFreeChart jFreeChart = tdkChartOptions.is3D() ? ChartFactory.createPieChart3D((String)tdkChartOptions.getTitle(), (PieDataset)defaultPieDataset, (boolean)tdkChartOptions.includeLegend(), (boolean)tdkChartOptions.includeTooltips(), (boolean)tdkChartOptions.includeUrls()) : ChartFactory.createPieChart((String)tdkChartOptions.getTitle(), (PieDataset)defaultPieDataset, (boolean)tdkChartOptions.includeLegend(), (boolean)tdkChartOptions.includeTooltips(), (boolean)tdkChartOptions.includeUrls());
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        piePlot.setForegroundAlpha(0.5f);
        piePlot.setStartAngle(0.0);
        if (tdkColorModel != null) {
            try {
                Paint[] paintArray = TdkChartUtils.generateColorMap((PieDataset)defaultPieDataset, tdkColorModel);
                DefaultDrawingSupplier defaultDrawingSupplier = new DefaultDrawingSupplier(paintArray, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
                piePlot.setDrawingSupplier((DrawingSupplier)defaultDrawingSupplier);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jFreeChart;
    }

    private static Color[] generateColorMap(PieDataset pieDataset, TdkColorModel tdkColorModel) {
        if (pieDataset == null) {
            return null;
        }
        if (tdkColorModel == null) {
            return null;
        }
        int n = pieDataset.getItemCount();
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            Number number = pieDataset.getValue(i);
            colorArray[i] = new Color(tdkColorModel.getColor(number.doubleValue()));
        }
        return colorArray;
    }

    public static TdkChartPanel makeXYLineChart(int n, int n2, TdkTable tdkTable, String[] stringArray, String string, TdkChartOptions tdkChartOptions, TdkColorModel tdkColorModel) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        if (!TdkChartUtils.fillDefaultTableXYDataset(xYSeriesCollection, tdkTable, stringArray, string)) {
            return null;
        }
        JFreeChart jFreeChart = TdkChartUtils.createXYLineChart((XYDataset)xYSeriesCollection, tdkChartOptions, tdkColorModel);
        return new TdkChartPanel(jFreeChart, n, n2, 2, tdkColorModel);
    }

    private static boolean fillDefaultTableXYDataset(XYSeriesCollection xYSeriesCollection, TdkTable tdkTable, String[] stringArray, String string) {
        int n;
        int n2;
        if (xYSeriesCollection == null) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        if (tdkTable == null) {
            return false;
        }
        Vector<String> vector = new Vector<String>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            n = tdkTable.columnType(tdkTable.columnIndex(stringArray[n2]));
            if (n != 1 && n != 2) continue;
            vector.add(stringArray[n2]);
        }
        n = tdkTable.columnType(tdkTable.columnIndex(string));
        if (n != 1 && n != 2) {
            string = null;
        }
        int n3 = tdkTable.numRows();
        int n4 = vector.size();
        XYSeries[] xYSeriesArray = new XYSeries[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            xYSeriesArray[n2] = new XYSeries((Comparable)((Object)stringArray[n2]), true, false);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Number number;
            if (string == null) {
                number = new Integer(n2);
            } else {
                try {
                    number = (Number)tdkTable.getElement(n2, string);
                    if (number == null) {
                    }
                }
                catch (Exception exception) {}
                continue;
            }
            for (int i = 0; i < n4; ++i) {
                Number number2;
                try {
                    number2 = (Number)tdkTable.getElement(n2, (String)vector.elementAt(i));
                    if (number2 == null) {
                    }
                }
                catch (Exception exception) {}
                continue;
                try {
                    xYSeriesArray[i].add(number, number2, false);
                    continue;
                }
                catch (SeriesException seriesException) {
                    Number number3 = xYSeriesArray[i].getY(xYSeriesArray[i].indexOf(number));
                    number2 = new Double(number2.doubleValue() + number3.doubleValue());
                    xYSeriesArray[i].update(number, number2);
                }
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            xYSeriesCollection.addSeries(xYSeriesArray[n2]);
        }
        return true;
    }

    private static JFreeChart createXYLineChart(XYDataset xYDataset, TdkChartOptions tdkChartOptions, TdkColorModel tdkColorModel) {
        if (xYDataset == null) {
            return null;
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)tdkChartOptions.getTitle(), (String)tdkChartOptions.getDomainLabel(), (String)tdkChartOptions.getRangeLabel(), (XYDataset)xYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)tdkChartOptions.includeLegend(), (boolean)tdkChartOptions.includeTooltips(), (boolean)tdkChartOptions.includeUrls());
        if (tdkColorModel != null) {
            try {
                XYItemRenderer xYItemRenderer = jFreeChart.getXYPlot().getRenderer();
                Color[] colorArray = TdkChartUtils.generateColorMap(xYDataset, tdkColorModel);
                int n = colorArray.length;
                for (int i = 0; i < n; ++i) {
                    xYItemRenderer.setSeriesPaint(i, (Paint)colorArray[i]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jFreeChart;
    }

    private static Color[] generateColorMap(XYDataset xYDataset, TdkColorModel tdkColorModel) {
        if (xYDataset == null) {
            return null;
        }
        if (tdkColorModel == null) {
            return null;
        }
        int n = xYDataset.getSeriesCount();
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            Comparable comparable = xYDataset.getSeriesKey(i);
            colorArray[i] = new Color(tdkColorModel.getColor((Object)comparable));
        }
        return colorArray;
    }
}

