/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.defaultmodule;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkJavaProcessingService;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.model.utils.TdkStyleVariableSizeChecker;
import org.tecgraf.jtdk.core.swig.TdkLayer;
import org.tecgraf.jtdk.core.swig.TdkLayerGID;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TdkThemeGeographicObjectGIDSet;
import org.tecgraf.jtdk.core.swig.TdkThemeGroup;
import org.tecgraf.jtdk.core.swig.TdkThemeGroupGID;
import org.tecgraf.jtdk.core.swig.TdkView;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TdkViewGeographicObjectGIDSet;
import org.tecgraf.jtdk.core.swig.TdkViewNodeGID;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContext;
import org.tecgraf.jtdk.desktop.components.TdkViewChangeListener;
import org.tecgraf.jtdk.desktop.components.defaultmodule.actions.TdkRenameGroupAction;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkMessagePopUpDialog;
import org.tecgraf.jtdk.desktop.components.map.TdkMapController;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.TdkNavigationToolBar;
import org.tecgraf.jtdk.desktop.components.map.elements.TdkObjectIdentificationMapElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkThemeGroupLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkThemeLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeView;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeViewAdapter;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeViewController;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeViewListener;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateThemeEvent;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateViewEvent;
import org.tecgraf.jtdk.desktop.components.treeview.TdkViewLegendElement;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;
import org.tecgraf.jtdk.desktop.components.util.TdkMapUtil;

public class TdkDefaultApplicationModule {
    private static final Logger _logger = Logger.getLogger(TdkDefaultApplicationModule.class);
    protected TdkMapDisplay _display;
    protected TdkNavigationToolBar _toolbar;
    protected TdkObjectSelectionContext _context;
    protected TdkTreeView _treeView;
    protected TdkObjectIdentificationMapElement _identificationElement;
    protected boolean _packed = false;
    protected boolean _keepSelectionAfterThemeIsHidden = true;
    protected TdkMapController _mapControl;
    protected TdkTreeViewController _treeControl;
    private TdkViewGID _view;
    private TdkTreeViewListener _treeListener;
    private TdkViewChangeListener _viewListener;

    public TdkDefaultApplicationModule() {
        this.setDisplay(null);
        this.setTreeView(null);
        this.setSelectionContext(null);
        this.setToolbar(null);
    }

    public void setView(TdkViewGID tdkViewGID) {
        if (this._display != null) {
            this._display.setView(tdkViewGID);
        }
        if (this._treeView != null) {
            this._treeView.setView(tdkViewGID);
        }
        if (this._context != null) {
            this._context.setViewGID(tdkViewGID);
        }
        this._view = tdkViewGID;
        _logger.debug((Object)("new view set: " + tdkViewGID));
    }

    public TdkViewGID getView() {
        return this._view;
    }

    public TdkDefaultApplicationModule(TdkMapDisplay tdkMapDisplay, TdkTreeView tdkTreeView, TdkObjectSelectionContext tdkObjectSelectionContext, TdkNavigationToolBar tdkNavigationToolBar) {
        this.setSelectionContext(tdkObjectSelectionContext);
        this.setDisplay(tdkMapDisplay);
        this.setToolbar(tdkNavigationToolBar);
        this.setTreeView(tdkTreeView);
    }

    public void setDisplay(TdkMapDisplay tdkMapDisplay) {
        if (this._display != tdkMapDisplay) {
            this.unpack();
            this._display = tdkMapDisplay;
            this._packed = false;
            this.pack();
            if (this._view != null && this._display != null) {
                this._display.setView(this._view);
            }
            _logger.debug((Object)"new display was set");
        }
    }

    public void setToolbar(TdkNavigationToolBar tdkNavigationToolBar) {
        if (this._toolbar != tdkNavigationToolBar) {
            this.unpack();
            this._toolbar = tdkNavigationToolBar;
            this._packed = false;
            this.pack();
            _logger.debug((Object)"new toolbar was set");
        }
    }

    public void setSelectionContext(TdkObjectSelectionContext tdkObjectSelectionContext) {
        if (this._context != tdkObjectSelectionContext) {
            this.unpack();
            this._context = tdkObjectSelectionContext;
            this._packed = false;
            this.pack();
            if (this._view != null && this._context != null) {
                this._context.setViewGID(this._view);
            }
            _logger.debug((Object)"new object selection context was set");
        }
    }

    public void setTreeView(TdkTreeView tdkTreeView) {
        if (this._treeView != tdkTreeView) {
            this.unpack();
            this._treeView = tdkTreeView;
            this._packed = false;
            this.pack();
            if (this._view != null && this._treeView != null) {
                this._treeView.setView(this._view);
            }
            _logger.debug((Object)"new treeView was set");
        }
    }

    public void unpack() {
        if (this._context != null && this._mapControl != null) {
            this._context.removeObjectSelectionListener(this._mapControl);
        }
        if (this._display != null && this._identificationElement != null) {
            this._display.removeElement(this._identificationElement);
        }
        if (this._mapControl != null && this._treeView != null) {
            this._treeView.removeViewChangeListener(this._mapControl);
        }
        if (this._treeListener != null && this._treeView != null) {
            this._treeView.removeTreeViewListener(this._treeListener);
        }
        if (this._treeListener != null && this._treeView != null) {
            this._treeView.removeTreeViewListener(this._treeListener);
        }
        if (this._viewListener != null && this._treeView != null) {
            this._treeView.removeViewChangeListener(this._viewListener);
        }
        this._packed = false;
        _logger.debug((Object)"unpacked");
    }

    public void pack() {
        if (this._packed) {
            return;
        }
        this._mapControl = null;
        if (this._display != null) {
            if (this._mapControl == null) {
                this._mapControl = new TdkMapController(this._display);
            }
            if (this._context != null) {
                this._context.addObjectSelectionListener(this._mapControl);
            }
            if (this._identificationElement == null) {
                this._identificationElement = new TdkObjectIdentificationMapElement(this._display);
            }
            this._display.addElement(this._identificationElement, 0);
        }
        if (this._treeView != null) {
            if (this._treeControl == null) {
                this._treeControl = new TdkTreeViewController(this._treeView);
            }
            if (this._treeListener == null) {
                this._treeListener = new MyTreeListener();
            }
            this._treeView.addTreeViewListener(this._treeListener);
            if (this._viewListener == null) {
                this._viewListener = new MyViewChangeListener(this);
            }
            if (!this._keepSelectionAfterThemeIsHidden) {
                this._treeView.addViewChangeListener(this._viewListener);
            }
            if (this._mapControl != null) {
                this._treeView.addViewChangeListener(this._mapControl);
            }
        }
        this._packed = true;
        _logger.debug((Object)"packed");
    }

    public TdkMapDisplay getDisplay() {
        return this._display;
    }

    public TdkNavigationToolBar getToolbar() {
        return this._toolbar;
    }

    public TdkObjectSelectionContext getContext() {
        return this._context;
    }

    public TdkTreeView getTreeView() {
        return this._treeView;
    }

    public boolean isPacked() {
        return this._packed;
    }

    public boolean keepsSelectionAfterThemeIsHidden() {
        return this._keepSelectionAfterThemeIsHidden;
    }

    public void setKeepSelectionAfterThemeIsHidden(boolean bl) {
        this.unpack();
        this._keepSelectionAfterThemeIsHidden = bl;
        this.pack();
    }

    public void addSelectedObjects(TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (this.isPacked() && this._context != null) {
            this._context.addSelectedObjects(tdkViewGeographicObjectGIDSet);
            _logger.debug((Object)"selected objects added to context");
        } else {
            _logger.debug((Object)"selected objects addition to context could not be performed");
        }
    }

    public void removeSelectedObjects(TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (this.isPacked() && this._context != null) {
            this._context.removeSelectedObjects(tdkViewGeographicObjectGIDSet);
            _logger.debug((Object)"removed selected objects from context");
        } else {
            _logger.debug((Object)"selected objects removal from context could not be performed");
        }
    }

    public void setSelectedObjects(TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (this.isPacked() && this._context != null) {
            this._context.setSelectedObjects(tdkViewGeographicObjectGIDSet);
            _logger.debug((Object)"object selection set in context");
        } else {
            _logger.debug((Object)"selected objects could not be set");
        }
    }

    public TdkViewGeographicObjectGIDSet getIdentifiedObjects() {
        return this._identificationElement.getIdentifiedObjects();
    }

    public void removeThemeIdentification(TdkThemeGID tdkThemeGID) {
        if (this.isPacked() && tdkThemeGID != null && this._display != null) {
            TdkViewGID tdkViewGID = this._display.getView();
            this._identificationElement.setView(tdkViewGID);
            this._identificationElement.removeIdentifications(tdkThemeGID);
            this._identificationElement.requestShow();
            _logger.debug((Object)("removed theme identification: id=" + tdkThemeGID.getId() + ", dbKey=" + tdkThemeGID.getDBKey()));
        } else {
            _logger.debug((Object)"theme identification removal could not be performed");
        }
    }

    public void identifyTheme(TdkThemeGID tdkThemeGID) {
        if (this.isPacked() && tdkThemeGID != null && this._display != null) {
            TdkViewGID tdkViewGID = this._display.getView();
            this._identificationElement.setView(tdkViewGID);
            this._identificationElement.addIdentifications(tdkThemeGID);
            this._identificationElement.requestShow();
            _logger.debug((Object)("theme identified: id=" + tdkThemeGID.getId() + ", dbKey=" + tdkThemeGID.getDBKey()));
        } else {
            _logger.debug((Object)"theme identification could not be performed");
        }
    }

    public void removeSelectedIdentification() {
        if (this.isPacked() && this._context != null && this._display != null) {
            TdkViewGID tdkViewGID = this._display.getView();
            this._identificationElement.setView(tdkViewGID);
            this._identificationElement.removeIdentifications(this._context.getSelectedObjects());
            this._identificationElement.requestShow();
            _logger.debug((Object)"removed selected objects identification");
        } else {
            _logger.debug((Object)"selected objects removal from identification could not be performed");
        }
    }

    public void identifySelected() {
        if (this.isPacked() && this._context != null && this._display != null) {
            TdkViewGID tdkViewGID = this._display.getView();
            this._identificationElement.setView(tdkViewGID);
            this._identificationElement.addIdentifications(this._context.getSelectedObjects());
            this._identificationElement.requestShow();
            _logger.debug((Object)"identified selected objects");
        } else {
            _logger.debug((Object)"selected objects identification could not be performed");
        }
    }

    public void identifyObjects(TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (this.isPacked() && this._context != null && this._display != null && tdkViewGeographicObjectGIDSet != null) {
            TdkViewGID tdkViewGID = this._display.getView();
            this._identificationElement.setView(tdkViewGID);
            this._identificationElement.addIdentifications(tdkViewGeographicObjectGIDSet);
            this._identificationElement.requestShow();
            _logger.debug((Object)"identified objects");
        } else {
            _logger.debug((Object)"objects identification could not be performed");
        }
    }

    public void clearIdentifications() {
        if (this.isPacked()) {
            if (this._identificationElement != null && this._display != null) {
                this._identificationElement.clearIdentifications();
                this._identificationElement.requestShow();
                _logger.debug((Object)"identifications cleared");
            } else {
                _logger.debug((Object)"identification could not be cleared");
            }
        }
    }

    public void fitSelectedObjects() {
        if (this._context.getSelectedObjects() != null && this._display != null && this._display.getView() != null) {
            TdkJavaProcessingService tdkJavaProcessingService = new TdkJavaProcessingService();
            try {
                Envelope envelope = tdkJavaProcessingService.getObjectsBoundingBox(this._context.getSelectedObjects());
                if (!envelope.isNull()) {
                    envelope = TdkMapUtil.addBorderToBox(envelope, this._display);
                }
                this._display.zoomArea(envelope);
                _logger.debug((Object)"fit selected objects performed");
            }
            catch (TdkException tdkException) {
                _logger.error((Object)"FitSelectedObjects()", (Throwable)tdkException);
            }
        } else {
            _logger.debug((Object)"could not fit selected objects");
        }
    }

    public void fitTheme(TdkThemeGID tdkThemeGID) {
        if (this._display != null && tdkThemeGID != null && this._view != null) {
            TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
            TdkLayerGID tdkLayerGID = new TdkLayerGID(this._view.getDBKey(), tdkTheme.getLayerId());
            TdkLayer tdkLayer = TdkSetup.getPersistenceService().getLayer(tdkLayerGID);
            if (tdkLayer == null) {
                return;
            }
            TdkView tdkView = TdkSetup.getPersistenceService().getView(this._view);
            if (tdkView != null) {
                TeProjection teProjection = tdkLayer.getProjection();
                TeProjection teProjection2 = tdkView.getProjection();
                Envelope envelope = tdkTheme.getBoundingBox();
                if (!envelope.isNull()) {
                    TdkJavaProcessingService tdkJavaProcessingService = new TdkJavaProcessingService();
                    Envelope envelope2 = tdkJavaProcessingService.convertBox(envelope, teProjection, teProjection2);
                    envelope2 = TdkMapUtil.addBorderToBox(envelope2, this._display);
                    this._display.zoomArea(envelope2);
                    this._display.redraw();
                }
            }
            _logger.debug((Object)"fit theme performed");
        }
    }

    public void fitThemeGroup(TdkThemeGroupGID tdkThemeGroupGID) {
        if (this._display != null && tdkThemeGroupGID != null && this._view != null) {
            TeProjection teProjection;
            Envelope envelope;
            TdkThemeGroup tdkThemeGroup = TdkSetup.getPersistenceService().getThemeGroup(tdkThemeGroupGID);
            TdkView tdkView = TdkSetup.getPersistenceService().getView(this._view);
            if (tdkView != null && !(envelope = tdkThemeGroup.getBoundingBox(teProjection = tdkView.getProjection())).isNull()) {
                envelope = TdkMapUtil.addBorderToBox(envelope, this._display);
                this._display.zoomArea(envelope);
                this._display.redraw();
            }
            _logger.debug((Object)"fit group performed");
        }
    }

    public void setThemeReferenceScale(TdkThemeGID tdkThemeGID) {
        if (tdkThemeGID == null) {
            return;
        }
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
        if (this._display != null) {
            tdkTheme.setReferenceScale(this._display.getScale());
            this._display.redraw();
            _logger.debug((Object)("set theme " + tdkTheme.getName() + " reference scale to" + tdkTheme.getReferenceScale()));
        }
    }

    private class MyViewChangeListener
    implements TdkViewChangeListener {
        protected TdkDefaultApplicationModule _module;

        public MyViewChangeListener(TdkDefaultApplicationModule tdkDefaultApplicationModule2) {
            this._module = tdkDefaultApplicationModule2;
        }

        @Override
        public void addViewNode(boolean bl, Object object, TdkViewGID tdkViewGID, TdkThemeGroupGID tdkThemeGroupGID, TdkViewNodeGID tdkViewNodeGID) {
        }

        @Override
        public void removeViewNode(boolean bl, Object object, TdkViewGID tdkViewGID, TdkThemeGroupGID tdkThemeGroupGID, TdkViewNodeGID tdkViewNodeGID) {
            if (!bl && tdkViewNodeGID instanceof TdkThemeGID) {
                TdkThemeGeographicObjectGIDSet tdkThemeGeographicObjectGIDSet = this._module.getContext().getSelectedObjects().getTdkThemeGeographicObjectGIDSet(tdkViewNodeGID.getId());
                this._module.removeThemeIdentification((TdkThemeGID)tdkViewNodeGID);
                if (tdkThemeGeographicObjectGIDSet != null && this._module.getContext() != null) {
                    this._module.getContext().removeSelectedObjects(tdkThemeGeographicObjectGIDSet);
                }
            }
        }

        @Override
        public void saveView(boolean bl, Object object, TdkViewGID tdkViewGID, TdkUpdateViewEvent tdkUpdateViewEvent) {
        }

        @Override
        public void updateTheme(boolean bl, Object object, TdkThemeGID tdkThemeGID, TdkUpdateThemeEvent tdkUpdateThemeEvent) {
            if (!bl) {
                TdkTheme tdkTheme;
                if (tdkUpdateThemeEvent.visibilityChanged() && !(tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID)).isVisible()) {
                    TdkThemeGeographicObjectGIDSet tdkThemeGeographicObjectGIDSet = this._module.getContext().getSelectedObjects().getTdkThemeGeographicObjectGIDSet(tdkThemeGID.getId());
                    this._module.removeThemeIdentification(tdkThemeGID);
                    if (tdkThemeGeographicObjectGIDSet != null && this._module.getContext() != null) {
                        this._module.getContext().removeSelectedObjects(tdkThemeGeographicObjectGIDSet);
                    }
                }
                if ((tdkUpdateThemeEvent.legendVectorChanged() || tdkUpdateThemeEvent.defaultStyleChanged() || tdkUpdateThemeEvent.selectedStyleChanged()) && TdkStyleVariableSizeChecker.checkThemeHasVariableSizeStyle((TdkTheme)(tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID))) && tdkTheme.getReferenceScale() == 0.0) {
                    this._module.setThemeReferenceScale(tdkThemeGID);
                }
            }
        }

        @Override
        public void updateThemeSet(boolean bl, Object object, Collection<TdkThemeGID> collection, TdkUpdateThemeEvent tdkUpdateThemeEvent) {
            if (!bl && tdkUpdateThemeEvent.visibilityChanged()) {
                for (TdkThemeGID tdkThemeGID : collection) {
                    TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
                    if (tdkTheme.isVisible()) continue;
                    TdkThemeGeographicObjectGIDSet tdkThemeGeographicObjectGIDSet = this._module.getContext().getSelectedObjects().getTdkThemeGeographicObjectGIDSet(tdkThemeGID.getId());
                    this._module.removeThemeIdentification(tdkThemeGID);
                    if (tdkThemeGeographicObjectGIDSet == null || this._module.getContext() == null) continue;
                    this._module.getContext().removeSelectedObjects(tdkThemeGeographicObjectGIDSet);
                }
            }
        }

        @Override
        public void updateView(boolean bl, Object object, TdkViewGID tdkViewGID, TdkUpdateViewEvent tdkUpdateViewEvent) {
        }
    }

    private class MyTreeListener
    extends TdkTreeViewAdapter {
        private MyTreeListener() {
        }

        @Override
        public void legendElementCreated(Object object, TdkLegendElement tdkLegendElement) {
            JPopupMenu jPopupMenu = tdkLegendElement.getPopupMenu();
            if (tdkLegendElement instanceof TdkThemeLegendElement) {
                final TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)tdkLegendElement;
                JMenuItem jMenuItem = new JMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_FIT_THEME"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TdkDefaultApplicationModule.this.fitTheme(tdkThemeLegendElement.getGID());
                    }
                });
                jPopupMenu.add((Component)jMenuItem, 0);
                JMenuItem jMenuItem2 = new JMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_IDENT_THEME"));
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TdkDefaultApplicationModule.this.identifyTheme(tdkThemeLegendElement.getGID());
                    }
                });
                jPopupMenu.add((Component)jMenuItem2, 1);
                JMenuItem jMenuItem3 = new JMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_REM_IDENT_THEME"));
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TdkDefaultApplicationModule.this.removeThemeIdentification(tdkThemeLegendElement.getGID());
                    }
                });
                jPopupMenu.add((Component)jMenuItem3, 2);
                JMenuItem jMenuItem4 = new JMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_REFERENCE_SCALE"));
                jMenuItem4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TdkDefaultApplicationModule.this.setThemeReferenceScale(tdkThemeLegendElement.getGID());
                        Frame frame = TdkDialogUtil.getFrameParent(TdkDefaultApplicationModule.this._treeView);
                        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeLegendElement.getGID());
                        String string = TdkComponentsI18n.getString("DLG_REFERENCE_SCALE_SET_MESSAGE_1") + " <" + tdkTheme.getName() + "> " + TdkComponentsI18n.getString("DLG_REFERENCE_SCALE_SET_MESSAGE_2") + " " + tdkTheme.getReferenceScale();
                        TdkMessagePopUpDialog tdkMessagePopUpDialog = TdkMessagePopUpDialog.makeOkDialog(string, frame);
                        tdkMessagePopUpDialog.setTitle(TdkComponentsI18n.getString("DLG_REFERENCE_SCALE_SET_MESSAGE_TITLE"));
                        TdkDialogUtil.centralize(tdkMessagePopUpDialog, frame);
                        tdkMessagePopUpDialog.setVisible(true);
                    }
                });
                jPopupMenu.add((Component)jMenuItem4, 3);
            } else if (tdkLegendElement instanceof TdkThemeGroupLegendElement) {
                final TdkThemeGroupLegendElement tdkThemeGroupLegendElement = (TdkThemeGroupLegendElement)tdkLegendElement;
                JMenuItem jMenuItem = new JMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_RENAME_THEME_GROUP"));
                jMenuItem.addActionListener(new TdkRenameGroupAction(TdkDefaultApplicationModule.this._treeView, tdkThemeGroupLegendElement.getGID()));
                jPopupMenu.add((Component)jMenuItem, 0);
                JMenuItem jMenuItem5 = new JMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_FIT_THEME_GROUP"));
                jMenuItem5.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TdkDefaultApplicationModule.this.fitThemeGroup(tdkThemeGroupLegendElement.getGID());
                    }
                });
                jPopupMenu.add((Component)jMenuItem5, 1);
            } else if (tdkLegendElement instanceof TdkViewLegendElement) {
                JMenuItem jMenuItem = new JMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_FIT_VIEW"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (TdkDefaultApplicationModule.this.getDisplay() != null) {
                            TdkDefaultApplicationModule.this.getDisplay().fit();
                            TdkDefaultApplicationModule.this.getDisplay().redraw();
                        }
                    }
                });
                jPopupMenu.add((Component)jMenuItem, 0);
            }
        }
    }
}

