/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.defaultmodule.actions;

import java.awt.Frame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkThemeGroup;
import org.tecgraf.jtdk.core.swig.TdkThemeGroupGID;
import org.tecgraf.jtdk.desktop.components.defaultmodule.actions.TdkAbstractAction;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkCreateGroupDialog;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeView;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;

public class TdkRenameGroupAction
extends TdkAbstractAction {
    private static Logger _logger = Logger.getLogger(TdkRenameGroupAction.class);
    private final TdkTreeView _treeView;
    private final TdkThemeGroupGID _groupGID;

    public TdkRenameGroupAction(TdkTreeView tdkTreeView, TdkThemeGroupGID tdkThemeGroupGID) {
        this._groupGID = tdkThemeGroupGID;
        this._treeView = tdkTreeView;
    }

    @Override
    public void execute() {
        if (this._groupGID == null) {
            _logger.warn((Object)"The group GID reference is null. Nothing done.");
            return;
        }
        if (this._treeView == null) {
            _logger.warn((Object)"The TdkTreeView reference is null. Nothing done.");
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            _logger.warn((Object)"Called outside of the EDT thread!");
            return;
        }
        TdkThemeGroup tdkThemeGroup = TdkSetup.getPersistenceService().getThemeGroup(this._groupGID);
        if (tdkThemeGroup == null) {
            _logger.warn((Object)("Failed to load the group with GID = " + this._groupGID.toString()));
            return;
        }
        Frame frame = TdkDialogUtil.getFrameParent(this._treeView);
        TdkCreateGroupDialog tdkCreateGroupDialog = new TdkCreateGroupDialog(frame, TdkCreateGroupDialog.DialogMode.EDITION_DIALOG);
        tdkCreateGroupDialog.setGroupName(tdkThemeGroup.getName());
        TdkDialogUtil.centralize(tdkCreateGroupDialog, frame);
        tdkCreateGroupDialog.setVisible(true);
        String string = tdkCreateGroupDialog.getGroupName();
        if (string == null) {
            return;
        }
        if (string.equals(tdkThemeGroup.getName())) {
            _logger.info((Object)"Name hasn't changed. Nothing done.");
            return;
        }
        tdkThemeGroup.setName(string);
        TdkSetup.getPersistenceService().updateThemeGroup(tdkThemeGroup);
        this._treeView.rebuild();
    }
}

