/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tecgraf.jtdk.core.swig.StringVector;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TeAttrTableVector;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;

public class TdkAttributeChooser
extends JPanel {
    TdkThemeGID _themeGID;
    TeAttrTableVector _attrTableVector;
    private JComboBox _attrTables;
    private JLabel _attrTablesLabel;
    private JLabel _attrsLabel;
    private JComboBox _tableAttrs;
    private JPanel jPanel1;
    private JPanel jPanel3;

    public TdkAttributeChooser() {
        this.initComponents();
        this.setThemeGID(null);
    }

    public TdkAttributeChooser(TdkThemeGID tdkThemeGID) {
        this.initComponents();
        this.setThemeGID(tdkThemeGID);
    }

    public void setThemeGID(TdkThemeGID tdkThemeGID) {
        if (tdkThemeGID != null) {
            this._themeGID = tdkThemeGID;
            this.fillAttrTablesCombo();
            this._attrTables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkAttributeChooser.this.fillAttributesCombo();
                }
            });
        }
    }

    public void setAttributeTable(String string) {
        this._attrTables.setSelectedItem(string);
    }

    public void setAttribute(String string) {
        this._tableAttrs.setSelectedItem(string);
    }

    public void fillAttrTablesCombo() {
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this._themeGID);
        this._attrTableVector = tdkTheme.getAttributeTableVector();
        int n = 0;
        while ((long)n < this._attrTableVector.size()) {
            this._attrTables.addItem(this._attrTableVector.get(n).getName());
            ++n;
        }
        if (this._attrTableVector.size() > 0L) {
            this._attrTables.setSelectedIndex(0);
            this.fillAttributesCombo();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this._attrTables.setEnabled(bl);
        this._attrsLabel.setEnabled(bl);
        this._attrTablesLabel.setEnabled(bl);
        this._tableAttrs.setEnabled(bl);
    }

    public void fillAttributesCombo() {
        this._tableAttrs.removeAllItems();
        int n = this._attrTables.getSelectedIndex();
        if (n >= 0) {
            StringVector stringVector = new StringVector();
            this._attrTableVector.get(n).attributeNames(stringVector);
            long l = stringVector.size();
            int n2 = 0;
            for (n2 = 0; n2 < (int)l; ++n2) {
                this._tableAttrs.insertItemAt(stringVector.get(n2), n2);
            }
            if (this._tableAttrs.getItemCount() > 0) {
                this._tableAttrs.setSelectedIndex(0);
            }
        }
    }

    public String getAttrTable() {
        int n = this._attrTables.getSelectedIndex();
        if (n >= 0) {
            return this._attrTableVector.get(n).getName();
        }
        return null;
    }

    public String getAttribute() {
        int n = this._tableAttrs.getSelectedIndex();
        if (n >= 0) {
            return (String)this._tableAttrs.getSelectedItem();
        }
        return null;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.jPanel3 = new JPanel();
        this._attrTablesLabel = new JLabel();
        this._attrTables = new JComboBox();
        this.jPanel1 = new JPanel();
        this._attrsLabel = new JLabel();
        this._tableAttrs = new JComboBox();
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setMinimumSize(null);
        this.jPanel3.setPreferredSize(new Dimension(200, 46));
        this._attrTablesLabel.setText(TdkComponentsI18n.getString("ATTRIBUTE_CHOOSER_TABLES_COMBO_LABEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanel3.add((Component)this._attrTablesLabel, gridBagConstraints);
        this._attrTables.setPreferredSize(new Dimension(150, 22));
        this._attrTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TdkAttributeChooser.this._attrTablesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel3.add((Component)this._attrTables, gridBagConstraints);
        this.add(this.jPanel3);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(null);
        this.jPanel1.setPreferredSize(new Dimension(200, 46));
        this._attrsLabel.setText(TdkComponentsI18n.getString("ATTRIBUTE_CHOOSER_ATTR_COMBO_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanel1.add((Component)this._attrsLabel, gridBagConstraints);
        this._tableAttrs.setPreferredSize(new Dimension(150, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanel1.add((Component)this._tableAttrs, gridBagConstraints);
        this.add(this.jPanel1);
    }

    private void _attrTablesActionPerformed(ActionEvent actionEvent) {
    }
}

