/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkCreateGroupPanel;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkCreateGroupPanelController;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkDialog;

public class TdkCreateGroupDialog
extends TdkDialog
implements ActionListener {
    private static Logger _logger = Logger.getLogger(TdkCreateGroupDialog.class);
    private TdkCreateGroupPanel _panel = new TdkCreateGroupPanel();
    private TdkCreateGroupPanelController _panelController = new TdkCreateGroupPanelController(this._panel);
    private boolean _okPressed = false;
    private final DialogMode _mode;

    public TdkCreateGroupDialog(Frame frame) {
        super(frame);
        this._mode = DialogMode.CREATION_DIALOG;
        this.initComponents();
    }

    public TdkCreateGroupDialog(Frame frame, DialogMode dialogMode) {
        super(frame);
        this._mode = dialogMode;
        this.initComponents();
    }

    private void initComponents() {
        this.addButton(TdkComponentsI18n.getString("DLG_BTN_OK"), "ok_command");
        this.addButton(TdkComponentsI18n.getString("DLG_BTN_CANCEL"), "cancel_command");
        super.initComponents(this._panel);
        this.setDefaultCloseOperation(2);
        if (this._mode == DialogMode.CREATION_DIALOG) {
            this.setTitle(TdkComponentsI18n.getString("DLG_CREATE_GROUP_TITLE"));
        } else if (this._mode == DialogMode.EDITION_DIALOG) {
            this.setTitle(TdkComponentsI18n.getString("DLG_EDIT_GROUP_TITLE"));
        } else assert (false);
    }

    private boolean isValidGroupName(String string) {
        if (string == null) {
            return false;
        }
        return !string.equals("") && !string.contains("'") && !string.contains(";");
    }

    public void cancelButtonActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: CANCEL ");
    }

    public void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.isValidGroupName(this._panelController.getGroupName())) {
            this._okPressed = true;
            _logger.debug((Object)"Action performed: OK");
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, TdkComponentsI18n.getString("DLG_GROUP_INVALID_NAME_MESSAGE"));
        }
    }

    public void setGroupName(String string) {
        this._panelController.setGroupName(string);
    }

    public String getGroupName() {
        if (this._okPressed) {
            return this._panelController.getGroupName();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok_command")) {
            this.okButtonActionPerformed(actionEvent);
        } else if (string.equals("cancel_command")) {
            this.cancelButtonActionPerformed(actionEvent);
            super.actionPerformed(actionEvent);
        } else {
            System.out.println("Unknown action performed: " + string);
        }
    }

    public static enum DialogMode {
        CREATION_DIALOG,
        EDITION_DIALOG;

    }
}

