/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.tecgraf.jtdk.core.swig.TdkLayerGIDVector;
import org.tecgraf.jtdk.core.swig.TdkViewGIDVector;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;

public class TdkCreateThemePanel
extends JPanel {
    private static Logger _logger = Logger.getLogger(TdkCreateThemePanel.class);
    private JButton _editButton;
    private JComboBox _layerComboBox;
    private JLabel _layerLabel;
    private JLabel _sqlLabel;
    private JTextArea _sqlTextArea;
    private JLabel _themeNameLabel;
    private JTextField _themeNameTextField;
    private JComboBox _viewComboBox;
    private JLabel _viewLabel;
    private JScrollPane jScrollPane1;

    public TdkCreateThemePanel() {
        this.initComponents();
        this._themeNameLabel.setText(TdkComponentsI18n.getString("PNL_CREATE_THEME_THEME_NAME_LABEL"));
        this._viewLabel.setText(TdkComponentsI18n.getString("PNL_CREATE_THEME_VIEW_LABEL"));
        this._layerLabel.setText(TdkComponentsI18n.getString("PNL_CREATE_THEME_LAYER_LABEL"));
        this._sqlLabel.setText(TdkComponentsI18n.getString("PNL_CREATE_THEME_SQL_LABEL"));
        this._editButton.setText(TdkComponentsI18n.getString("PNL_CREATE_THEME_BTN_EDIT"));
        this._editButton.setActionCommand("edit_command");
        this._viewComboBox.removeAllItems();
        this._layerComboBox.removeAllItems();
    }

    public void registerActionListener(ActionListener actionListener) {
        _logger.debug((Object)("Registering edit button's action listener: " + actionListener.toString()));
        this._editButton.addActionListener(actionListener);
    }

    public void insertView(String string) {
        _logger.debug((Object)("Inserting view: " + string));
        this._viewComboBox.addItem(string);
    }

    public void insertViewList(TdkViewGIDVector tdkViewGIDVector) {
        _logger.debug((Object)("Inserting views: " + tdkViewGIDVector.toString()));
        int n = 0;
        while ((long)n < tdkViewGIDVector.size()) {
            this._viewComboBox.addItem(tdkViewGIDVector.get(n).getIdStr());
            ++n;
        }
    }

    public void insertLayer(String string) {
        _logger.debug((Object)("Inserting layer: " + string));
        this._layerComboBox.addItem(string);
    }

    public void insertLayerList(TdkLayerGIDVector tdkLayerGIDVector) {
        _logger.debug((Object)("Inserting layers: " + tdkLayerGIDVector.toString()));
        int n = 0;
        while ((long)n < tdkLayerGIDVector.size()) {
            this._layerComboBox.addItem(tdkLayerGIDVector.get(n).getIdStr());
            ++n;
        }
    }

    public String getSelectedView() {
        _logger.debug((Object)"Getting selected view.");
        return this._viewComboBox.getSelectedItem().toString();
    }

    public String getSelectedLayer() {
        _logger.debug((Object)"Getting selected layer.");
        return this._layerComboBox.getSelectedItem().toString();
    }

    public String getSqlRestriction() {
        String string = null;
        try {
            _logger.debug((Object)"Getting sql restriction text.");
            string = this._sqlTextArea.getText();
        }
        catch (NullPointerException nullPointerException) {
            _logger.debug((Object)"NullPointeException when getting sql restriction text.");
        }
        return string;
    }

    public String getThemeName() {
        String string = null;
        try {
            _logger.debug((Object)"Getting theme's name.");
            string = this._themeNameTextField.getText();
        }
        catch (NullPointerException nullPointerException) {
            _logger.debug((Object)"NullPointeException when getting theme's name.");
        }
        return string;
    }

    private void initComponents() {
        this._themeNameLabel = new JLabel();
        this._themeNameTextField = new JTextField();
        this._viewLabel = new JLabel();
        this._layerLabel = new JLabel();
        this._viewComboBox = new JComboBox();
        this._layerComboBox = new JComboBox();
        this._sqlLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this._sqlTextArea = new JTextArea();
        this._editButton = new JButton();
        this._themeNameLabel.setText("Nome do Tema:");
        this._themeNameTextField.setText(" ");
        this._viewLabel.setText("View:");
        this._layerLabel.setText("Layer:");
        this._viewComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._layerComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._sqlLabel.setText("Restri\u00e7\u00e3o SQL:");
        this._sqlTextArea.setColumns(20);
        this._sqlTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this._sqlTextArea);
        this._editButton.setText("Editar Restri\u00e7\u00e3o");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this._themeNameTextField, -1, 257, Short.MAX_VALUE).add((Component)this._themeNameLabel).add((Component)this._viewLabel).add((Component)this._viewComboBox, 0, 257, Short.MAX_VALUE).add((Component)this._layerLabel).add((Component)this._layerComboBox, 0, 257, Short.MAX_VALUE).add((Component)this._sqlLabel).add((Component)this._editButton, -1, 257, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 257, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this._themeNameLabel).addPreferredGap(0).add((Component)this._themeNameTextField, -2, -1, -2).addPreferredGap(0).add((Component)this._viewLabel).addPreferredGap(0).add((Component)this._viewComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this._layerLabel).addPreferredGap(0).add((Component)this._layerComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this._sqlLabel).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 122, -2).addPreferredGap(0).add((Component)this._editButton).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

