/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkCreateThemeParams;
import org.tecgraf.jtdk.core.swig.TdkAbstractPersistenceService;
import org.tecgraf.jtdk.core.swig.TdkLayerGID;
import org.tecgraf.jtdk.core.swig.TdkLayerGIDVector;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkView;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TdkViewGIDVector;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkCreateThemePanel;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkEditSqlRestrictionDialog;

public class TdkCreateThemePanelController
implements ActionListener {
    private static Logger _logger = Logger.getLogger(TdkCreateThemePanelController.class);
    public static final String ACT_CMD_OK = "ok_command";
    public static final String ACT_CMD_CANCEL = "cancel_command";
    public static final String ACT_CMD_EDIT = "edit_command";
    private TdkCreateThemePanel _panel;
    private String _dbKey;
    private TdkCreateThemeParams _params;
    private Hashtable<String, TdkViewGID> _viewsMap;
    private Hashtable<String, TdkLayerGID> _layersMap;

    public TdkCreateThemePanelController(TdkCreateThemePanel tdkCreateThemePanel, String string) {
        String string2;
        TdkView tdkView;
        _logger.debug((Object)"Creating controller");
        this._panel = tdkCreateThemePanel;
        this._dbKey = string;
        this._params = new TdkCreateThemeParams();
        this._viewsMap = new Hashtable();
        this._layersMap = new Hashtable();
        TdkAbstractPersistenceService tdkAbstractPersistenceService = TdkSetup.getPersistenceService();
        TdkViewGIDVector tdkViewGIDVector = tdkAbstractPersistenceService.getViews(this._dbKey);
        int n = 0;
        while ((long)n < tdkViewGIDVector.size()) {
            TdkViewGID tdkViewGID = tdkViewGIDVector.get(n);
            tdkView = tdkAbstractPersistenceService.getView(tdkViewGID);
            string2 = tdkView.getName();
            this._viewsMap.put(string2, tdkViewGID);
            this._panel.insertView(string2);
            ++n;
        }
        TdkLayerGIDVector tdkLayerGIDVector = tdkAbstractPersistenceService.getLayers(string);
        int n2 = 0;
        while ((long)n2 < tdkLayerGIDVector.size()) {
            tdkView = tdkLayerGIDVector.get(n2);
            string2 = tdkAbstractPersistenceService.getLayer((TdkLayerGID)tdkView);
            String string3 = string2.getName();
            this._layersMap.put(string3, (TdkLayerGID)tdkView);
            this._panel.insertLayer(string3);
            ++n2;
        }
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: EDIT");
        new TdkEditSqlRestrictionDialog(new JFrame()).setVisible(true);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: CANCEL ");
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: OK");
        if (this._panel.getThemeName() == null) {
            _logger.error((Object)"Theme's name is null.");
            return;
        }
        this._params.setName(this._panel.getThemeName());
        this._params.setViewGID(this._viewsMap.get(this._panel.getSelectedView()));
        this._params.setLayerGID(this._layersMap.get(this._panel.getSelectedLayer()));
        this._params.setSqlRestriction(this._panel.getSqlRestriction());
        _logger.fatal((Object)"Work flow not implemented!");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACT_CMD_OK)) {
            this.okButtonActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_CANCEL)) {
            this.cancelButtonActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_EDIT)) {
            this.editButtonActionPerformed(actionEvent);
        } else {
            _logger.error((Object)("Unknown action performed: " + string));
        }
    }

    public TdkCreateThemeParams getResult() {
        return this._params;
    }
}

