/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TeDatumFactory;
import org.tecgraf.jtdk.core.swig.TeHemisphere;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.core.swig.TeProjectionFactory;
import org.tecgraf.jtdk.core.swig.TeProjectionParams;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkEditProjectionPanel;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkEditProjectionPanelController;

public class TdkEditProjectionDialog
extends TdkDialog
implements ActionListener {
    private static Logger _logger = Logger.getLogger(TdkEditProjectionDialog.class);
    private TdkEditProjectionPanel _panel = new TdkEditProjectionPanel();
    private TdkEditProjectionPanelController _panelController;

    public TdkEditProjectionDialog(Frame frame) {
        super(frame);
        this._panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._panelController = new TdkEditProjectionPanelController(this._panel);
        _logger.info((Object)"Creating dialog");
        this.initComponents();
    }

    private void initComponents() {
        this.addButton(TdkComponentsI18n.getString("DLG_BTN_OK"), "ok_command");
        this.addButton(TdkComponentsI18n.getString("DLG_BTN_CANCEL"), "cancel_command");
        super.initComponents(this._panel);
        this.setDefaultCloseOperation(2);
        this.setTitle(TdkComponentsI18n.getString("DLG_EDIT_PROJECTION_TITLE"));
    }

    public TeProjection editProjection(TeProjection teProjection) {
        Object object;
        _logger.debug((Object)"call for editProjection.");
        if (teProjection == null) {
            _logger.debug((Object)"projection is null. Generating dafault.");
            object = new TeProjectionParams();
            object.setName("LatLong");
            object.setDatum(TeDatumFactory.make((String)"SAD69"));
            object.setLat0(0.0);
            object.setLon0(0.0);
            object.setOffx(0.0);
            object.setOffy(0.0);
            object.setStlat1(0.0);
            object.setStlat2(0.0);
            object.setHemisphere(TeHemisphere.TeSOUTH_HEM);
            object.setUnits("DecimalDegrees");
            object.setScale(1.0);
            teProjection = TeProjectionFactory.make((TeProjectionParams)object);
        }
        this._panelController.setProjection(teProjection);
        this._panelController.initPanel();
        object = this.getToolkit().getScreenSize();
        this.setLocation(object.width / 2 - this.getWidth() / 2, object.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
        TeProjectionParams teProjectionParams = this._panelController.getResultParams();
        if (teProjectionParams == null) {
            return null;
        }
        teProjectionParams.setLat0(teProjectionParams.getLat0() * (Math.PI / 180));
        teProjectionParams.setLon0(teProjectionParams.getLon0() * (Math.PI / 180));
        teProjectionParams.setStlat1(teProjectionParams.getStlat1() * (Math.PI / 180));
        teProjectionParams.setStlat2(teProjectionParams.getStlat2() * (Math.PI / 180));
        return TeProjectionFactory.make((TeProjectionParams)teProjectionParams);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok_command")) {
            this._panelController.actionPerformed(actionEvent);
            _logger.info((Object)"Call for dispose by OK button.");
            super.actionPerformed(actionEvent);
        } else if (string.equals("cancel_command")) {
            this._panelController.actionPerformed(actionEvent);
            _logger.info((Object)"Call for dispose by CANCEL button.");
            super.actionPerformed(actionEvent);
        } else {
            _logger.error((Object)("Unknown action performed: " + string));
        }
    }

    public TeProjectionParams getResultParams() {
        _logger.info((Object)"Get result params.");
        return this._panelController.getResultParams();
    }
}

