/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TeDatum;
import org.tecgraf.jtdk.core.swig.TeDatumFactory;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.core.swig.TeProjectionParams;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkEditProjectionPanel;
import org.tecgraf.jtdk.desktop.components.util.TdkPropertyDef;

public class TdkEditProjectionPanelController
implements ActionListener {
    private static Logger _logger = Logger.getLogger(TdkEditProjectionPanelController.class);
    protected final String[] PROJECTION = new String[]{"ALBERS", "LATLONG", "LAMBERTCONFORMAL", "MERCATOR", "MILLER", "UTM", "POLYCONIC", "SINUSOIDAL", "NOPROJECTION"};
    protected final String[] DATUM = new String[]{"ASTRO_CHUA", "CORREGO_ALEGRE", "INDIAN", "NAD27", "NAD83", "SAD69", "SPHERICAL", "WGS84"};
    public static final String ACT_CMD_OK = "ok_command";
    public static final String ACT_CMD_CANCEL = "cancel_command";
    public static final String ACT_CMD_PROJECTION = "projection_command";
    private TdkEditProjectionPanel _panel;
    private TeProjectionParams _projParams;
    private Boolean _result = false;
    protected Vector<TdkPropertyDef> _projectionAlbersProperties;
    protected Vector<TdkPropertyDef> _projectionLatLongProperties;
    protected Vector<TdkPropertyDef> _projectionLambertConformalProperties;
    protected Vector<TdkPropertyDef> _projectionMercatorProperties;
    protected Vector<TdkPropertyDef> _projectionMillerProperties;
    protected Vector<TdkPropertyDef> _projectionUTMProperties;
    protected Vector<TdkPropertyDef> _projectionPolyconicProperties;
    protected Vector<TdkPropertyDef> _projectionSinusoidalProperties;
    protected Vector<TdkPropertyDef> _projectionNoProjectionProperties;
    protected Vector<TdkPropertyDef> _currentPropertiesModel;

    public TdkEditProjectionPanelController(TdkEditProjectionPanel tdkEditProjectionPanel) {
        this._panel = tdkEditProjectionPanel;
        this._projectionAlbersProperties = new Vector();
        this._projectionLambertConformalProperties = new Vector();
        this._projectionMercatorProperties = new Vector();
        this._projectionMillerProperties = new Vector();
        this._projectionLatLongProperties = new Vector();
        this._projectionUTMProperties = new Vector();
        this._projectionPolyconicProperties = new Vector();
        this._projectionSinusoidalProperties = new Vector();
        this._currentPropertiesModel = new Vector();
        this._projectionNoProjectionProperties = new Vector();
        this.buildPropertiesVectors();
    }

    public void initPanel() {
        int n;
        if (this._panel == null) {
            return;
        }
        JComboBox jComboBox = this._panel.getProjectionCombo();
        JComboBox jComboBox2 = this._panel.getDatumCombo();
        if (jComboBox != null && jComboBox2 != null) {
            for (n = 0; n < this.PROJECTION.length; ++n) {
                jComboBox.addItem(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_" + this.PROJECTION[n]));
            }
            for (n = 0; n < this.DATUM.length; ++n) {
                jComboBox2.addItem(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_" + this.DATUM[n]));
            }
        }
        if (this._projParams != null) {
            if (this._projParams.getName() != null && this._projParams.getName().length() > 0) {
                this._panel.setSelectedProj(this._projParams.getName());
                n = 0;
                int n2 = -1;
                for (String string : this.PROJECTION) {
                    if (string.equalsIgnoreCase(this._projParams.getName())) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
                this.setCurrentProjection(n2);
            }
            if (this._projParams.getDatum().getName() != null && this._projParams.getDatum().getName().length() > 0) {
                String string = this._projParams.getDatum().getName();
                this._panel.setSelectedDatum(string);
            }
        }
        if (jComboBox != null) {
            jComboBox.addActionListener(this);
        }
        this._panel.getPropertiesTable().setModel(this._currentPropertiesModel);
        this._panel.getPropertiesTable().setObject(this._projParams);
    }

    protected void buildPropertiesVectors() {
        this._projectionAlbersProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LONG"), "Lon0", 2));
        this._projectionAlbersProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LAT"), "Lat0", 2));
        this._projectionAlbersProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_DEFAULT_PARAREL"), "Stlat1", 2));
        this._projectionAlbersProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_DEFAULT_PARAREL"), "Stlat2", 2));
        this._projectionAlbersProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_X"), "Offx", 2));
        this._projectionAlbersProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_Y"), "Offy", 2));
        this._projectionLambertConformalProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LONG"), "Lon0", 2));
        this._projectionLambertConformalProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LAT"), "Lat0", 2));
        this._projectionLambertConformalProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_DEFAULT_PARAREL"), "Stlat1", 2));
        this._projectionLambertConformalProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_DEFAULT_PARAREL"), "Stlat2", 2));
        this._projectionLambertConformalProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_X"), "Offx", 2));
        this._projectionLambertConformalProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_Y"), "Offy", 2));
        this._projectionMercatorProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LONG"), "Lon0", 2));
        this._projectionMercatorProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LAT"), "Lat0", 2));
        this._projectionMercatorProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_DEFAULT_PARAREL"), "Stlat1", 2));
        this._projectionMercatorProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_X"), "Offx", 2));
        this._projectionMercatorProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_Y"), "Offy", 2));
        this._projectionMillerProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LONG"), "Lon0", 2));
        this._projectionMillerProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_X"), "Offx", 2));
        this._projectionMillerProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_Y"), "Offy", 2));
        this._projectionUTMProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LONG"), "Lon0", 2));
        this._projectionUTMProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LAT"), "Lat0", 2));
        this._projectionUTMProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_X"), "Offx", 2));
        this._projectionUTMProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_Y"), "Offy", 2));
        this._projectionUTMProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_SCALE"), "Scale", 2));
        this._projectionPolyconicProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LONG"), "Lon0", 2));
        this._projectionPolyconicProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LAT"), "Lat0", 2));
        this._projectionPolyconicProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_X"), "Offx", 2));
        this._projectionPolyconicProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_Y"), "Offy", 2));
        this._projectionSinusoidalProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_LONG"), "Lon0", 2));
        this._projectionSinusoidalProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_X"), "Offx", 2));
        this._projectionSinusoidalProperties.add(new TdkPropertyDef(TdkComponentsI18n.getString("PNL_EDIT_PROJECTION_OFFSET_Y"), "Offy", 2));
    }

    public void setProjectionParams(TeProjectionParams teProjectionParams) {
        this._projParams = teProjectionParams;
    }

    public void setProjection(TeProjection teProjection) {
        if (teProjection == null) {
            throw new IllegalArgumentException("Projection can't be null");
        }
        TeProjectionParams teProjectionParams = teProjection.getParams();
        teProjectionParams.setLon0(teProjectionParams.getLon0() * 57.29577951308232);
        teProjectionParams.setLat0(teProjectionParams.getLat0() * 57.29577951308232);
        teProjectionParams.setStlat1(teProjectionParams.getStlat1() * 57.29577951308232);
        teProjectionParams.setStlat2(teProjectionParams.getStlat2() * 57.29577951308232);
        this.setProjectionParams(teProjectionParams);
    }

    public TeProjectionParams getResultParams() {
        _logger.debug((Object)("Get projection params: " + this._projParams));
        if (this._result.booleanValue()) {
            return this._projParams;
        }
        return null;
    }

    public void setCurrentProjection(int n) {
        if (this.PROJECTION[n].equals("ALBERS")) {
            this._currentPropertiesModel = this._projectionAlbersProperties;
        } else if (this.PROJECTION[n].equals("LATLONG")) {
            this._currentPropertiesModel = this._projectionLatLongProperties;
        } else if (this.PROJECTION[n].equals("LAMBERTCONFORMAL")) {
            this._currentPropertiesModel = this._projectionLambertConformalProperties;
        } else if (this.PROJECTION[n].equals("MERCATOR")) {
            this._currentPropertiesModel = this._projectionMercatorProperties;
        } else if (this.PROJECTION[n].equals("MILLER")) {
            this._currentPropertiesModel = this._projectionMillerProperties;
        } else if (this.PROJECTION[n].equals("UTM")) {
            this._currentPropertiesModel = this._projectionUTMProperties;
        } else if (this.PROJECTION[n].equals("POLYCONIC")) {
            this._currentPropertiesModel = this._projectionPolyconicProperties;
        } else if (this.PROJECTION[n].equals("SINUSOIDAL")) {
            this._currentPropertiesModel = this._projectionSinusoidalProperties;
        } else if (this.PROJECTION[n].equals("NOPROJECTION")) {
            this._currentPropertiesModel = this._projectionNoProjectionProperties;
        }
    }

    private void projectionComboActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: COMBO ");
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        int n = jComboBox.getSelectedIndex();
        this.setCurrentProjection(n);
        this._panel.getPropertiesTable().setModel(this._currentPropertiesModel);
        this._panel.getPropertiesTable().setObject(this._projParams);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: OK");
        String string = (String)this._panel.getDatumCombo().getSelectedItem();
        TeDatum teDatum = TeDatumFactory.make((String)string);
        this._projParams.setDatum(teDatum);
        String string2 = (String)this._panel.getProjectionCombo().getSelectedItem();
        this._projParams.setName(string2);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: CANCEL ");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACT_CMD_PROJECTION)) {
            this.projectionComboActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_OK)) {
            this.okButtonActionPerformed(actionEvent);
            this._result = true;
        } else if (string.equals(ACT_CMD_CANCEL)) {
            this.cancelButtonActionPerformed(actionEvent);
            this._result = false;
        } else {
            _logger.error((Object)("Unknown action performed: " + string));
        }
    }
}

