/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class TdkFileChooserFilter
extends FileFilter {
    private static Logger _logger = Logger.getLogger(TdkFileChooserFilter.class);
    private Hashtable _filters = new Hashtable();
    private String _description = null;
    private String _fullDescription = null;
    private boolean _useExtensionsInDescription = true;

    public TdkFileChooserFilter() {
    }

    public TdkFileChooserFilter(String string) {
        this(string, null);
    }

    public TdkFileChooserFilter(String string, String string2) {
        this();
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public TdkFileChooserFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public TdkFileChooserFilter(String[] stringArray, String string) {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExtension(stringArray[i]);
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this._filters.get(this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        if (this._filters == null) {
            this._filters = new Hashtable(5);
        }
        this._filters.put(string.toLowerCase(), this);
        this._fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this._fullDescription == null) {
            if (this._description == null || this.isExtensionListInDescription()) {
                this._fullDescription = this._description == null ? "(" : this._description + " (";
                Enumeration enumeration = this._filters.keys();
                if (enumeration != null) {
                    this._fullDescription = this._fullDescription + "." + (String)enumeration.nextElement();
                    while (enumeration.hasMoreElements()) {
                        this._fullDescription = this._fullDescription + ", ." + (String)enumeration.nextElement();
                    }
                }
                this._fullDescription = this._fullDescription + ")";
            } else {
                this._fullDescription = this._description;
            }
        }
        return this._fullDescription;
    }

    public void setDescription(String string) {
        this._description = string;
        this._fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this._useExtensionsInDescription = bl;
        this._fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this._useExtensionsInDescription;
    }
}

