/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkActionWorkflowService;
import org.tecgraf.jtdk.core.TdkImportShapeParams;
import org.tecgraf.jtdk.core.TdkJVipeSetup;
import org.tecgraf.jtdk.core.exceptions.TdkActionWorkflowServiceNotInitializedException;
import org.tecgraf.jtdk.core.swig.TdkConDescriptor;
import org.tecgraf.jtdk.core.swig.TdkLayer;
import org.tecgraf.jtdk.core.swig.TdkLayerGID;
import org.tecgraf.jtdk.core.swig.TdkLayerGIDVector;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkFileChooserFilter;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkImportSHPPanel;

public class TdkImportSHPPanelController
implements ActionListener,
FocusListener {
    private static Logger _logger = Logger.getLogger(TdkImportSHPPanelController.class);
    public static final String ACT_CMD_OK = "ok_command";
    public static final String ACT_CMD_CANCEL = "cancel_command";
    public static final String ACT_CMD_SEARCH = "search_command";
    public static final String ACT_CMD_PROJECTION = "proj_command";
    public static final String ACT_CMD_NEW_LAYER = "new_layer_command";
    public static final String ACT_CMD_EXIST_LAYER = "exist_layer_command";
    public static final String ACT_CMD_PATH_TEXT = "path_text_command";
    public static final String ACT_CMD_NEW_LAYER_NAME = "new_layer_name_command";
    public static final String ACT_CMD_SELECT_LAYER = "select_layer_command";
    public static final String ACT_CMD_AUTO_LINK = "auto_link_command";
    public static final String ACT_CMD_SEL_LINK = "sel_link_command";
    public static final String ACT_CMD_SEL_LINK_ATTR = "sel_link_attr_command";
    protected TdkImportSHPPanel _panel;
    protected TdkLayerGIDVector _layers;
    protected TdkImportShapeParams _params;
    protected JFileChooser _fileChooser;
    protected Color _warningColor = Color.RED;
    protected Color _okColor = Color.BLACK;
    protected JButton _validateButton = null;
    protected TdkConDescriptor _desc;
    private Boolean _result = false;

    public TdkImportSHPPanelController(TdkImportSHPPanel tdkImportSHPPanel, TdkConDescriptor tdkConDescriptor) {
        _logger.debug((Object)"Creating controller.");
        this._panel = tdkImportSHPPanel;
        this._desc = tdkConDescriptor;
        if (this._desc != null) {
            String string = this._desc.getDbKey();
            this._layers = TdkSetup.getPersistenceService().getLayers(string);
        }
        this._params = new TdkImportShapeParams();
        this._fileChooser = new JFileChooser();
        this.comboInsertLayers();
        this.fieldValidation();
    }

    protected void cancelButtonActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: CANCEL");
        this._result = false;
    }

    protected void okButtonActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: OK");
        this._result = true;
    }

    private void pathTextFieldActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: PATH_TEXT_FIELD");
        this._params.setShapefileLocation(this._panel._pathTextField.getText());
        this._panel.getDbfAttributesCombo().setShapefile(this._params.getShapefileLocation());
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        _logger.debug((Object)"Action performed: SEARCH");
        TdkFileChooserFilter tdkFileChooserFilter = new TdkFileChooserFilter("shp");
        tdkFileChooserFilter.setDescription("Shape Files");
        this._fileChooser.addChoosableFileFilter(tdkFileChooserFilter);
        int n = this._fileChooser.showDialog(this._panel, "Open");
        if (n == 0 && (file = this._fileChooser.getSelectedFile()) != null) {
            this._panel.setPathTextField(file.getAbsolutePath());
            this._params.setShapefileLocation(file.getAbsolutePath());
            this._panel.getDbfAttributesCombo().setShapefile(this._params.getShapefileLocation());
        }
    }

    public void autoLinkRadioActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: AUTO_LINK_RADIO");
        if (this._panel.getAutomaticLinkingRadio().isSelected()) {
            this._panel.getLinkingAttributeLabel().setEnabled(false);
            this._panel.getDbfAttributesCombo().setEnabled(false);
        }
    }

    public void selLinkAttrActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: SEL_LINK_ATTR");
        if (this._panel.getSelAttributeLinkingRadio().isSelected()) {
            this._panel.getLinkingAttributeLabel().setEnabled(true);
            this._panel.getDbfAttributesCombo().setEnabled(true);
        }
    }

    public void selectDBFAttrActionPerformed(ActionEvent actionEvent) {
        if (this._panel.getDbfAttributesCombo().getSelectedAttribute() != null) {
            this._params.setLinkingAttribute(this._panel.getDbfAttributesCombo().getSelectedAttribute());
        }
    }

    public void selectLayerActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: SELECT_LAYER");
        if (actionEvent.getSource() == this._panel.getAllLayersComboBox()) {
            int n = this._panel.getAllLayersComboBox().getSelectedIndex();
            if (n > 1) {
                this._params.setExistingLayerGID(this._layers.get(n - 1));
                this._params.setLayerName((String)this._panel.getAllLayersComboBox().getItemAt(n));
            } else {
                this._params.setExistingLayerGID(null);
                this._params.setLayerName("");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        boolean bl = actionEvent.getSource() instanceof JTextField;
        if (string.equals(ACT_CMD_OK) && !bl) {
            this.okButtonActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_CANCEL) && !bl) {
            this.cancelButtonActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_SEARCH) && !bl) {
            this.searchButtonActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_NEW_LAYER) && !bl) {
            this._panel.setNewLayerEnabled(this._panel.getNewLayerRadioButton().isSelected());
            this._panel.setExistLayerEnabled(!this._panel.getNewLayerRadioButton().isSelected());
        } else if (string.equals(ACT_CMD_EXIST_LAYER) && !bl) {
            this._panel.setExistLayerEnabled(this._panel.getExistingLayerRadio().isSelected());
            this._panel.setNewLayerEnabled(!this._panel.getExistingLayerRadio().isSelected());
        } else if (string.equals(ACT_CMD_PATH_TEXT) && bl) {
            this.pathTextFieldActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_NEW_LAYER_NAME) && bl) {
            this.newLayerNameActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_SELECT_LAYER) && !bl) {
            this.selectLayerActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_PROJECTION) && !bl) {
            this.projectionActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_AUTO_LINK) && !bl) {
            this.autoLinkRadioActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_SEL_LINK) && !bl) {
            this.selLinkAttrActionPerformed(actionEvent);
        } else if (string.equals(ACT_CMD_SEL_LINK_ATTR) && !bl) {
            this.selectDBFAttrActionPerformed(actionEvent);
        } else {
            _logger.error((Object)("Unknown action performed: " + string));
        }
        this.fieldValidation();
    }

    protected void fieldValidation() {
        boolean bl = true;
        if (this._panel.getPathTextField().getText().equals("")) {
            bl = false;
            this._panel.getPathLabel().setForeground(this._warningColor);
        } else {
            this._panel.getPathLabel().setForeground(this._okColor);
        }
        if (this._panel.getProjectionTextField().getText().equals("")) {
            bl = false;
            this._panel.getProjectionLabel().setForeground(this._warningColor);
        } else {
            this._panel.getProjectionLabel().setForeground(this._okColor);
        }
        if (!this._panel.getNewLayerRadioButton().isSelected() && !this._panel.getExistingLayerRadio().isSelected()) {
            bl = false;
            this._panel.getNewLayerRadioButton().setForeground(this._warningColor);
            this._panel.getExistingLayerRadio().setForeground(this._warningColor);
        } else {
            this._panel.getNewLayerRadioButton().setForeground(this._okColor);
            this._panel.getExistingLayerRadio().setForeground(this._okColor);
        }
        if (this._panel.getNewLayerRadioButton().isSelected() && this._panel.getNameLayerTextField().getText().equals("")) {
            bl = false;
            this._panel.getNameLayerLabel().setForeground(this._warningColor);
        } else {
            boolean bl2 = false;
            String string = this._panel.getNameLayerTextField().getText();
            for (int i = 1; i < this._panel.getAllLayersComboBox().getItemCount(); ++i) {
                if (!string.equals((String)this._panel.getAllLayersComboBox().getItemAt(i))) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                bl = false;
                this._panel.getNameLayerLabel().setForeground(this._warningColor);
            } else {
                this._panel.getNameLayerLabel().setForeground(this._okColor);
            }
        }
        if (this._panel.getExistingLayerRadio().isSelected() && this._panel.getAllLayersComboBox().getSelectedIndex() == 0) {
            bl = false;
            this._panel.getExistingLayerLabel().setForeground(this._warningColor);
        } else {
            this._panel.getExistingLayerLabel().setForeground(this._okColor);
        }
        if (this._panel.getSelAttributeLinkingRadio().isSelected() && this._panel.getDbfAttributesCombo().getSelectedAttribute() == null) {
            bl = false;
            this._panel.getLinkingAttributeLabel().setForeground(this._warningColor);
        } else {
            this._panel.getLinkingAttributeLabel().setForeground(this._okColor);
        }
        if (this._validateButton != null) {
            this._validateButton.setEnabled(bl);
        }
    }

    protected String getLayerName(TdkLayerGID tdkLayerGID) {
        if (tdkLayerGID == null) {
            return null;
        }
        TdkLayer tdkLayer = TdkSetup.getPersistenceService().getLayer(tdkLayerGID);
        if (tdkLayer != null) {
            return tdkLayer.getName();
        }
        return null;
    }

    protected void comboInsertLayers() {
        this._panel.getAllLayersComboBox().removeAllItems();
        this._panel.getAllLayersComboBox().addItem(TdkComponentsI18n.getString("PNL_IMPORT_SHP_SELECT_LAYER"));
        if (this._layers != null) {
            int n = 0;
            while ((long)n < this._layers.size()) {
                this._panel.getAllLayersComboBox().addItem(this.getLayerName(this._layers.get(n)));
                ++n;
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this._panel.getPathTextField()) {
            this._params.setShapefileLocation(this._panel.getPathTextField().getText());
        } else if (focusEvent.getSource() == this._panel.getNameLayerTextField()) {
            this._params.setLayerName(this._panel.getNameLayerTextField().getText());
        }
        this.fieldValidation();
    }

    private void projectionActionPerformed(ActionEvent actionEvent) {
        _logger.info((Object)"Open Projection Dialog");
        TdkActionWorkflowService tdkActionWorkflowService = null;
        try {
            tdkActionWorkflowService = TdkJVipeSetup.getInstance().getActionWorkflowService();
        }
        catch (TdkActionWorkflowServiceNotInitializedException tdkActionWorkflowServiceNotInitializedException) {
            tdkActionWorkflowServiceNotInitializedException.printStackTrace();
            _logger.debug((Object)"Workflow Service not initialized");
            return;
        }
        TeProjection teProjection = this._params.getProjection();
        teProjection = this._params.getProjection() == null ? tdkActionWorkflowService.askForProjection() : tdkActionWorkflowService.editProjection(teProjection);
        if (teProjection != null) {
            this._params.setProjection(teProjection);
            String string = teProjection.getParams().getName() + "/" + teProjection.getParams().getDatum().getName();
            this._panel.getProjectionTextField().setText(string);
        }
    }

    public JButton getValidateButton() {
        return this._validateButton;
    }

    public void setValidateButton(JButton jButton) {
        this._validateButton = jButton;
    }

    public TdkImportShapeParams getResultParams() {
        _logger.debug((Object)("Get Result Params. _result = " + this._result));
        if (this._result.booleanValue()) {
            _logger.debug((Object)("Get result params: " + this._params));
            return this._params;
        }
        return null;
    }

    private void newLayerNameActionPerformed(ActionEvent actionEvent) {
        this._params.setLayerName(this._panel.getNameLayerTextField().getText());
    }
}

