/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkFeedback;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkProgressBarPanel;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkProgressBarPresenter;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkProgressBarView;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;
import org.tecgraf.jtdk.desktop.components.util.TdkSwingThreadExecuter;

public class TdkProgressBarDialog
extends TdkDialog
implements TdkProgressBarView {
    private static Logger _logger = Logger.getLogger(TdkProgressBarDialog.class);
    private boolean _hideCancelButton = false;
    private JProgressBar _progressBar = null;
    private JLabel _description = null;
    private boolean _hideFeedbackMessage = false;
    private boolean _hideProgressBar = false;
    private ActionListener _cancelListener = null;
    private boolean _showMessage;
    private boolean _showCancelButton;
    private boolean _showProgress;
    private String _prompt;
    private long _delay = 0L;
    private boolean _syncronizedExecution = true;
    private static final String ACT_CMD_CANCEL = "ACT_CMD_CANCEL";

    public TdkProgressBarDialog(Frame frame) {
        this(frame, "", false, false, false);
    }

    public TdkProgressBarDialog(Frame frame, String string, boolean bl, boolean bl2, boolean bl3) {
        this(frame, string, bl, bl2, bl3, 0L);
    }

    public TdkProgressBarDialog(Frame frame, String string, boolean bl, boolean bl2, boolean bl3, long l) {
        super(frame);
        this.setTitle(TdkComponentsI18n.getString("DLG_PROGRESS_BAR_TITLE"));
        this.setModal(true);
        this._prompt = string;
        this._showMessage = bl3;
        this._showCancelButton = bl2;
        this._showProgress = bl;
        this._delay = l;
    }

    public void setSyncronizedExecution(boolean bl) {
        this._syncronizedExecution = bl;
    }

    public void execute(Runnable runnable, TdkFeedback tdkFeedback) throws Exception {
        TdkProgressBarPresenter tdkProgressBarPresenter = new TdkProgressBarPresenter(tdkFeedback, this, new TdkSwingThreadExecuter());
        tdkProgressBarPresenter.setSyncronizedExecution(this._syncronizedExecution);
        tdkProgressBarPresenter.executeTask(runnable, this._showProgress, this._showCancelButton, this._showMessage, this._delay);
    }

    public void initComponents() {
        JPanel jPanel;
        if (this._hideProgressBar) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel = new JPanel(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            Box box = Box.createHorizontalBox();
            gridBagLayout.setConstraints(box, gridBagConstraints);
            jPanel.add(box);
            JLabel jLabel = new JLabel();
            jLabel.setText(TdkComponentsI18n.getString("DLG_PROGRESS_BAR_LABEL"));
            if (!this._hideFeedbackMessage) {
                this._description = jLabel;
            }
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            Box box2 = Box.createHorizontalBox();
            gridBagLayout.setConstraints(box2, gridBagConstraints);
            jPanel.add(box2);
            jPanel.setPreferredSize(new Dimension(300, 150));
            this.setResizable(true);
        } else {
            TdkProgressBarPanel tdkProgressBarPanel = new TdkProgressBarPanel(this._prompt);
            this._description = tdkProgressBarPanel.getDescriptionLabel();
            this._progressBar = tdkProgressBarPanel.getProgressBar();
            jPanel = tdkProgressBarPanel;
        }
        if (!this._hideCancelButton) {
            this.addButton("Cancelar", ACT_CMD_CANCEL);
        }
        super.initComponents(jPanel);
        if (this.getOwner() != null) {
            TdkDialogUtil.centralize(this, this.getOwner());
        } else {
            TdkDialogUtil.centralize(this);
        }
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void hideDialog() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null && actionEvent.getActionCommand().equals(ACT_CMD_CANCEL) && this._cancelListener != null) {
            this._cancelListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void hideCancelButton() {
        this._hideCancelButton = true;
    }

    @Override
    public void hideMessageFeedback() {
        this._hideFeedbackMessage = true;
    }

    @Override
    public void hideProgressBar() {
        this._hideProgressBar = true;
    }

    @Override
    public void resetProgressRate() {
        if (this._progressBar != null) {
            this._progressBar.setValue(0);
        }
    }

    @Override
    public void setCancelListener(ActionListener actionListener) {
        this._cancelListener = actionListener;
    }

    @Override
    public void showDialog() {
        this.initComponents();
        this.setVisible(true);
    }

    @Override
    public void updateDescription(String string) {
        if (this._description != null) {
            this._description.setText(string);
        }
    }

    @Override
    public void updateProgressRate(float f) {
        if (this._progressBar != null) {
            this._progressBar.setValue(new Float(f).intValue());
        }
    }
}

