/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkFeedback;
import org.tecgraf.jtdk.core.TdkFeedbackListener;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkProgressBarView;
import org.tecgraf.jtdk.desktop.components.util.TdkSwingThreadExecuter;

public class TdkProgressBarPresenter {
    private static final Logger logger = Logger.getLogger(TdkProgressBarPresenter.class);
    private TdkProgressBarView _view;
    private TdkFeedback _feedback;
    private TdkSwingThreadExecuter _executer;
    private MyFeedbackListener _feedbackListener;
    private boolean _showMessage = true;
    private boolean _showProgress;
    private boolean _syncronizedExecution = true;

    public TdkProgressBarPresenter(TdkFeedback tdkFeedback, TdkProgressBarView tdkProgressBarView, TdkSwingThreadExecuter tdkSwingThreadExecuter) {
        this._view = tdkProgressBarView;
        this._feedback = tdkFeedback;
        this._executer = tdkSwingThreadExecuter;
        this.addListener();
    }

    public void setSyncronizedExecution(boolean bl) {
        this._syncronizedExecution = bl;
    }

    private void addListener() {
        this._view.setCancelListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TdkProgressBarPresenter.this.cancel();
            }
        });
        this._feedbackListener = new MyFeedbackListener();
    }

    private void cancel() {
    }

    public void updateGui() {
        final float f = this._feedback.getCurrentProgressRate();
        final String string = this._feedback.getCurrentTaskDescription();
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TdkProgressBarPresenter.this._showMessage) {
                    TdkProgressBarPresenter.this._view.updateDescription(string);
                }
                if (TdkProgressBarPresenter.this._showProgress) {
                    TdkProgressBarPresenter.this._view.updateProgressRate(f);
                }
            }
        });
    }

    protected void invokeLater(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public void executeTask(Runnable runnable, boolean bl, boolean bl2, boolean bl3) throws Exception {
        this.executeTask(runnable, bl, bl2, bl3, 0L);
    }

    public void executeTask(final Runnable runnable, final boolean bl, final boolean bl2, final boolean bl3, final long l) throws Exception {
        this._showMessage = bl3;
        this._showProgress = bl;
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                TdkProgressBarPresenter.this._view.resetProgressRate();
                if (TdkProgressBarPresenter.this._feedback != null) {
                    TdkProgressBarPresenter.this._feedback.addFeedbackListener((TdkFeedbackListener)TdkProgressBarPresenter.this._feedbackListener);
                }
                if (!bl2) {
                    TdkProgressBarPresenter.this._view.hideCancelButton();
                }
                if (!bl || TdkProgressBarPresenter.this._feedback == null) {
                    TdkProgressBarPresenter.this._view.hideProgressBar();
                }
                if (!bl3 || TdkProgressBarPresenter.this._feedback == null) {
                    TdkProgressBarPresenter.this._view.hideMessageFeedback();
                }
                try {
                    final MyShowDialog myShowDialog = new MyShowDialog(TdkProgressBarPresenter.this._view);
                    if (l > 0L) {
                        new Timer().schedule((TimerTask)myShowDialog, l);
                    } else {
                        myShowDialog.run();
                    }
                    Runnable runnable2 = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                runnable.run();
                                myShowDialog.cancelOperation();
                                TdkProgressBarPresenter.this.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        TdkProgressBarPresenter.this._view.updateProgressRate(100.0f);
                                        TdkProgressBarPresenter.this._view.hideDialog();
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                TdkProgressBarPresenter.this.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                        }
                    };
                    if (TdkProgressBarPresenter.this._syncronizedExecution) {
                        logger.debug((Object)"executing in foxtrot");
                        TdkProgressBarPresenter.this._executer.execute(runnable2);
                    } else {
                        logger.debug((Object)"executing in owner thread");
                        new Thread(runnable2).start();
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
        this.invokeAndWait(runnable2);
    }

    protected void invokeAndWait(Runnable runnable) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    private class MyShowDialog
    extends TimerTask {
        private TdkProgressBarView _localView;
        private boolean _finish = false;

        public MyShowDialog(TdkProgressBarView tdkProgressBarView) {
            this._localView = tdkProgressBarView;
        }

        @Override
        public void run() {
            if (!this._finish) {
                TdkProgressBarPresenter.this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TdkProgressBarPresenter.this._view.showDialog();
                    }
                });
            }
        }

        public void cancelOperation() {
            this._finish = true;
        }
    }

    private class MyFeedbackListener
    implements TdkFeedbackListener {
        private MyFeedbackListener() {
        }

        public void feedbackEvent(TdkFeedback tdkFeedback) {
            TdkProgressBarPresenter.this.updateGui();
        }
    }
}

