/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkEditProjectionDialog;

public class TdkProjectionChooser
extends JPanel
implements ActionListener {
    public static final String ACT_CMD_PROJECTION = "proj_command";
    private TeProjection _proj;
    private Frame _owner;
    protected JButton _projectionButton;
    private JTextPane _projectionTextPane;
    private JScrollPane jScrollPane1;

    public TdkProjectionChooser() {
        this(null, null);
    }

    public TdkProjectionChooser(TeProjection teProjection, Frame frame) {
        this._proj = teProjection;
        this._owner = frame;
        this.initComponents();
        this.initValues();
        this._projectionButton.setText(TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_BTN"));
        this._projectionButton.setActionCommand(ACT_CMD_PROJECTION);
        this._projectionButton.addActionListener(this);
    }

    private void projectionActionPerformed(ActionEvent actionEvent) {
        Frame frame = this._owner != null ? this._owner : new JFrame();
        TdkEditProjectionDialog tdkEditProjectionDialog = new TdkEditProjectionDialog(frame);
        TeProjection teProjection = tdkEditProjectionDialog.editProjection(this._proj);
        if (teProjection != null) {
            this._proj = teProjection;
            String string = this.getDescription();
            this._projectionTextPane.setText(string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACT_CMD_PROJECTION)) {
            this.projectionActionPerformed(actionEvent);
        } else {
            System.err.println("Unknown action performed: " + string);
        }
    }

    public void setProjection(TeProjection teProjection) {
        this._proj = teProjection;
        this.initValues();
    }

    public TeProjection getProjection() {
        return this._proj;
    }

    private void initValues() {
        if (this._proj != null) {
            String string = this.getDescription();
            this._projectionTextPane.setText(string);
        }
    }

    private String getDescription() {
        String string = null;
        if (this._proj.getName().equals("Albers")) {
            string = TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_PROJECTION") + " " + this._proj.getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DATUM") + " " + this._proj.datum().getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LONG") + " " + this._proj.getLongitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LAT") + " " + this._proj.getLattitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DEFAULT_PARAREL") + " " + this._proj.getFirstStandartParalel() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DEFAULT_PARAREL") + " " + this._proj.getSecondStandartParalel() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_X") + " " + this._proj.getOffsetX() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_Y") + " " + this._proj.getOffsetY();
        } else if (this._proj.getName().equals("LatLong")) {
            string = TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_PROJECTION") + " " + this._proj.getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DATUM") + " " + this._proj.datum().getName();
        } else if (this._proj.getName().equals("LambertConformal")) {
            string = TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_PROJECTION") + " " + this._proj.getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DATUM") + " " + this._proj.datum().getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LONG") + " " + this._proj.getLongitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LAT") + " " + this._proj.getLattitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DEFAULT_PARAREL") + " " + this._proj.getFirstStandartParalel() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DEFAULT_PARAREL") + " " + this._proj.getSecondStandartParalel() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_X") + " " + this._proj.getOffsetX() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_Y") + " " + this._proj.getOffsetY();
        } else if (this._proj.getName().equals("Mercator")) {
            string = TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_PROJECTION") + " " + this._proj.getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DATUM") + " " + this._proj.datum().getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LONG") + " " + this._proj.getLongitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LAT") + " " + this._proj.getLattitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DEFAULT_PARAREL") + " " + this._proj.getFirstStandartParalel() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_X") + " " + this._proj.getOffsetX() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_Y") + " " + this._proj.getOffsetY();
        } else if (this._proj.getName().equals("Miller")) {
            string = TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_PROJECTION") + " " + this._proj.getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DATUM") + " " + this._proj.datum().getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LONG") + " " + this._proj.getLongitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_X") + " " + this._proj.getOffsetX() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_Y") + " " + this._proj.getOffsetY();
        } else if (this._proj.getName().equals("UTM")) {
            string = TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_PROJECTION") + " " + this._proj.getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DATUM") + " " + this._proj.datum().getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LONG") + " " + this._proj.getLongitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LAT") + " " + this._proj.getLattitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_X") + " " + this._proj.getOffsetX() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_Y") + " " + this._proj.getOffsetY() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_SCALE") + " " + this._proj.getScale();
        } else if (this._proj.getName().equals("Polyconic")) {
            string = TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_PROJECTION") + " " + this._proj.getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DATUM") + " " + this._proj.datum().getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LONG") + " " + this._proj.getLongitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LAT") + " " + this._proj.getLattitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_X") + " " + this._proj.getOffsetX() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_Y") + " " + this._proj.getOffsetY();
        } else if (this._proj.getName().equals("Sinusoidal")) {
            string = TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_PROJECTION") + " " + this._proj.getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DATUM") + " " + this._proj.datum().getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_LONG") + " " + this._proj.getLongitudeOrigin() * 57.29577951308232 + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_X") + " " + this._proj.getOffsetX() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_OFFSET_Y") + " " + this._proj.getOffsetY();
        } else if (this._proj.getName().equals("NoProjection")) {
            string = TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_PROJECTION") + " " + this._proj.getName() + "\n" + TdkComponentsI18n.getString("CMP_PROJECTION_CHOOSER_DATUM") + " " + this._proj.datum().getName();
        }
        return string;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this._projectionTextPane = new JTextPane();
        this._projectionButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(10, 30));
        this._projectionTextPane.setEditable(false);
        this.jScrollPane1.setViewportView(this._projectionTextPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this._projectionButton.setText("Projection");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this._projectionButton, gridBagConstraints);
    }
}

