/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkThemePropertiesPanel;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkThemePropertiesPanelController;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateThemeEvent;

public class TdkThemePropertiesDialog
extends TdkDialog
implements ActionListener {
    private static final long serialVersionUID = -7940585334694737487L;
    private static Logger _logger = Logger.getLogger(TdkThemePropertiesDialog.class);
    private TdkThemePropertiesPanel _panel = new TdkThemePropertiesPanel();
    private TdkThemePropertiesPanelController _panelController = new TdkThemePropertiesPanelController(this._panel);

    public TdkThemePropertiesDialog(Frame frame) {
        super(frame);
        this.initComponents();
        this._panel.registerActionListener(this._panelController);
    }

    public TdkUpdateThemeEvent editThemeProperties(TdkThemeGID tdkThemeGID) {
        this._panelController.setThemeGID(tdkThemeGID);
        this._panel.initValues(tdkThemeGID);
        this._panelController.validate();
        this.setVisible(true);
        return this._panelController.getThemeUpdateEvent();
    }

    private void initComponents() {
        this.addButton(TdkComponentsI18n.getString("DLG_BTN_OK"), "ok_command");
        this.addButton(TdkComponentsI18n.getString("DLG_BTN_CANCEL"), "cancel_command");
        super.initComponents(this._panel);
        this._panelController.setValidateButton(this.getButton("ok_command"));
        this._panel.registerKeyListener(this._panelController);
        this._panelController.validate();
        this.setDefaultCloseOperation(2);
        this.setTitle(TdkComponentsI18n.getString("DLG_THEME_PROPERTIES_TITLE"));
    }

    public void okButtonActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: OK");
        if (this._panelController.validateData()) {
            this._panelController.updateThemeProperties();
            this.dispose();
        }
    }

    public void cancelButtonActionPerformed(ActionEvent actionEvent) {
        _logger.debug((Object)"Action performed: CANCEL ");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "ok_command") {
            this.okButtonActionPerformed(actionEvent);
        } else if (string == "cancel_command") {
            this.cancelButtonActionPerformed(actionEvent);
            super.actionPerformed(actionEvent);
        } else {
            _logger.debug((Object)("Unknown action performed: " + string));
        }
    }
}

