/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.tecgraf.jtdk.core.swig.StringVector;
import org.tecgraf.jtdk.core.swig.TdkLayer;
import org.tecgraf.jtdk.core.swig.TdkLayerGID;
import org.tecgraf.jtdk.core.swig.TdkRasterMask;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TeAttrTableVector;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkEditProjectionPanel;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkEditProjectionPanelController;
import org.tecgraf.jtdk.desktop.components.util.TdkStyleButton;

public class TdkThemePropertiesPanel
extends JPanel {
    private static final long serialVersionUID = 85256047923593154L;
    private TeAttrTableVector _tabVec;
    JCheckBox transparencyChk_;
    private Logger _logger = Logger.getLogger(TdkThemePropertiesPanel.class);
    private TdkStyleButton transparencySbt_;
    private JComboBox _attrSelectionComboBox;
    private JLabel _attrSelectionLabel;
    private JLabel _boxExtensionLabel;
    private JTextField _boxExtensionTextField;
    private JPanel _extensionPanne;
    private JPanel _generalTabbedPanel;
    private JPanel _geographicalInformationPane;
    private JLabel _maxScaleLabel;
    private JTextField _maxScaleTextField;
    private JLabel _minScaleLabel;
    private JTextField _minScaleTextField;
    private JPanel _projectionPane;
    private JPanel _scalePane;
    private JTabbedPane _tabbedPane;
    private JComboBox _tableSelectionComboBox = new JComboBox();
    private JLabel _tableSelectionLabel;
    private JLabel _themeNameLabel;
    private JTextField _themeNameTextField;
    private JCheckBox _toolTipCheckBox;
    private JPanel _toolTipPanel;

    public TdkThemePropertiesPanel() {
        this.initComponents();
        this._tableSelectionComboBox.setEnabled(false);
        this._themeNameLabel.setText(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_THEME_NAME_LABEL"));
        this._tableSelectionLabel.setText(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_TABLE_SELECTION_LABEL"));
        this._attrSelectionLabel.setText(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_ATTR_SELECTION_LABEL"));
        this._minScaleLabel.setText(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_MIN_SCALE_LABEL"));
        this._maxScaleLabel.setText(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_MAX_SCALE_LABEL"));
        this._toolTipCheckBox.setText(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_TOOLTIP_CHECK_BOX"));
        this._boxExtensionLabel.setText(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_BOX_EXT_LABEL"));
        this._toolTipCheckBox.setActionCommand("tooltip_command");
        this._tableSelectionComboBox.setActionCommand("tiptable_command");
        this._toolTipPanel.setBorder(BorderFactory.createTitledBorder(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_TOOLTIP_BORDER_TITLE")));
        this._extensionPanne.setBorder(BorderFactory.createTitledBorder(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_EXT_BORDER_TITLE")));
        this._scalePane.setBorder(BorderFactory.createTitledBorder(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_SCALE_BORDER_TITLE")));
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_PROJ_BORDER_TITLE")), BorderFactory.createEmptyBorder(0, 10, 5, 10));
        this._projectionPane.setBorder(compoundBorder);
        this._tabbedPane.setTitleAt(1, TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_TAB_GEOGRAPHICAL_INFORMATION"));
        this._tabbedPane.setTitleAt(0, TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_TAB_GENERAL"));
        this._logger.debug((Object)"created");
    }

    public void initValues(TdkThemeGID tdkThemeGID) {
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
        this._themeNameTextField.setText(tdkTheme.getName());
        this._tabVec = tdkTheme.getAttributeTableVector();
        long l = this._tabVec.size();
        int n = 0;
        for (n = 0; n < (int)l; ++n) {
            this._tableSelectionComboBox.insertItemAt(this._tabVec.get(n).getName(), n);
        }
        String string = tdkTheme.getTipTable();
        if (!string.equals("")) {
            this._tableSelectionComboBox.setSelectedItem(string);
            this._toolTipCheckBox.doClick();
        }
        this.setFieldList();
        String string2 = tdkTheme.getTipField();
        if (!string.equals("")) {
            this._attrSelectionComboBox.setSelectedItem(string2);
        }
        Double d = tdkTheme.getMinScale();
        String string3 = d.toString();
        this._minScaleTextField.setText(string3);
        Double d2 = tdkTheme.getMaxScale();
        String string4 = d2.toString();
        this._maxScaleTextField.setText(string4);
        Double d3 = new Double(tdkTheme.getBoxExtension());
        this._boxExtensionTextField.setText(d3.toString());
        this._projectionPane.setLayout(new BorderLayout());
        TdkEditProjectionPanel tdkEditProjectionPanel = new TdkEditProjectionPanel(false);
        TdkEditProjectionPanelController tdkEditProjectionPanelController = new TdkEditProjectionPanelController(tdkEditProjectionPanel);
        TdkLayerGID tdkLayerGID = new TdkLayerGID(tdkThemeGID.getDBKey(), tdkTheme.getLayerId());
        TdkLayer tdkLayer = TdkSetup.getPersistenceService().getLayer(tdkLayerGID);
        if (tdkLayer != null) {
            tdkEditProjectionPanelController.setProjection(tdkLayer.getProjection());
            tdkEditProjectionPanelController.initPanel();
            tdkEditProjectionPanel.setPreferredSize(new Dimension(100, 200));
        }
        this._projectionPane.add((Component)tdkEditProjectionPanel, "Center");
        if (tdkTheme.hasRaster()) {
            TdkRasterMask tdkRasterMask = tdkTheme.getRasterMask(1);
            this._tabbedPane.addTab(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_TAB_RASTER"), this.createRasterTabPane(tdkRasterMask));
        }
    }

    private JPanel createRasterTabPane(TdkRasterMask tdkRasterMask) {
        boolean bl = false;
        Color color = null;
        if (tdkRasterMask != null) {
            bl = tdkRasterMask.getUseMask();
            color = tdkRasterMask.getMaskColor();
        }
        this.transparencySbt_ = new TdkStyleButton(false, color);
        this.transparencySbt_.setToolTipText(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_TRANSPARENCY_TOOLTIP"));
        this.transparencyChk_ = new JCheckBox();
        this.transparencyChk_.setText(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_TRANSPARENCY_TEXT"));
        this.transparencyChk_.setMnemonic(TdkComponentsI18n.getString("PNL_THEME_PROPERTIES_TRANSPARENCY_MNEMONIC").charAt(0));
        this.transparencyChk_.setSelected(bl);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 18, 2, new Insets(0, 3, 3, 3), 0, 0);
        jPanel.add((Component)this.transparencyChk_, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 100.0;
        jPanel.add((Component)this.transparencySbt_, gridBagConstraints);
        return jPanel;
    }

    public void registerActionListener(ActionListener actionListener) {
        this._toolTipCheckBox.addActionListener(actionListener);
        this._tableSelectionComboBox.addActionListener(actionListener);
    }

    public void toolTipActivation() {
        boolean bl = this._toolTipCheckBox.isSelected();
        this._tableSelectionLabel.setEnabled(bl);
        this._tableSelectionComboBox.setEnabled(bl);
        this._attrSelectionLabel.setEnabled(bl);
        this._attrSelectionComboBox.setEnabled(bl);
        if (bl) {
            this._logger.debug((Object)"tooltip activate");
        } else {
            this._logger.debug((Object)"tooltip deactivate");
        }
    }

    public void setFieldList() {
        this._attrSelectionComboBox.removeAllItems();
        int n = this._tableSelectionComboBox.getSelectedIndex();
        if (n >= 0) {
            StringVector stringVector = new StringVector();
            this._tabVec.get(n).attributeNames(stringVector);
            long l = stringVector.size();
            int n2 = 0;
            for (n2 = 0; n2 < (int)l; ++n2) {
                this._attrSelectionComboBox.insertItemAt(stringVector.get(n2), n2);
            }
        }
    }

    public String getThemeName() {
        return this._themeNameTextField.getText();
    }

    public boolean useRasterMask() {
        if (this.transparencyChk_ != null) {
            return this.transparencyChk_.isSelected();
        }
        return false;
    }

    public Color getRasterColor() {
        if (this.transparencySbt_ != null) {
            return this.transparencySbt_.getColor();
        }
        return null;
    }

    public double getMinScale() {
        String string = this._minScaleTextField.getText();
        double d = Double.parseDouble(string);
        return d;
    }

    public double getMaxScale() {
        String string = this._maxScaleTextField.getText();
        double d = Double.parseDouble(string);
        return d;
    }

    public String getTipTable() {
        if (this._toolTipCheckBox.isSelected()) {
            return (String)this._tableSelectionComboBox.getSelectedItem();
        }
        return "";
    }

    public String getTipField() {
        if (this._toolTipCheckBox.isSelected()) {
            return (String)this._attrSelectionComboBox.getSelectedItem();
        }
        return "";
    }

    public double getBoxExtension() {
        String string = this._boxExtensionTextField.getText();
        double d = Double.parseDouble(string);
        return d;
    }

    private void initComponents() {
        this._tabbedPane = new JTabbedPane();
        this._generalTabbedPanel = new JPanel();
        this._toolTipPanel = new JPanel();
        this._toolTipCheckBox = new JCheckBox();
        this._tableSelectionLabel = new JLabel();
        this._attrSelectionLabel = new JLabel();
        this._attrSelectionComboBox = new JComboBox();
        this._tableSelectionLabel.setEnabled(false);
        this._tableSelectionComboBox.setEnabled(false);
        this._attrSelectionLabel.setEnabled(false);
        this._attrSelectionComboBox.setEnabled(false);
        this._tableSelectionComboBox = new JComboBox();
        this._scalePane = new JPanel();
        this._minScaleTextField = new JTextField();
        this._minScaleLabel = new JLabel();
        this._maxScaleLabel = new JLabel();
        this._maxScaleTextField = new JTextField();
        this._extensionPanne = new JPanel();
        this._boxExtensionLabel = new JLabel();
        this._boxExtensionTextField = new JTextField();
        this._geographicalInformationPane = new JPanel();
        this._projectionPane = new JPanel();
        this._themeNameTextField = new JTextField();
        this._themeNameLabel = new JLabel();
        this._toolTipPanel.setBorder(BorderFactory.createTitledBorder("Geral"));
        this._toolTipPanel.setAutoscrolls(true);
        this._toolTipCheckBox.setText("ToolTip On/Off");
        this._toolTipCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._toolTipCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this._tableSelectionLabel.setText("Selecione a Tabela:");
        this._attrSelectionLabel.setText("Selecione o Atributo:");
        GroupLayout groupLayout = new GroupLayout((Container)this._toolTipPanel);
        this._toolTipPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this._tableSelectionLabel).add((Component)this._tableSelectionComboBox, -2, 134, -2)).add(46, 46, 46).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this._attrSelectionComboBox, -2, 139, -2).add((Component)this._attrSelectionLabel))).add((Component)this._toolTipCheckBox)).addContainerGap(70, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this._toolTipCheckBox).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this._attrSelectionLabel).addPreferredGap(0).add((Component)this._attrSelectionComboBox, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(1).add((Component)this._tableSelectionLabel).addPreferredGap(0).add((Component)this._tableSelectionComboBox, -2, 22, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this._scalePane.setBorder(BorderFactory.createTitledBorder("Escala"));
        this._minScaleTextField.setText("0.000000");
        this._minScaleLabel.setText("Escala M\u00c3\u00adnima:");
        this._maxScaleLabel.setText("Escala M\u00c3\u00a1xima:");
        this._maxScaleTextField.setText("0.000000");
        GroupLayout groupLayout2 = new GroupLayout((Container)this._scalePane);
        this._scalePane.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this._minScaleLabel).add((Component)this._minScaleTextField, -2, 175, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this._maxScaleTextField, -2, 156, -2).add((Component)this._maxScaleLabel)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this._maxScaleLabel).add((Component)this._minScaleLabel)).add(5, 5, 5).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this._maxScaleTextField, -2, -1, -2).add((Component)this._minScaleTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this._extensionPanne.setBorder(BorderFactory.createTitledBorder("Extens\u00c3\u00a3o de Enquadramento"));
        this._boxExtensionLabel.setText("Extens\u00c3\u00a3o de Enquadramento");
        this._boxExtensionLabel.setName("_boxExtensionLabel");
        GroupLayout groupLayout3 = new GroupLayout((Container)this._extensionPanne);
        this._extensionPanne.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this._boxExtensionTextField, -1, 379, Short.MAX_VALUE).add((Component)this._boxExtensionLabel)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(6, 6, 6).add((Component)this._boxExtensionLabel).addPreferredGap(1).add((Component)this._boxExtensionTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout4 = new GroupLayout((Container)this._generalTabbedPanel);
        this._generalTabbedPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this._toolTipPanel, -1, -1, Short.MAX_VALUE).add((Component)this._scalePane, -1, 411, Short.MAX_VALUE).add((Component)this._extensionPanne, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this._toolTipPanel, -2, -1, -2).addPreferredGap(0).add((Component)this._scalePane, -2, -1, -2).addPreferredGap(0).add((Component)this._extensionPanne, -2, -1, -2).addContainerGap(21, Short.MAX_VALUE)));
        this._tabbedPane.addTab("Geral", this._generalTabbedPanel);
        this._projectionPane.setBorder(BorderFactory.createTitledBorder("Proje\u00c3\u00a7\u00c3\u00a3o"));
        GroupLayout groupLayout5 = new GroupLayout((Container)this._projectionPane);
        this._projectionPane.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 390, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 265, Short.MAX_VALUE));
        GroupLayout groupLayout6 = new GroupLayout((Container)this._geographicalInformationPane);
        this._geographicalInformationPane.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add(19, 19, 19).add((Component)this._projectionPane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout6.createSequentialGroup().addContainerGap().add((Component)this._projectionPane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this._tabbedPane.addTab("Informa\u00c3\u00a7\u00c3\u00b5es Geogr\u00c3\u00a1ficas", this._geographicalInformationPane);
        this._themeNameTextField.setText(" ");
        this._themeNameLabel.setText("Nome do Tema:");
        GroupLayout groupLayout7 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout7);
        groupLayout7.setHorizontalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout7.createParallelGroup(2).add(1, (Component)this._tabbedPane, -1, 436, Short.MAX_VALUE).add(1, (Component)this._themeNameLabel).add((Component)this._themeNameTextField, -1, 436, Short.MAX_VALUE)).addContainerGap()));
        groupLayout7.setVerticalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add((GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)this._themeNameLabel).addPreferredGap(0).add((Component)this._themeNameTextField, -2, -1, -2).addPreferredGap(1).add((Component)this._tabbedPane, -2, 338, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void registerKeyListener(KeyListener keyListener) {
        this._maxScaleTextField.addKeyListener(keyListener);
        this._minScaleTextField.addKeyListener(keyListener);
        this._themeNameTextField.addKeyListener(keyListener);
        this._boxExtensionTextField.addKeyListener(keyListener);
    }
}

