/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkRasterMask;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkThemePropertiesPanel;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateThemeEvent;

public class TdkThemePropertiesPanelController
extends KeyAdapter
implements ActionListener {
    private static Logger _logger = Logger.getLogger(TdkThemePropertiesPanelController.class);
    public static final String ACT_CMD_OK = "ok_command";
    public static final String ACT_CMD_CANCEL = "cancel_command";
    public static final String ACT_CMD_TOOLTIPCB = "tooltip_command";
    public static final String ACT_CMD_TIPTABLE = "tiptable_command";
    private TdkUpdateThemeEvent _updateEvent = new TdkUpdateThemeEvent();
    private TdkThemePropertiesPanel _panel;
    private TdkThemeGID _theme;
    private JButton _validateButton;

    public TdkThemePropertiesPanelController(TdkThemePropertiesPanel tdkThemePropertiesPanel) {
        this._panel = tdkThemePropertiesPanel;
    }

    public void setThemeGID(TdkThemeGID tdkThemeGID) {
        this._theme = tdkThemeGID;
        _logger.debug((Object)("theme gid set: " + tdkThemeGID));
    }

    public void updateThemeProperties() {
        this.isThemeChangeEventUpdated();
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this._theme);
        String string = "";
        if (this._updateEvent.nameChanged()) {
            string = "theme name updated: from " + tdkTheme.getName() + " to " + this._panel.getThemeName();
            _logger.debug((Object)string);
            tdkTheme.setName(this._panel.getThemeName());
        }
        if (this._updateEvent.minMaxScaleChanged()) {
            string = "theme min max scale updated: from (" + tdkTheme.getMinScale() + ", " + tdkTheme.getMaxScale() + ") to " + "(" + this._panel.getMinScale() + ", " + this._panel.getMaxScale() + ")";
            _logger.debug((Object)string);
            tdkTheme.setMaxScale(this._panel.getMaxScale());
            tdkTheme.setMinScale(this._panel.getMinScale());
        }
        if (this._updateEvent.tooltipChanged()) {
            string = "theme tooltip attribute updated: from " + tdkTheme.getTipTable() + "." + tdkTheme.getTipField() + " to " + this._panel.getTipTable() + "." + this._panel.getTipField();
            tdkTheme.setTipTable(this._panel.getTipTable());
            tdkTheme.setTipField(this._panel.getTipField());
        }
        if (this._updateEvent.isBoxExtensionChanged()) {
            string = "theme box extension updated: from " + tdkTheme.getBoxExtension() + " to " + this._panel.getBoxExtension();
            tdkTheme.setBoxExtension(this._panel.getBoxExtension());
        }
        if (this._updateEvent.isRasterMaskChanged()) {
            TdkRasterMask tdkRasterMask = new TdkRasterMask(this._panel.useRasterMask(), new Color(this._panel.getRasterColor().getRed(), this._panel.getRasterColor().getGreen(), this._panel.getRasterColor().getBlue()));
            tdkTheme.setRasterMask(1, tdkRasterMask);
        }
    }

    public void isThemeChangeEventUpdated() {
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this._theme);
        TdkRasterMask tdkRasterMask = tdkTheme.getRasterMask(1);
        if (tdkTheme.hasRaster()) {
            boolean bl = false;
            Color color = null;
            if (tdkRasterMask != null) {
                bl = tdkRasterMask.getUseMask();
                color = tdkRasterMask.getMaskColor();
            }
            if (bl != this._panel.useRasterMask()) {
                this._updateEvent.setRasterMaskChanged(true);
            }
            if (this._panel.getRasterColor() != null) {
                if (color == null) {
                    this._updateEvent.setRasterMaskChanged(true);
                } else if (!this._panel.getRasterColor().equals(color)) {
                    this._updateEvent.setRasterMaskChanged(true);
                }
            }
        }
        if (tdkTheme.getName() != this._panel.getThemeName()) {
            this._updateEvent.setNameChanged(true);
        }
        if (tdkTheme.getMinScale() != this._panel.getMinScale() || tdkTheme.getMaxScale() != this._panel.getMaxScale()) {
            this._updateEvent.setMinMaxScaleChanged(true);
        }
        if (!tdkTheme.getTipTable().equals(this._panel.getTipTable()) || !tdkTheme.getTipField().equals(this._panel.getTipField())) {
            this._updateEvent.setTooltipChanged(true);
        }
        if (tdkTheme.getBoxExtension() != this._panel.getBoxExtension()) {
            this._updateEvent.setBoxExtensionChanged(true);
        }
    }

    public TdkUpdateThemeEvent getThemeUpdateEvent() {
        return this._updateEvent;
    }

    public void toolTipCheckBoxActionPerfomed(ActionEvent actionEvent) {
        System.out.println("Action performed: TOOLTIP ON/OFF");
        this._panel.toolTipActivation();
    }

    public void tableSelectionActionPerfomed(ActionEvent actionEvent) {
        System.out.println("Action performed: TABLE SELECTION");
        this._panel.setFieldList();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACT_CMD_TOOLTIPCB)) {
            this.toolTipCheckBoxActionPerfomed(actionEvent);
        } else if (string.equals(ACT_CMD_TIPTABLE)) {
            _logger.debug((Object)"selected tip table changed");
            this.tableSelectionActionPerfomed(actionEvent);
        } else {
            _logger.debug((Object)("Unknown action performed: " + string));
        }
    }

    public void setValidateButton(JButton jButton) {
        this._validateButton = jButton;
    }

    public void validate() {
        if (this._validateButton != null) {
            this._validateButton.setEnabled(this.validateData());
        }
    }

    public boolean validateData() {
        try {
            this._panel.getMinScale();
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        try {
            this._panel.getMaxScale();
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        try {
            this._panel.getBoxExtension();
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return !this._panel.getThemeName().trim().isEmpty();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.validate();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.validate();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.validate();
    }
}

