/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.exceptions.TdkInvalidParamValueException;
import org.tecgraf.jtdk.core.exceptions.TdkNullPointerException;
import org.tecgraf.jtdk.core.swig.TdkLineStyleComposite;
import org.tecgraf.jtdk.core.swig.TdkPointStyle;
import org.tecgraf.jtdk.core.swig.TdkPointStyleComposite;
import org.tecgraf.jtdk.core.swig.TdkPolygonStyleComposite;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkStyle;

public class TdkStyleLayerListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -3788089707149008821L;
    private TdkStyle paintingStyle_ = null;
    private static int selectionBorderWidth = 4;

    public TdkStyleLayerListRenderer(TdkStyle tdkStyle) {
        this.paintingStyle_ = tdkStyle;
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        TdkPointStyle tdkPointStyle = null;
        if (this.paintingStyle_ instanceof TdkPointStyleComposite) {
            if ((long)n > ((TdkPointStyleComposite)this.paintingStyle_).getStyles().size()) {
                return component;
            }
            tdkPointStyle = ((TdkPointStyleComposite)this.paintingStyle_).getStyles().get(n);
            component = new CanvasPanel((TdkStyle)tdkPointStyle);
        }
        if (this.paintingStyle_ instanceof TdkLineStyleComposite) {
            if ((long)n > ((TdkLineStyleComposite)this.paintingStyle_).getStyles().size()) {
                return component;
            }
            tdkPointStyle = ((TdkLineStyleComposite)this.paintingStyle_).getStyles().get(n);
            component = new CanvasPanel((TdkStyle)tdkPointStyle);
        }
        if (this.paintingStyle_ instanceof TdkPolygonStyleComposite) {
            if ((long)n > ((TdkPolygonStyleComposite)this.paintingStyle_).getStyles().size()) {
                return component;
            }
            tdkPointStyle = ((TdkPolygonStyleComposite)this.paintingStyle_).getStyles().get(n);
            component = new CanvasPanel((TdkStyle)tdkPointStyle);
        }
        if (bl) {
            component.setBackground(new Color(235, 230, 255));
        } else {
            component.setBackground(Color.WHITE);
        }
        return component;
    }

    public class CanvasPanel
    extends JPanel {
        private static final long serialVersionUID = -5441108341072867799L;
        private TdkStyle _style = null;

        public CanvasPanel(TdkStyle tdkStyle) {
            this._style = tdkStyle;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this._style == null) {
                return;
            }
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
            BufferedImage bufferedImage = new BufferedImage(this.getWidth() - 2 * selectionBorderWidth, this.getHeight() - 2 * selectionBorderWidth, 1);
            try {
                TdkSetup.getGraphicalService().getSampleImage(this._style, bufferedImage);
            }
            catch (TdkNullPointerException tdkNullPointerException) {
                tdkNullPointerException.printStackTrace();
            }
            catch (TdkInvalidParamValueException tdkInvalidParamValueException) {
                tdkInvalidParamValueException.printStackTrace();
            }
            catch (TdkException tdkException) {
                tdkException.printStackTrace();
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(bufferedImage, selectionBorderWidth, selectionBorderWidth, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        }
    }
}

