/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.exceptions.TdkInvalidParamValueException;
import org.tecgraf.jtdk.core.exceptions.TdkNullPointerException;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkStyle;
import org.tecgraf.jtdk.core.swig.TdkStyleLibrary;

public class TdkStyleLibListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -3788089707149008821L;
    private TdkStyleLibrary paintingLib_ = new TdkStyleLibrary();
    private RendererObsever rObserver_ = new RendererObsever();
    private static int selectionBorderWidth = 4;

    public TdkStyleLibListRenderer(TdkStyleLibrary tdkStyleLibrary, Observer observer) {
        this.paintingLib_ = tdkStyleLibrary;
        this.rObserver_.addObserver(observer);
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (this.paintingLib_ == null || this.paintingLib_.getStyles().size() == 0L) {
            return null;
        }
        TdkStyle tdkStyle = this.paintingLib_.getStyles().get(n);
        if (tdkStyle == null) {
            return component;
        }
        component = new CanvasPanel(this.paintingLib_.getStyles().get(n));
        if (bl) {
            component.setBackground(new Color(235, 230, 255));
            this.rObserver_.firechange(new Integer(1));
        } else {
            component.setBackground(Color.WHITE);
            this.rObserver_.firechange(new Integer(0));
        }
        return component;
    }

    private class RendererObsever
    extends Observable {
        private RendererObsever() {
        }

        public void firechange(Object object) {
            this.setChanged();
            this.notifyObservers(object);
        }
    }

    public class CanvasPanel
    extends JPanel {
        private static final long serialVersionUID = -5441108341072867799L;
        private Graphics2D currentGraphics_ = null;
        TdkStyle style_ = null;

        public CanvasPanel(TdkStyle tdkStyle) {
            this.style_ = tdkStyle;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.style_ == null) {
                return;
            }
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
            BufferedImage bufferedImage = new BufferedImage(this.getWidth() - 2 * selectionBorderWidth, this.getHeight() - 2 * selectionBorderWidth, 1);
            try {
                TdkSetup.getGraphicalService().getSampleImage(this.style_, bufferedImage);
            }
            catch (TdkNullPointerException tdkNullPointerException) {
                tdkNullPointerException.printStackTrace();
            }
            catch (TdkInvalidParamValueException tdkInvalidParamValueException) {
                tdkInvalidParamValueException.printStackTrace();
            }
            catch (TdkException tdkException) {
                tdkException.printStackTrace();
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(bufferedImage, selectionBorderWidth, selectionBorderWidth, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        }

        @Override
        public Graphics getGraphics() {
            if (this.currentGraphics_ != null) {
                return this.currentGraphics_;
            }
            return super.getGraphics();
        }
    }
}

