/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.model.utils.TdkStyleLibrarySerializer;
import org.tecgraf.jtdk.core.swig.TdkAbstractPersistenceService;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkStyle;
import org.tecgraf.jtdk.core.swig.TdkStyleLibrary;
import org.tecgraf.jtdk.core.swig.TdkStyleLibraryVector;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.style.TdkStyleLibListRenderer;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;

public class TdkStyleLibraryDlg
extends JDialog
implements Observer {
    private static final long serialVersionUID = -8487916974065745049L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JButton btnSave = null;
    private JButton btnClose = null;
    private JLabel jLabel1 = null;
    private JTextField txStyleName = null;
    private JScrollPane jScrollPane = null;
    private JList listCanvas = null;
    private DefaultListCellRenderer.UIResource UIResource = null;
    TdkStyleLibraryVector allLibraries_ = null;
    TdkStyleLibrary paintingLib_ = new TdkStyleLibrary();
    TdkStyle selectedStyle = null;
    TdkStyle saveStyle_ = null;
    boolean isUpdating = true;
    boolean save_select_;
    private int dlgState_ = -1;
    private JMenuBar jJMenuBar = null;
    private JMenu jMenu = null;
    private JMenuItem jMenuItem = null;
    private JMenuItem jMenuItem1 = null;
    private JMenuItem jMenuItem2 = null;
    private JMenu jMenu3 = null;
    private JMenuItem jMenuItem5 = null;
    private JMenuItem jMenuItem6 = null;
    private JPanel jPanel2 = null;
    private JComboBox cbLibName = null;
    private JButton jButton2 = null;
    private JButton jButton3 = null;
    private DefaultFocusTraversalPolicy defaultFocusTraversalPolicy = null;
    private TdkAbstractPersistenceService persServ_ = TdkSetup.getPersistenceService();
    private String dbDesc_;
    private static Logger _logger = Logger.getLogger(TdkStyleLibraryDlg.class);

    public TdkStyleLibraryDlg() {
    }

    public TdkStyleLibraryDlg(JDialog jDialog, TdkStyle tdkStyle, String string) {
        super(jDialog);
        this.initialize();
        this.dbDesc_ = string;
        boolean bl = this.save_select_ = tdkStyle != null;
        if (!this.save_select_) {
            this.getBtnSave().setText(TdkComponentsI18n.getString("STYLE_DIALOG_SELECTION"));
            this.jLabel1.setEnabled(false);
            this.txStyleName.setEditable(false);
        } else {
            this.saveStyle_ = tdkStyle;
        }
        this.updateDialog();
    }

    private void updateDialog() {
        this.isUpdating = true;
        if (this.allLibraries_ == null) {
            this.allLibraries_ = new TdkStyleLibraryVector();
        }
        this.allLibraries_.clear();
        this.persServ_.loadStyleLibraries(this.dbDesc_, this.allLibraries_);
        int n = this.cbLibName.getSelectedIndex();
        if (this.allLibraries_.size() <= 0L) {
            this.listCanvas.setCellRenderer(new TdkStyleLibListRenderer(new TdkStyleLibrary(), this));
            return;
        }
        this.paintingLib_ = this.allLibraries_.get(n == -1 ? 0 : n);
        this.cbLibName.removeAllItems();
        int n2 = 0;
        while ((long)n2 < this.allLibraries_.size()) {
            this.cbLibName.addItem(this.allLibraries_.get(n2).getName());
            ++n2;
        }
        n2 = (int)this.paintingLib_.getStyles().size();
        TdkStyle[] tdkStyleArray = new TdkStyle[n2];
        for (int i = 0; i < n2; ++i) {
            tdkStyleArray[i] = this.paintingLib_.getStyles().get(i);
        }
        this.listCanvas.setListData(tdkStyleArray);
        this.listCanvas.setCellRenderer(new TdkStyleLibListRenderer(this.paintingLib_, this));
        this.isUpdating = false;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(10, 6, 10, 16);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(10, 39, 10, 6);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridx = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(12, 2, 10, 38);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(14, 6, 14, 2);
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(TdkComponentsI18n.getString("STYLE_DIALOG_STYLE_NAME"));
            this.jLabel1.setFont(new Font("Dialog", 0, 10));
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanel.setPreferredSize(new Dimension(382, 46));
            this.jPanel.add((Component)this.jLabel1, gridBagConstraints4);
            this.jPanel.add((Component)this.getTxStyleName(), gridBagConstraints3);
            this.jPanel.add((Component)this.getBtnSave(), gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnClose(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setFont(new Font("Dialog", 0, 10));
            this.btnSave.setPreferredSize(new Dimension(78, 22));
            this.btnSave.setText(TdkComponentsI18n.getString("STYLE_DIALOG_SAVE"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TdkStyleLibraryDlg.this.save_select_) {
                        if (TdkStyleLibraryDlg.this.txStyleName.getText().equals("")) {
                            JOptionPane.showMessageDialog(TdkStyleLibraryDlg.this, TdkComponentsI18n.getString("STYLE_DIALOG_TYPE_STYLE_NAME"), TdkComponentsI18n.getString("STYLE_DIALOG_INFORMATION"), -1);
                            return;
                        }
                        int n = 0;
                        while ((long)n < TdkStyleLibraryDlg.this.paintingLib_.getStyles().size()) {
                            String string = TdkStyleLibraryDlg.this.paintingLib_.getStyles().get(n).getName();
                            if (string.equals(TdkStyleLibraryDlg.this.txStyleName.getText())) {
                                JOptionPane.showMessageDialog(TdkStyleLibraryDlg.this, TdkComponentsI18n.getString("STYLE_DIALOG_ERROR_USED_NAME"), TdkComponentsI18n.getString("STYLE_DIALOG_INFORMATION"), -1);
                                return;
                            }
                            ++n;
                        }
                        if (TdkStyleLibraryDlg.this.listCanvas.getSelectedIndex() == -1) {
                            TdkStyleLibraryDlg.this.saveStyle_.setName(TdkStyleLibraryDlg.this.txStyleName.getText());
                            TdkStyleLibraryDlg.this.persServ_.insertStyle(TdkStyleLibraryDlg.this.dbDesc_, TdkStyleLibraryDlg.this.saveStyle_, TdkStyleLibraryDlg.this.paintingLib_.getId() == 0 ? 1 : TdkStyleLibraryDlg.this.paintingLib_.getId());
                        } else {
                            TdkStyle tdkStyle = (TdkStyle)TdkStyleLibraryDlg.this.listCanvas.getSelectedValue();
                            tdkStyle.setName(TdkStyleLibraryDlg.this.txStyleName.getText());
                            TdkStyleLibraryDlg.this.persServ_.updateStyle(TdkStyleLibraryDlg.this.dbDesc_, tdkStyle, TdkStyleLibraryDlg.this.paintingLib_.getId() == 0 ? 1 : TdkStyleLibraryDlg.this.paintingLib_.getId());
                        }
                        TdkStyleLibraryDlg.this.updateDialog();
                    } else {
                        TdkStyleLibraryDlg.this.selectedStyle = (TdkStyle)TdkStyleLibraryDlg.this.listCanvas.getSelectedValue();
                        TdkStyleLibraryDlg.this.setVisible(false);
                    }
                }
            });
        }
        return this.btnSave;
    }

    public TdkStyle getSelectedStyle() {
        return this.selectedStyle;
    }

    private JButton getBtnClose() {
        if (this.btnClose == null) {
            this.btnClose = new JButton();
            this.btnClose.setFont(new Font("Dialog", 0, 10));
            this.btnClose.setPreferredSize(new Dimension(78, 22));
            this.btnClose.setText(TdkComponentsI18n.getString("STYLE_DIALOG_CLOSE"));
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkStyleLibraryDlg.this.setVisible(false);
                }
            });
        }
        return this.btnClose;
    }

    private JTextField getTxStyleName() {
        if (this.txStyleName == null) {
            this.txStyleName = new JTextField();
            this.txStyleName.setMinimumSize(new Dimension(220, 20));
            this.txStyleName.setFont(new Font("Dialog", 0, 10));
            this.txStyleName.setPreferredSize(new Dimension(220, 20));
        }
        return this.txStyleName;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.jScrollPane.setViewportView(this.getListCanvas());
        }
        return this.jScrollPane;
    }

    private JList getListCanvas() {
        if (this.listCanvas == null) {
            this.UIResource = new DefaultListCellRenderer.UIResource();
            this.UIResource.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.UIResource.setDoubleBuffered(true);
            this.listCanvas = new JList();
            this.listCanvas.setAutoscrolls(false);
            this.listCanvas.setSelectionMode(0);
            this.listCanvas.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.listCanvas.setCursor(new Cursor(0));
            this.listCanvas.setFixedCellHeight(100);
            this.listCanvas.setFixedCellWidth(100);
            this.listCanvas.setFocusCycleRoot(false);
            this.listCanvas.setFont(new Font("Dialog", 0, 10));
            this.listCanvas.setDoubleBuffered(true);
            this.listCanvas.setValueIsAdjusting(false);
            this.listCanvas.setSelectionForeground(SystemColor.controlText);
            this.listCanvas.setSelectionBackground(SystemColor.desktop);
            this.listCanvas.setSelectedIndex(-1);
            this.listCanvas.setVisibleRowCount(3);
            this.listCanvas.setFocusTraversalPolicy(this.getDefaultFocusTraversalPolicy());
            this.listCanvas.setCellRenderer(this.UIResource);
            this.listCanvas.setLayoutOrientation(1);
            this.listCanvas.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (TdkStyleLibraryDlg.this.isUpdating) {
                        return;
                    }
                    if (mouseEvent.getButton() == 1) {
                        if (TdkStyleLibraryDlg.this.cbLibName.getModel().getSize() == 0) {
                            return;
                        }
                        if (TdkStyleLibraryDlg.this.paintingLib_.getStyles().size() == 0L) {
                            return;
                        }
                        TdkStyleLibraryDlg.this.txStyleName.setText(TdkStyleLibraryDlg.this.paintingLib_.getStyles().get(TdkStyleLibraryDlg.this.listCanvas.getSelectedIndex()).getName());
                    }
                }
            });
        }
        return this.listCanvas;
    }

    private void initialize() {
        this.setSize(601, 382);
        this.setSize(568, 408);
        this.setJMenuBar(this.getJJMenuBar());
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.setTitle(TdkComponentsI18n.getString("STYLE_DIALOG_LIBRARY_STYLE"));
        TdkDialogUtil.centralize(this, TdkDialogUtil.getFrameParent(this));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "South");
            this.jContentPane.add((Component)this.getJPanel2(), "North");
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jContentPane;
    }

    private void handleExportLib() {
        if (this.allLibraries_.size() == 0L) {
            JOptionPane.showMessageDialog(this, TdkComponentsI18n.getString("STYLE_DIALOG_ERROR_LIBRARY_STYLE_NOT_FOUND"));
            return;
        }
        TdkStyleLibraryVector tdkStyleLibraryVector = this.allLibraries_;
        try {
            String string = this.getFilePath();
            if (string == null) {
                return;
            }
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = TdkStyleLibrarySerializer.serializeStyleLibraryVector((TdkStyleLibraryVector)tdkStyleLibraryVector);
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getFilePath() {
        JFileChooser jFileChooser = new JFileChooser(TdkComponentsI18n.getString("STYLE_DIALOG_SAVE_AS"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".style");
            }

            @Override
            public String getDescription() {
                return "Style files *.style";
            }
        });
        if (jFileChooser.showOpenDialog(this.getContentPane()) == 1) {
            return null;
        }
        String string = jFileChooser.getSelectedFile().getPath();
        if (!string.endsWith(".style")) {
            string = string + ".style";
        }
        return string;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.setFont(new Font("Dialog", 0, 10));
            this.jJMenuBar.add(this.getJMenu());
            this.jJMenuBar.add(this.getJMenu3());
        }
        return this.jJMenuBar;
    }

    private JMenu getJMenu() {
        if (this.jMenu == null) {
            this.jMenu = new JMenu();
            this.jMenu.setText(TdkComponentsI18n.getString("STYLE_DIALOG_FILE"));
            this.jMenu.setFont(new Font("Dialog", 0, 10));
            this.jMenu.add(this.getJMenuItem());
            this.jMenu.add(this.getJMenuItem1());
            this.jMenu.add(new JSeparator());
            this.jMenu.add(this.getJMenuItem2());
        }
        return this.jMenu;
    }

    private JMenuItem getJMenuItem() {
        if (this.jMenuItem == null) {
            this.jMenuItem = new JMenuItem();
            this.jMenuItem.setText(TdkComponentsI18n.getString("STYLE_DIALOG_EXPORT"));
            this.jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkStyleLibraryDlg.this.handleExportLib();
                }
            });
        }
        return this.jMenuItem;
    }

    private JMenuItem getJMenuItem1() {
        if (this.jMenuItem1 == null) {
            this.jMenuItem1 = new JMenuItem();
            this.jMenuItem1.setText(TdkComponentsI18n.getString("STYLE_DIALOG_IMPORT"));
            this.jMenuItem1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkStyleLibraryDlg.this.handleImportLibrary();
                }
            });
        }
        return this.jMenuItem1;
    }

    private JMenuItem getJMenuItem2() {
        if (this.jMenuItem2 == null) {
            this.jMenuItem2 = new JMenuItem();
            this.jMenuItem2.setText(TdkComponentsI18n.getString("STYLE_DIALOG_CLOSE"));
            this.jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkStyleLibraryDlg.this.setVisible(false);
                }
            });
        }
        return this.jMenuItem2;
    }

    private JMenu getJMenu3() {
        if (this.jMenu3 == null) {
            this.jMenu3 = new JMenu();
            this.jMenu3.setText(TdkComponentsI18n.getString("STYLE_DIALOG_STYLE"));
            this.jMenu3.setFont(new Font("Dialog", 0, 10));
            this.jMenu3.add(this.getJMenuItem5());
            this.jMenu3.add(this.getJMenuItem6());
        }
        return this.jMenu3;
    }

    private JMenuItem getJMenuItem5() {
        if (this.jMenuItem5 == null) {
            this.jMenuItem5 = new JMenuItem();
            this.jMenuItem5.setText(TdkComponentsI18n.getString("STYLE_DIALOG_COPY"));
            this.jMenuItem5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkStyleLibraryDlg.this.handleCopyStyle();
                }
            });
        }
        return this.jMenuItem5;
    }

    protected void handleCopyStyle() {
        if (this.listCanvas.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(this, TdkComponentsI18n.getString("STYLE_DIALOG_ERROR_EMPTY_SELECION"), TdkComponentsI18n.getString("STYLE_DIALOG_INFORMATION"), 0);
            return;
        }
        String string = JOptionPane.showInputDialog(this, TdkComponentsI18n.getString("STYLE_DIALOG_NAME_REQUEST"), TdkComponentsI18n.getString("STYLE_DIALOG_INFORMATION"), 2);
        if (string == null || string.equals("")) {
            return;
        }
        TdkStyle tdkStyle = this.paintingLib_.getStyles().get(this.listCanvas.getSelectedIndex());
        tdkStyle.setName(string);
        this.persServ_.insertStyle(this.dbDesc_, tdkStyle, this.paintingLib_.getId());
        this.updateDialog();
    }

    private void handleDeleteStyle() {
        if (this.listCanvas.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(this, TdkComponentsI18n.getString("STYLE_DIALOG_ERROR_FIRST_SELECTION_INFORMATION"), TdkComponentsI18n.getString("STYLE_DIALOG_INFORMATION"), 0);
            return;
        }
        TdkStyle tdkStyle = this.paintingLib_.getStyles().get(this.listCanvas.getSelectedIndex());
        this.persServ_.deleteStyle(this.dbDesc_, tdkStyle.getId(), this.paintingLib_.getId());
        this.updateDialog();
    }

    private JMenuItem getJMenuItem6() {
        if (this.jMenuItem6 == null) {
            this.jMenuItem6 = new JMenuItem();
            this.jMenuItem6.setText(TdkComponentsI18n.getString("STYLE_DIALOG_REMOVE"));
            this.jMenuItem6.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkStyleLibraryDlg.this.handleDeleteStyle();
                }
            });
        }
        return this.jMenuItem6;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 8, 7, 15);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 49, 7, 7);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 5, 8, 49);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(null, TdkComponentsI18n.getString("STYLE_DIALOG_LYBRARY"), 0, 0, null, null);
            titledBorder.setTitleFont(new Font("Dialog", 1, 10));
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.setMinimumSize(new Dimension(452, 32));
            this.jPanel2.setPreferredSize(new Dimension(495, 53));
            this.jPanel2.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jPanel2.setBorder(titledBorder);
            this.jPanel2.add((Component)this.getCbLibName(), gridBagConstraints3);
            this.jPanel2.add((Component)this.getJButton2(), gridBagConstraints2);
            this.jPanel2.add((Component)this.getJButton3(), gridBagConstraints);
        }
        return this.jPanel2;
    }

    private JComboBox getCbLibName() {
        if (this.cbLibName == null) {
            this.cbLibName = new JComboBox();
            this.cbLibName.setFont(new Font("Dialog", 1, 10));
            this.cbLibName.setMinimumSize(new Dimension(261, 21));
            this.cbLibName.setPreferredSize(new Dimension(261, 21));
            this.cbLibName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TdkStyleLibraryDlg.this.cbLibName.getSelectedIndex();
                    if (TdkStyleLibraryDlg.this.isUpdating) {
                        return;
                    }
                    TdkStyleLibraryDlg.this.handleChangeLibraryList(n);
                }
            });
        }
        return this.cbLibName;
    }

    private JButton getJButton2() {
        if (this.jButton2 == null) {
            this.jButton2 = new JButton();
            this.jButton2.setFont(new Font("Dialog", 0, 10));
            this.jButton2.setPreferredSize(new Dimension(78, 22));
            this.jButton2.setText(TdkComponentsI18n.getString("STYLE_DIALOG_CREATE"));
            this.jButton2.setMinimumSize(new Dimension(74, 22));
            this.jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkStyleLibraryDlg.this.handleCreateLibrary();
                }
            });
        }
        return this.jButton2;
    }

    private JButton getJButton3() {
        if (this.jButton3 == null) {
            this.jButton3 = new JButton();
            this.jButton3.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.jButton3.setMinimumSize(new Dimension(74, 22));
            this.jButton3.setPreferredSize(new Dimension(78, 22));
            this.jButton3.setHorizontalAlignment(0);
            this.jButton3.setText(TdkComponentsI18n.getString("STYLE_DIALOG_REMOVE"));
            this.jButton3.setFont(new Font("Dialog", 0, 10));
            this.jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkStyleLibraryDlg.this.handleDeleteLibrary();
                }
            });
        }
        return this.jButton3;
    }

    private DefaultFocusTraversalPolicy getDefaultFocusTraversalPolicy() {
        if (this.defaultFocusTraversalPolicy == null) {
            this.defaultFocusTraversalPolicy = new DefaultFocusTraversalPolicy();
        }
        return this.defaultFocusTraversalPolicy;
    }

    protected void handleChangeLibraryList(int n) {
        this.isUpdating = true;
        if (this.cbLibName.getModel().getSize() == 0) {
            return;
        }
        this.updateDialog();
        this.listCanvas.setSelectedIndex(-1);
        this.txStyleName.setText("");
        this.isUpdating = false;
        this.cbLibName.setSelectedIndex(n);
    }

    private void handleCreateLibrary() {
        String string = JOptionPane.showInputDialog(null, (Object)TdkComponentsI18n.getString("STYLE_DIALOG_LYBRARY_NAME_REQUEST"));
        if (string == null || string.equals("")) {
            return;
        }
        for (int i = 0; i < this.cbLibName.getModel().getSize(); ++i) {
            String string2 = (String)this.cbLibName.getModel().getElementAt(i);
            if (!string.equals(string2)) continue;
            JOptionPane.showMessageDialog(null, TdkComponentsI18n.getString("STYLE_DIALOG_ERROR_USED_NAME"));
            return;
        }
        TdkStyleLibrary tdkStyleLibrary = new TdkStyleLibrary();
        tdkStyleLibrary.setName(string);
        this.persServ_.insertStyleLibrary(this.dbDesc_, tdkStyleLibrary);
        this.updateDialog();
    }

    private void handleDeleteLibrary() {
        if (this.allLibraries_.size() == 0L) {
            JOptionPane.showMessageDialog(this, TdkComponentsI18n.getString("STYLE_DIALOG_ERROR_LIBRARY_STYLE_NOT_FOUND"), TdkComponentsI18n.getString("STYLE_DIALOG_INFORMATION"), 2);
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, TdkComponentsI18n.getString("STYLE_DIALOG_LIBRARY_REMOVE_CONFIRMATION") + " " + this.paintingLib_.getName(), TdkComponentsI18n.getString("STYLE_DIALOG_INFORMATION"), 2);
        if (n != 0) {
            return;
        }
        TdkStyleLibrary tdkStyleLibrary = this.allLibraries_.get(this.cbLibName.getSelectedIndex());
        try {
            this.persServ_.deleteStyleLibrary(this.dbDesc_, tdkStyleLibrary.getId());
        }
        catch (Exception exception) {
            this.updateDialog();
        }
        this.updateDialog();
    }

    private void handleImportLibrary() {
        String string = this.getFilePath();
        if (string == null) {
            return;
        }
        this.setCursor(new Cursor(3));
        File file = new File(string);
        try {
            TdkStyleLibrary tdkStyleLibrary;
            FileInputStream fileInputStream = new FileInputStream(file);
            TdkStyleLibraryVector tdkStyleLibraryVector = TdkStyleLibrarySerializer.deserializeStyleLibraryVector((FileInputStream)fileInputStream);
            Hashtable<String, TdkStyleLibrary> hashtable = new Hashtable<String, TdkStyleLibrary>();
            int n = 0;
            while ((long)n < this.allLibraries_.size()) {
                tdkStyleLibrary = this.allLibraries_.get(n);
                hashtable.put(tdkStyleLibrary.getName(), tdkStyleLibrary);
                ++n;
            }
            n = 0;
            while ((long)n < tdkStyleLibraryVector.size()) {
                Object object;
                tdkStyleLibrary = tdkStyleLibraryVector.get(n);
                if (hashtable.containsKey(tdkStyleLibrary.getName())) {
                    object = tdkStyleLibrary.getName() + "_" + String.valueOf(n);
                    String string2 = JOptionPane.showInputDialog(this, TdkComponentsI18n.getString("STYLE_DIALOG_LIBRARY_NAME_VERIFIFICATION_PART_ONE") + " " + tdkStyleLibrary.getName() + " " + TdkComponentsI18n.getString("STYLE_DIALOG_LIBRARY_NAME_VERIFIFICATION_PART_TOO") + (String)object, TdkComponentsI18n.getString("STYLE_DIALOG_INFORMATION"), 0);
                    if (string2 != null && !string2.equals("")) {
                        object = string2;
                    }
                    tdkStyleLibrary.setName((String)object);
                }
                if (!this.insertNewStyleLibrary(tdkStyleLibrary)) {
                    _logger.error((Object)("Error importing new library \"" + tdkStyleLibrary.getName() + "\""));
                } else {
                    object = tdkStyleLibrary.getStyles();
                    int n2 = 0;
                    while ((long)n2 < object.size()) {
                        TdkStyle tdkStyle = object.get(n2);
                        if (!this.persServ_.insertStyle(this.dbDesc_, tdkStyle, tdkStyleLibrary.getId())) {
                            _logger.error((Object)("Error impoting new library style. Library Name: " + tdkStyleLibrary.getName() + ". Style: " + tdkStyle.getName()));
                        }
                        ++n2;
                    }
                    this.allLibraries_.add(tdkStyleLibrary);
                }
                ++n;
            }
            this.updateDialog();
            this.setCursor(new Cursor(0));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            this.setCursor(new Cursor(0));
            JOptionPane.showMessageDialog(null, fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.setCursor(new Cursor(0));
            JOptionPane.showMessageDialog(null, iOException.getLocalizedMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setCursor(new Cursor(0));
            JOptionPane.showMessageDialog(null, exception.getLocalizedMessage());
        }
    }

    private boolean insertNewStyleLibrary(TdkStyleLibrary tdkStyleLibrary) {
        return this.persServ_.insertStyleLibrary(this.dbDesc_, tdkStyleLibrary);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof Integer)) {
            return;
        }
    }
}

