/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleCharTableModel;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleCharacterTableRenderer;
import org.tecgraf.jtdk.desktop.components.util.TdkColorChooser;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;

public class TdkStyleCharTableDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JPanel jPanel1 = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private Font font_ = null;
    private JTableHeader jTableHeader = null;
    private String character_ = "";
    private int w_ = 0;
    private int h_ = 0;
    private String[][] values = null;
    private TdkStyleCharacterTableRenderer renderer_ = null;
    private boolean CLOSE_BTN = true;
    private JButton jButton2 = null;
    private Color color_ = new Color(0, 0, 0);
    private JLabel jLabel = null;
    private JTextField jTextField = null;
    private JPanel jPanel2 = null;
    private int charCode = 0;
    private int fontsize = 25;

    public TdkStyleCharTableDlg(Font font, Color color, Dialog dialog) {
        super(dialog);
        Object object;
        this.initialize();
        this.color_ = color;
        this.font_ = font;
        this.values = new String[16][16];
        this.fontsize = 18;
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            object = new String[16];
            for (int j = 0; j < 16; ++j) {
                object[j] = String.valueOf((char)n) == null ? String.valueOf('\u0000') : String.valueOf((char)n);
                ++n;
            }
            this.values[i] = object;
        }
        TdkStyleCharTableModel tdkStyleCharTableModel = new TdkStyleCharTableModel((Object[][])this.values, 16);
        this.jTable.setModel(tdkStyleCharTableModel);
        this.renderer_ = new TdkStyleCharacterTableRenderer(this.values, this.font_, this.color_);
        object = this.jTable.getColumnModel();
        Enumeration<TableColumn> enumeration = object.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setMinWidth(this.fontsize);
            tableColumn.setMaxWidth(this.fontsize);
            tableColumn.setPreferredWidth(this.fontsize);
            tableColumn.setCellRenderer(this.renderer_);
        }
        this.jTable.setRowHeight(this.fontsize);
        this.jTable.setColumnModel((TableColumnModel)object);
        TdkDialogUtil.centralize(this, TdkDialogUtil.getFrameParent(this));
    }

    public String getSelectedChar() {
        if (this.CLOSE_BTN) {
            return null;
        }
        return this.values[this.w_][this.h_];
    }

    private void initialize() {
        this.setSize(492, 390);
        this.setTitle("Caracter Map");
        this.setResizable(true);
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJScrollPane(), "Center");
            this.jPanel.add((Component)this.getJPanel1(), "South");
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            JPanel jPanel = new JPanel();
            jPanel.add(this.getJTable());
            this.jScrollPane = new JScrollPane(jPanel);
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setSelectionMode(0);
            this.jTable.setColumnSelectionAllowed(true);
            this.jTable.setTableHeader(this.getJTableHeader());
            this.jTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = TdkStyleCharTableDlg.this.jTable.getSelectedColumn();
                    int n2 = TdkStyleCharTableDlg.this.jTable.getSelectedRow();
                    if (n < 0 || n > 255) {
                        return;
                    }
                    if (n2 < 0 || n2 > 255) {
                        return;
                    }
                    TdkStyleCharTableDlg.this.w_ = n;
                    TdkStyleCharTableDlg.this.h_ = n2;
                    TdkStyleCharTableDlg.this.jTextField.setText(TdkStyleCharTableDlg.this.values[TdkStyleCharTableDlg.this.w_][TdkStyleCharTableDlg.this.h_]);
                    if (mouseEvent.getClickCount() == 2) {
                        TdkStyleCharTableDlg.this.CLOSE_BTN = false;
                        TdkStyleCharTableDlg.this.setVisible(false);
                    }
                }
            });
        }
        return this.jTable;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Caracter:");
            this.jLabel.setFont(new Font("Dialog", 1, 10));
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            flowLayout.setHgap(15);
            flowLayout.setVgap(9);
            this.jPanel1 = new JPanel();
            this.jPanel1.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanel1.setLayout(flowLayout);
            this.jPanel1.add((Component)this.jLabel, null);
            this.jPanel1.add((Component)this.getJTextField(), null);
            this.jPanel1.add((Component)this.getJPanel2(), null);
            this.jPanel1.add((Component)this.getJButton1(), null);
            this.jPanel1.add((Component)this.getJButton(), null);
            this.jPanel1.add((Component)this.getJButton2(), null);
        }
        return this.jPanel1;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Fechar");
            this.jButton.setFont(new Font("Dialog", 1, 10));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkStyleCharTableDlg.this.CLOSE_BTN = true;
                    TdkStyleCharTableDlg.this.setVisible(false);
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.jButton1.setFont(new Font("Dialog", 1, 10));
            this.jButton1.setPreferredSize(new Dimension(67, 24));
            this.jButton1.setText("Ok");
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkStyleCharTableDlg.this.CLOSE_BTN = false;
                    TdkStyleCharTableDlg.this.setVisible(false);
                    TdkStyleCharTableDlg.this.getOwner().repaint();
                }
            });
        }
        return this.jButton1;
    }

    private JTableHeader getJTableHeader() {
        if (this.jTableHeader == null) {
            this.jTableHeader = new JTableHeader();
            this.jTableHeader.setVisible(false);
        }
        return this.jTableHeader;
    }

    private JButton getJButton2() {
        if (this.jButton2 == null) {
            this.jButton2 = new JButton();
            this.jButton2.setText("Cor");
            this.jButton2.setMnemonic(79);
            this.jButton2.setVisible(false);
            this.jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = TdkColorChooser.showDialog(TdkStyleCharTableDlg.this, TdkStyleCharTableDlg.this.color_);
                    if (color == null) {
                        return;
                    }
                    TdkStyleCharTableDlg.this.color_ = new Color(color.getRed(), color.getGreen(), color.getBlue());
                    TdkStyleCharTableDlg.this.renderer_.setColor(TdkStyleCharTableDlg.this.color_);
                }
            });
        }
        return this.jButton2;
    }

    public Color getColor() {
        return this.color_;
    }

    public String getCharacter() {
        return this.character_;
    }

    public void setCharacter(String string) {
        this.character_ = string;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField();
            this.jTextField.setFont(new Font("Dialog", 1, 12));
            this.jTextField.setPreferredSize(new Dimension(30, 24));
            this.jTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    TdkStyleCharTableDlg.this.charCode = keyEvent.getKeyChar();
                    TdkStyleCharTableDlg.this.w_ = TdkStyleCharTableDlg.this.charCode / 16;
                    TdkStyleCharTableDlg.this.h_ = TdkStyleCharTableDlg.this.charCode % 16;
                    TdkStyleCharTableDlg.this.jTable.changeSelection(TdkStyleCharTableDlg.this.h_, TdkStyleCharTableDlg.this.w_, false, false);
                    TdkStyleCharTableDlg.this.jTextField.select(0, TdkStyleCharTableDlg.this.jTextField.getText().length());
                }
            });
        }
        return this.jTextField;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setPreferredSize(new Dimension(20, 10));
        }
        return this.jPanel2;
    }
}

